/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.CCSProxy;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.LocalBuilders;
import org.lsst.ccs.command.LocalCommandDictionary;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.structs.ViewValue;

public interface Configurable {
    public void setEnvironment(Environment var1);

    public Environment getEnvironment();

    public void change(String var1, Object var2) throws Exception;

    public static class Environment {
        private static final HashMap<String, Map<String, Method>> METHOD_MAP = new HashMap();
        private final String name;
        private final Object relevantObject;
        private final Map<String, Method> configMethods;
        private final ConfigurationProxy configurationProxy;
        private final ComponentLookupService lookupService;
        private final LocalCommandDictionary commandBuilder;

        public Environment(String name, Configurable currentObject, ConfigurationProxy configurationProxy, ComponentLookupService lookupService) {
            this.name = name;
            this.relevantObject = currentObject instanceof CCSProxy ? ((CCSProxy)((Object)currentObject)).getDelegate() : currentObject;
            this.configurationProxy = configurationProxy;
            this.lookupService = lookupService;
            Class<?> clazz = this.relevantObject.getClass();
            this.commandBuilder = LocalBuilders.factory(clazz);
            String clazzName = clazz.getName();
            Map<String, Method> confMethods = METHOD_MAP.get(clazzName);
            if (confMethods == null) {
                this.configMethods = new HashMap<String, Method>();
                METHOD_MAP.put(clazzName, this.configMethods);
                Method[] methodArray = clazz.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    String methodName = method.getName();
                    ConfigChanger configChanger = method.getAnnotation(ConfigChanger.class);
                    if (configChanger != null) {
                        String propertyName;
                        if (methodName.startsWith("set")) {
                            char firstLetter = methodName.charAt(3);
                            String propertyName2 = String.valueOf(Character.toLowerCase(firstLetter)) + methodName.substring(4);
                            this.configMethods.put(propertyName2, method);
                        }
                        if (!"".equals(propertyName = configChanger.propertyName())) {
                            this.configMethods.put(propertyName, method);
                        }
                    }
                    ++n2;
                }
            } else {
                this.configMethods = confMethods;
            }
        }

        public void newConfigurationContext() {
            this.configurationProxy.startNewConfigurationContext();
        }

        public void change(String parameterName, Object value) throws Exception {
            Method method = this.configMethods.get(parameterName);
            if (method == null) {
                throw new IllegalArgumentException(" no such config property :" + parameterName);
            }
            ViewValue data = this.configurationProxy.checkForParameterChange(this.name, parameterName, value);
            method.invoke(this.relevantObject, data.getValue());
            this.configurationProxy.notifyParameterChange(this.name, parameterName, data.getView());
        }

        public void register(String configurationName, String tag) throws IOException {
            this.configurationProxy.registerConfiguration(configurationName, tag);
        }

        public void register(String configurationName) throws IOException {
            this.register(configurationName, "");
        }

        public void dropConfigurationContext() {
            this.configurationProxy.dropModifications();
        }

        public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
            ViewValue data = this.configurationProxy.checkForParameterChange(this.name, parameterName, value);
            return data;
        }

        public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
            this.configurationProxy.notifyUncheckedParameterChange(this.name, parameterName, value);
        }

        protected void notifyChange(String parameterName, String value) throws Exception {
            this.configurationProxy.notifyParameterChange(this.name, parameterName, value);
        }

        public Object getComponentByName(String name) {
            return this.lookupService.getComponentByName(name);
        }

        public void alias(String name) {
            this.lookupService.aliasObject(name, this.relevantObject);
        }

        public <T> Map<String, T> getChildren(Class<T> classFilter) {
            return this.lookupService.getChildren(this.name, classFilter);
        }

        public Map.Entry<String, Object> getParent() {
            return this.lookupService.getParent(this.name);
        }

        public String getNameOfComponent() {
            return this.name;
        }

        public Object getRelevantObject() {
            return this.relevantObject;
        }

        public Map<String, Method> getConfigMethodsOfComponent() {
            return this.configMethods;
        }

        public LocalCommandDictionary getCommandBuilder() {
            return this.commandBuilder;
        }

        public Dictionary getDictionary() {
            if (this.commandBuilder != null) {
                return this.commandBuilder.getCommandDictionary();
            }
            return null;
        }
    }
}

