/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.command.CompositeCommandDictionary;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryContext;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.ModuleRegistry;
import org.lsst.ccs.framework.NodeCommand;
import org.lsst.ccs.framework.NodeTreeWalker;
import org.lsst.ccs.framework.NodesFunction;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.TreeBranch;
import org.lsst.ccs.utilities.structs.ViewValue;

public class Module
extends Observable
implements Observer,
Configurable,
SignalHandler {
    public static ModuleRegistry registry;
    Context context;
    protected Configurable.Environment environment;
    protected static Logger log;
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int nObserverThreads = 1;
    protected int tickMillis = -1;
    TimerTask timerTask;
    ExecutorService exec;
    Timer timer;
    private static Observable[] model;

    static {
        log = Logger.getLogger((String)"org.lsst.ccs.framework");
        model = new Observable[0];
    }

    public Module() {
    }

    public Module(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public Module(String name, int tickMillis) {
        this.name = name;
        this.tickMillis = tickMillis;
    }

    public Module(String name) {
        this(name, -1);
    }

    public String getName() {
        if (this.name == null && this.environment != null) {
            this.name = this.environment.getNameOfComponent();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void alias(String alias) {
        if (registry == null) {
            log.warn((Object)"cannot call alias in build phase (in constructors)", new String[0]);
        } else {
            registry.aliasModule(alias, this);
        }
        if (this.environment != null) {
            this.environment.alias(alias);
        }
    }

    @Override
    public Configurable.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Configurable.Environment environment) {
        this.environment = environment;
    }

    public void setObservables(List<Observable> l) {
        this.observables.addAll(l);
    }

    public void listens(Observable ... observs) {
        Observable[] observableArray = observs;
        int n = observs.length;
        int n2 = 0;
        while (n2 < n) {
            Observable observable = observableArray[n2];
            this.observables.add(observable);
            ++n2;
        }
    }

    public List<Observable> getObservables() {
        return this.observables;
    }

    @ConfigChanger(argNames={"tickInterval"})
    public void setTickMillis(int tickMillis) {
        int old = this.tickMillis;
        this.tickMillis = tickMillis;
        if (this.timerTask != null && this.timer != null && tickMillis != old) {
            this.timerTask.cancel();
            if (tickMillis > 0) {
                this.timerTask = new TimerTask(){
                    CurrentCommandContext context;
                    {
                        this.context = new CurrentCommandContext("timer_" + Module.this.getName(), "tick");
                    }

                    @Override
                    public void run() {
                        Subsystem.LOCAL_EXECUTION_INFO.set(this.context);
                        Module.this.tick();
                    }
                };
                this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)tickMillis);
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    public final void init() {
        this.injectResources();
        this.initModule();
        for (Observable o : this.observables) {
            o.addObserver(this);
        }
        this.exec = Executors.newFixedThreadPool(this.nObserverThreads);
    }

    protected void injectResources() {
        Class<?> clazz = this.getClass();
        while (clazz.getCanonicalName().startsWith("org.lsst")) {
            Field[] fields;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Resource resource = field.getAnnotation(Resource.class);
                if (resource != null) {
                    String name = resource.name();
                    if (name == null || "".equals(name)) {
                        name = field.getName();
                    }
                    Object toInject = this.environment.getComponentByName(name);
                    if (name == null) {
                        log.warn((Object)(String.valueOf(this.getName()) + " No possible injection for " + name), new String[]{"INIT"});
                    } else {
                        try {
                            field.setAccessible(true);
                            field.set(this, toInject);
                            log.info((Object)(toInject + " object injected in " + name + "field  "), new String[]{"INIT"});
                        }
                        catch (IllegalAccessException e) {
                            log.warn((Object)(String.valueOf(this.getName()) + " No possible injection for " + name), (Throwable)e, new String[]{"INIT"});
                        }
                    }
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    public void initModule() {
    }

    public <T> Map<String, T> getChildren(Class<T> clazz) {
        return this.environment.getChildren(clazz);
    }

    public Map.Entry<String, Object> getParent() {
        return this.environment.getParent();
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Subsystem getSubsystem() {
        return this.getContext().getSubsystem();
    }

    public Module getModule(String moduleName) {
        if (registry != null) {
            return registry.getModule(moduleName);
        }
        return null;
    }

    public Object getComponentByName(String name) {
        return this.environment.getComponentByName(name);
    }

    public void start() {
    }

    public void startTicking() {
        this.timer = new Timer("timer_" + this.name);
        this.timerTask = new TimerTask(){
            CurrentCommandContext context;
            {
                this.context = new CurrentCommandContext("timer_" + Module.this.getName(), "tick");
            }

            @Override
            public void run() {
                Subsystem.LOCAL_EXECUTION_INFO.set(this.context);
                Module.this.tick();
            }
        };
        if (this.tickMillis > 0) {
            this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)this.tickMillis);
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg), new String[0]);
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                Module.this.processUpdate(o, (ValueUpdate)arg);
            }
        });
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    public void setBeanName(String n) {
        this.name = n;
    }

    @Deprecated
    public void setStateModularSubsystem(PublishedState newState) {
        this.setStateModularSubsystem(newState, "");
    }

    @Deprecated
    public void setStateModularSubsystem(PublishedState newState, String extraInfo) {
    }

    @Deprecated
    public void publishData(String name, Object value, long tStamp) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(name, value, tStamp);
    }

    @Deprecated
    public void publishData(String name, Serializable value, long tStamp) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(name, value, tStamp);
    }

    @Deprecated
    public void publishData(String name, Object value) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(name, value);
    }

    @Deprecated
    public void publishData(String name, Serializable value) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(name, value);
    }

    @Deprecated
    public void publishData(List<ValueNotification> tdl) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(tdl);
    }

    @Deprecated
    public void publishData(ValueNotification td) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(td);
    }

    @Deprecated
    public void publishData(DataValueNotification td) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method publishData", new String[0]);
        this.getSubsystem().publishData(td);
    }

    @Deprecated
    public void sendToStatus(Status status) {
        CCSCst.LOG_DEPRECATED.warn((Object)"using deprecated method sendToStatus", new String[0]);
        this.getSubsystem().broadcastStatus(status);
    }

    public void publish(long timestamp, String key, Object value) {
        this.getSubsystem().publishStatus(timestamp, key, value);
    }

    public void publish(String key, Object value) {
        this.getSubsystem().publishStatus(key, value);
    }

    public void publish(long timestamp, KVList kvlist) {
        this.getSubsystem().publishStatus(timestamp, kvlist);
    }

    public void publish(KVList kvlist) {
        this.getSubsystem().publishStatus(kvlist);
    }

    public void publish(String key, long[] timestamps, Object[] objects) {
        this.getSubsystem().publishStatus(key, timestamps, objects);
    }

    public void publish(List<ValueNotification> tdl) {
        this.getSubsystem().publishStatus(tdl);
    }

    @Deprecated
    public void sendToReply(CommandReply myReply) {
        log.warn((Object)"using deprecated method sendToReply", new String[0]);
        this.getSubsystem().publishReply(myReply);
    }

    public void shutdownNow() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    @Command(description="Deprecated :will shutdown the subsystem (asynchronous execution)", type=Command.CommandType.ACTION)
    public void shutdownCommand() throws HardwareException {
        this.getSubsystem().shutdown();
    }

    @Override
    public TreeWalkerDiag signal(Signal sig) {
        return TreeWalkerDiag.GO;
    }

    @Command(description="will propagate signal to Module and its children ", type=Command.CommandType.ABORT)
    public void sendSignal(String signalString) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel);
        this.percolateSignal(signal);
    }

    @Command(description="will propagate signal to Module and its children with  an expected maximum delay", type=Command.CommandType.ABORT)
    public void sendSignal(long expectedMaxDelay, String signalString) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel, expectedMaxDelay);
        this.percolateSignal(signal);
    }

    public void percolateSignal(final Signal signal) {
        NodeTreeWalker treeWalker = new NodeTreeWalker(new NodeCommand(){

            @Override
            public TreeWalkerDiag evalOn(Configurable configurable) {
                if (configurable instanceof SignalHandler) {
                    SignalHandler signalHandler = (SignalHandler)((Object)configurable);
                    return signalHandler.signal(signal);
                }
                return TreeWalkerDiag.GO;
            }
        });
        treeWalker.invokeOn(this);
    }

    @Command(description="publishes a tree of component names", type=Command.CommandType.QUERY)
    public TreeBranch<String> getComponentTree() {
        NodesFunction<TreeBranch<String>> nodesFunction = new NodesFunction<TreeBranch<String>>(){
            {
                this.result = null;
            }

            @Override
            public TreeWalkerDiag evalOn(Configurable configurable) {
                TreeBranch thatNode = new TreeBranch((TreeBranch)this.result, (Serializable)((Object)configurable.getEnvironment().getNameOfComponent()));
                this.result = thatNode;
                return TreeWalkerDiag.GO;
            }

            @Override
            public void postChildrenVisit(Configurable configurable) {
                TreeBranch parent = ((TreeBranch)this.result).getRealParent();
                if (parent != null) {
                    this.result = parent;
                }
            }
        };
        NodeTreeWalker walker = new NodeTreeWalker(nodesFunction);
        walker.invokeOn(this);
        return (TreeBranch)nodesFunction.getResult();
    }

    @Command(description="returns the Command dictionary for this component", type=Command.CommandType.QUERY)
    public Dictionary getDictionary() {
        return this.environment.getDictionary();
    }

    @Command(description="publishes the topmost command dictionary", type=Command.CommandType.QUERY)
    public Dictionary getMainDictionary() {
        if (!"main".equals(this.getName())) {
            throw new IllegalArgumentException("can't get the top dictionary from a Module which is not main");
        }
        CompositeCommandDictionary res = new CompositeCommandDictionary();
        Subsystem subsystem = this.getSubsystem();
        res.add(subsystem.getSystemDictionary());
        res.add(this.getDictionary());
        return res;
    }

    @Command(description="publishes a tree of component dictionary", type=Command.CommandType.QUERY)
    public TreeBranch<DictionaryContext> getComponentDictionariesTree() {
        NodesFunction<TreeBranch<DictionaryContext>> nodesFunction = new NodesFunction<TreeBranch<DictionaryContext>>(){
            {
                this.result = null;
            }

            @Override
            public TreeWalkerDiag evalOn(Configurable configurable) {
                Configurable.Environment env = configurable.getEnvironment();
                DictionaryContext dictionaryContext = new DictionaryContext(env.getNameOfComponent(), env.getDictionary());
                TreeBranch thatNode = new TreeBranch((TreeBranch)this.result, (Serializable)dictionaryContext);
                this.result = thatNode;
                return TreeWalkerDiag.GO;
            }

            @Override
            public void postChildrenVisit(Configurable configurable) {
                TreeBranch parent = ((TreeBranch)this.result).getRealParent();
                if (parent != null) {
                    this.result = parent;
                }
            }
        };
        NodeTreeWalker walker = new NodeTreeWalker(nodesFunction);
        walker.invokeOn(this);
        TreeBranch res = (TreeBranch)nodesFunction.getResult();
        return res;
    }

    @Command(description="will create a new context for modifying parameters (engineering mode)", type=Command.CommandType.CONFIGURATION)
    public final void newConfigurationContext() {
        this.environment.newConfigurationContext();
    }

    @Override
    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION)
    public final void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) throws Exception {
        this.environment.change(parameterName, value);
    }

    @Command(description="registers a new configuration with name and tag", type=Command.CommandType.CONFIGURATION)
    public final void register(@Argument(name="configurationName", description="The Name of the Configuration") String configurationName, @Argument(name="tag", description="The new tag name", defaultValue="") String tag) throws IOException {
        this.environment.register(configurationName, tag);
    }

    @Command(description="will drop context for modifying parameters (engineering mode)", type=Command.CommandType.CONFIGURATION)
    public void dropConfigurationContext() {
        this.environment.dropConfigurationContext();
    }

    protected ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.environment.getCheckedValueFromConfiguration(parameterName, value);
        return data;
    }

    protected void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.environment.notifyChangeWithoutPreliminaryChecks(parameterName, value);
    }

    protected void notifyChange(String parameterName, String value) throws Exception {
        this.environment.notifyChange(parameterName, value);
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

