/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.MBeanServer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.demos.DrawCommand;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class Draw
extends ReceiverAdapter
implements ActionListener,
ChannelListener {
    String groupname = "DrawGroupDemo";
    private Channel channel = null;
    private int member_size = 1;
    private JFrame mainFrame = null;
    private JPanel sub_panel = null;
    private DrawPanel panel = null;
    private JButton clear_button;
    private JButton leave_button;
    private final Random random = new Random(System.currentTimeMillis());
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final Color draw_color = this.selectColor();
    private static final Color background_color = Color.white;
    boolean no_channel = false;
    boolean jmx;
    private boolean use_state = false;
    private long state_timeout = 5000L;
    private boolean use_unicasts = false;
    private final List<Address> members = new ArrayList<Address>();

    public Draw(String props, boolean no_channel, boolean jmx, boolean use_state, long state_timeout, boolean use_unicasts, String name) throws Exception {
        this.no_channel = no_channel;
        this.jmx = jmx;
        this.use_state = use_state;
        this.state_timeout = state_timeout;
        this.use_unicasts = use_unicasts;
        if (no_channel) {
            return;
        }
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.channel.setReceiver(this);
        this.channel.addChannelListener(this);
    }

    public Draw(Channel channel) throws Exception {
        this.channel = channel;
        channel.setReceiver(this);
        channel.addChannelListener(this);
    }

    public Draw(Channel channel, boolean use_state, long state_timeout) throws Exception {
        this.channel = channel;
        channel.setReceiver(this);
        channel.addChannelListener(this);
        this.use_state = use_state;
        this.state_timeout = state_timeout;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public void setGroupName(String groupname) {
        if (groupname != null) {
            this.groupname = groupname;
        }
    }

    public static void main(String[] args) {
        Draw draw = null;
        String props = null;
        boolean no_channel = false;
        boolean jmx = true;
        boolean use_state = false;
        String group_name = null;
        long state_timeout = 5000L;
        boolean use_unicasts = false;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                Draw.help();
                return;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-no_channel".equals(args[i])) {
                no_channel = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-groupname".equals(args[i])) {
                group_name = args[++i];
                continue;
            }
            if ("-state".equals(args[i])) {
                use_state = true;
                continue;
            }
            if ("-timeout".equals(args[i])) {
                state_timeout = Long.parseLong(args[++i]);
                continue;
            }
            if ("-bind_addr".equals(args[i])) {
                System.setProperty("jgroups.bind_addr", args[++i]);
                continue;
            }
            if ("-use_unicasts".equals(args[i])) {
                use_unicasts = true;
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            Draw.help();
            return;
        }
        try {
            draw = new Draw(props, no_channel, jmx, use_state, state_timeout, use_unicasts, name);
            if (group_name != null) {
                draw.setGroupName(group_name);
            }
            draw.go();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(0);
        }
    }

    static void help() {
        System.out.println("\nDraw [-help] [-no_channel] [-props <protocol stack definition>] [-groupname <name>] [-state] [-timeout <state timeout>] [-use_unicasts] [-bind_addr <addr>] [-jmx <true | false>] [-name <logical name>]");
        System.out.println("-no_channel: doesn't use JGroups at all, any drawing will be relected on the whiteboard directly");
        System.out.println("-props: argument can be an old-style protocol stack specification, or it can be a URL. In the latter case, the protocol specification will be read from the URL\n");
    }

    private Color selectColor() {
        int red = Math.abs(this.random.nextInt()) % 255;
        int green = Math.abs(this.random.nextInt()) % 255;
        int blue = Math.abs(this.random.nextInt()) % 255;
        return new Color(red, green, blue);
    }

    private void sendToAll(byte[] buf) throws Exception {
        for (Address mbr : this.members) {
            Message msg = new Message(mbr, null, buf);
            this.channel.send(msg);
        }
    }

    public void go() throws Exception {
        if (!this.no_channel && !this.use_state) {
            this.channel.connect(this.groupname);
        }
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.panel = new DrawPanel(this.use_state);
        this.panel.setBackground(background_color);
        this.sub_panel = new JPanel();
        this.mainFrame.getContentPane().add("Center", this.panel);
        this.clear_button = new JButton("Clear");
        this.clear_button.setFont(this.default_font);
        this.clear_button.addActionListener(this);
        this.leave_button = new JButton("Leave");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.getContentPane().add("South", this.sub_panel);
        this.mainFrame.setBackground(background_color);
        this.clear_button.setForeground(Color.blue);
        this.leave_button.setForeground(Color.blue);
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        this.mainFrame.setBounds(new Rectangle(250, 250));
        if (!this.no_channel && this.use_state) {
            this.channel.connect(this.groupname, null, this.state_timeout);
        }
        this.mainFrame.setVisible(true);
        this.setTitle();
    }

    void setTitle(String title) {
        String tmp = "";
        if (this.no_channel) {
            this.mainFrame.setTitle(" Draw Demo ");
            return;
        }
        if (title != null) {
            this.mainFrame.setTitle(title);
        } else {
            if (this.channel.getAddress() != null) {
                tmp = tmp + this.channel.getAddress();
            }
            tmp = tmp + " (" + this.member_size + ")";
            this.mainFrame.setTitle(tmp);
        }
    }

    void setTitle() {
        this.setTitle(null);
    }

    @Override
    public void receive(Message msg) {
        byte[] buf = msg.getRawBuffer();
        if (buf == null) {
            System.err.println("[" + this.channel.getAddress() + "] received null buffer from " + msg.getSrc() + ", headers: " + msg.printHeaders());
            return;
        }
        try {
            DrawCommand comm = (DrawCommand)Util.streamableFromByteBuffer(DrawCommand.class, buf, msg.getOffset(), msg.getLength());
            switch (comm.mode) {
                case 1: {
                    if (this.panel != null) {
                        this.panel.drawPoint(comm);
                    }
                    break;
                }
                case 2: {
                    this.clearPanel();
                    break;
                }
                default: {
                    System.err.println("***** received invalid draw command " + comm.mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void viewAccepted(View v) {
        this.member_size = v.size();
        if (this.mainFrame != null) {
            this.setTitle();
        }
        this.members.clear();
        this.members.addAll(v.getMembers());
        if (v instanceof MergeView) {
            System.out.println("** MergeView=" + v);
            if (this.use_state && !this.members.isEmpty()) {
                Address coord = this.members.get(0);
                Address local_addr = this.channel.getAddress();
                if (local_addr != null && !local_addr.equals(coord)) {
                    try {
                        System.out.println("fetching state from " + coord);
                        this.channel.getState(coord, 5000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println("** View=" + v);
        }
    }

    @Override
    public void getState(OutputStream ostream) throws Exception {
        this.panel.writeState(ostream);
    }

    @Override
    public void setState(InputStream istream) throws Exception {
        this.panel.readState(istream);
    }

    public void clearPanel() {
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void sendClearPanelMsg() {
        DrawCommand comm = new DrawCommand(2);
        try {
            byte[] buf = Util.streamableToByteBuffer(comm);
            if (this.use_unicasts) {
                this.sendToAll(buf);
            } else {
                this.channel.send(new Message(null, null, buf));
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Clear".equals(command)) {
            if (this.no_channel) {
                this.clearPanel();
                return;
            }
            this.sendClearPanelMsg();
        } else if ("Leave".equals(command)) {
            this.stop();
        } else {
            System.out.println("Unknown action");
        }
    }

    public void stop() {
        if (!this.no_channel) {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    @Override
    public void channelConnected(Channel channel) {
        if (this.jmx) {
            Util.registerChannel((JChannel)channel, "jgroups");
        }
    }

    @Override
    public void channelDisconnected(Channel channel) {
        MBeanServer server;
        if (this.jmx && (server = Util.getMBeanServer()) != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)channel, server, this.groupname);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void channelClosed(Channel channel) {
    }

    private class DrawPanel
    extends JPanel
    implements MouseMotionListener {
        final Dimension preferred_size = new Dimension(235, 170);
        Image img = null;
        Dimension d;
        Dimension imgsize = null;
        Graphics gr = null;
        final Map<Point, Color> state;

        public DrawPanel(boolean use_state) {
            this.state = use_state ? new LinkedHashMap<Point, Color>() : null;
            this.createOffscreenImage(false);
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (DrawPanel.this.getWidth() <= 0 || DrawPanel.this.getHeight() <= 0) {
                        return;
                    }
                    DrawPanel.this.createOffscreenImage(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeState(OutputStream outstream) throws IOException {
            if (this.state == null) {
                return;
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(outstream, 4096));
                dos.writeInt(this.state.size());
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point point = entry.getKey();
                    Color col = entry.getValue();
                    dos.writeInt(point.x);
                    dos.writeInt(point.y);
                    dos.writeInt(col.getRGB());
                }
                dos.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readState(InputStream instream) throws IOException {
            DataInputStream in = new DataInputStream(instream);
            HashMap<Point, Color> new_state = new HashMap<Point, Color>();
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                Point point = new Point(in.readInt(), in.readInt());
                Color col = new Color(in.readInt());
                new_state.put(point, col);
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                this.state.clear();
                this.state.putAll(new_state);
                System.out.println("read state: " + this.state.size() + " entries");
                this.createOffscreenImage(true);
            }
        }

        final void createOffscreenImage(boolean discard_image) {
            this.d = this.getSize();
            if (discard_image) {
                this.img = null;
                this.imgsize = null;
            }
            if (this.img == null || this.imgsize == null || this.imgsize.width != this.d.width || this.imgsize.height != this.d.height) {
                this.img = this.createImage(this.d.width, this.d.height);
                if (this.img != null) {
                    this.gr = this.img.getGraphics();
                    if (this.gr != null && this.state != null) {
                        this.drawState();
                    }
                }
                this.imgsize = this.d;
            }
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            DrawCommand comm = new DrawCommand(1, x, y, Draw.this.draw_color.getRed(), Draw.this.draw_color.getGreen(), Draw.this.draw_color.getBlue());
            if (Draw.this.no_channel) {
                this.drawPoint(comm);
                return;
            }
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                if (Draw.this.use_unicasts) {
                    Draw.this.sendToAll(buf);
                } else {
                    Draw.this.channel.send(new Message(null, null, buf));
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawPoint(DrawCommand c) {
            if (c == null || this.gr == null) {
                return;
            }
            Color col = new Color(c.r, c.g, c.b);
            this.gr.setColor(col);
            this.gr.fillOval(c.x, c.y, 10, 10);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.put(new Point(c.x, c.y), col);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.gr == null) {
                return;
            }
            this.gr.clearRect(0, 0, this.getSize().width, this.getSize().height);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawState() {
            Map<Point, Color> map = this.state;
            synchronized (map) {
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point pt = entry.getKey();
                    Color col = entry.getValue();
                    this.gr.setColor(col);
                    this.gr.fillOval(pt.x, pt.y, 10, 10);
                }
            }
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferred_size;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

