/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.state.PublishedState;

enum SystemState {
    Offline{

        @Override
        public SystemState nextState(Command arg0, CommandExecutor arg1) {
            return this;
        }
    }
    ,
    Ready{

        @Override
        public SystemState nextState(Command arg0, CommandExecutor arg1) {
            return Active;
        }

        @Override
        public boolean canProcess(Command c, CommandExecutor sys) {
            return true;
        }
    }
    ,
    Active{

        @Override
        public boolean canProcess(Command c, CommandExecutor sys) {
            return sys.isMultithreaded() && c.canRunInActiveMode() || c.canWaitForReady();
        }
    }
    ,
    InError{

        @Override
        public boolean canProcess(Command c, CommandExecutor sys) {
            return true;
        }
    }
    ,
    Recovering{

        @Override
        public boolean canProcess(Command c, CommandExecutor sys) {
            return true;
        }
    };


    private SystemState() {
    }

    public boolean canProcess(Command c, CommandExecutor sys) {
        return false;
    }

    public SystemState nextState(Command c, CommandExecutor sys) {
        return this;
    }

    public PublishedState getPublishedState() {
        return new PublishedState((Serializable)((Object)this));
    }

    /* synthetic */ SystemState(String string, int n, SystemState systemState) {
        this();
    }
}

