/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.util.UUID;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.BusPayload;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DestinationsException;
import org.lsst.ccs.bus.DuplicateBusNameException;
import org.lsst.ccs.bus.TransportStateException;
import org.lsst.ccs.utilities.logging.Logger;

public class JGroupsBusMessagingLayer
implements BusMessagingLayer {
    public static final String DEFAULT_UDP_PROTOCOL = "jgroups:udp_ccs";
    private Properties jgroupsProperties;
    private String xmlConfigurationFile = "udp_ccs.xml";
    private static final String propertyKeyForJGroups = "org.lsst.ccs.jgroups.";
    private static final String propertyKeyForAllBuses = "org.lsst.ccs.jgroups.ALL.";
    private boolean tryBroadcast;
    private static Logger logger = Logger.getLogger((String)"org.lsst.ccs.bus.jgroups");
    CopyOnWriteArrayList<AgentAddresses> namedAgentAddresses = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<AgentAddresses> anonymousAddresses = new CopyOnWriteArrayList();
    private Map<String, LocalAgentChannels> mapLocalChannels = new ConcurrentHashMap<String, LocalAgentChannels>();
    private BusMembershipListener[] membershipListeners = new BusMembershipListener[Bus.values().length];
    private View[] lastViews = new View[Bus.values().length];
    private volatile boolean closed;

    @Deprecated
    public JGroupsBusMessagingLayer() {
        this(DEFAULT_UDP_PROTOCOL);
    }

    JGroupsBusMessagingLayer(String protocolString) {
        String[] protocolInfos = protocolString.split(":");
        String rawResource = protocolInfos[1];
        if (rawResource.length() > 0) {
            this.xmlConfigurationFile = String.format("/%s.xml", rawResource);
        }
        String propertiesConfigurationFile = this.xmlConfigurationFile.replace(".xml", ".properties");
        this.jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
        this.tryBroadcast = Boolean.parseBoolean(this.jgroupsProperties.getProperty("org.lsst.ccs.jgroups.trybroadcast"));
    }

    @Override
    public void register(String agentName, Bus ... buses) throws IOException {
        StringBuilder allBuses = new StringBuilder();
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            allBuses.append(String.valueOf(bus.toString()) + " ");
            ++n2;
        }
        logger.info((Object)("### Registering " + agentName + " for buses " + allBuses), new String[0]);
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        } else {
            for (AgentAddresses addresses : this.namedAgentAddresses) {
                if (!agentName.equals(addresses.agentName)) continue;
                Bus[] busArray2 = buses;
                int n3 = buses.length;
                int n4 = 0;
                while (n4 < n3) {
                    Bus bus = busArray2[n4];
                    if (addresses.busAddresses[bus.ordinal()] != null) {
                        DuplicateBusNameException exception = new DuplicateBusNameException(agentName, " already registered on " + bus);
                        logger.error((Object)exception, new String[0]);
                        BusMembershipListener listener = this.membershipListeners[bus.ordinal()];
                        if (listener != null) {
                            listener.anormalEvent(exception);
                        }
                    }
                    ++n4;
                }
            }
        }
        LocalAgentChannels localChannels = this.mapLocalChannels.get(agentName);
        if (localChannels == null) {
            localChannels = new LocalAgentChannels();
            localChannels.agentName = agentName;
            this.mapLocalChannels.put(agentName, localChannels);
        }
        Bus[] busArray3 = buses;
        int n5 = buses.length;
        n = 0;
        while (n < n5) {
            Bus bus = busArray3[n];
            int index = bus.ordinal();
            JChannel channel = localChannels.channels[index];
            if (channel == null || !channel.isConnected()) {
                try {
                    XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(this.xmlConfigurationFile, this.jgroupsProperties, bus.toString());
                    channel = new JChannel((ProtocolStackConfigurator)configurator);
                    logger.debug((Object)("######################################################\nJGroup Configuration for bus: " + bus.toString() + "\n" + channel.getProtocolStack().printProtocolSpecAsXML() + "\n" + "######################################################"), new String[0]);
                    localChannels.channels[index] = channel;
                    channel.setName(agentName);
                    channel.connect(bus.toString());
                    View view = channel.getView();
                    this.updateMapAddressesFromView(bus, channel, view);
                    localChannels.receivers[index] = new BusReceiver(agentName, bus, channel);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            ++n;
        }
    }

    public static XmlConfigurator createXmlConfiguratorForBus(String xmlConfigurationFile, Properties properties, String bus) {
        String[] propertyKeys;
        InputStream xmlConfigurationFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)xmlConfigurationFile, JGroupsBusMessagingLayer.class);
        if (xmlConfigurationFileInputStream == null) {
            throw new IllegalArgumentException(String.valueOf(xmlConfigurationFile) + " not found as a resource");
        }
        XmlConfigurator configurator = null;
        try {
            configurator = XmlConfigurator.getInstance((InputStream)xmlConfigurationFileInputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create JGroups xml configuration object for " + xmlConfigurationFile, ioe);
        }
        List protocolConfigurationList = configurator.getProtocolStack();
        String[] stringArray = propertyKeys = new String[]{propertyKeyForAllBuses, propertyKeyForJGroups + bus.toUpperCase() + "."};
        int n = propertyKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyKey = stringArray[n2];
            Set keys = BootstrapResourceUtils.getAllKeysInProperties((Properties)properties);
            for (Object key : keys) {
                String property = (String)key;
                if (!property.startsWith(propertyKey)) continue;
                String shortProperty = property.replace(propertyKey, "");
                int divider = shortProperty.lastIndexOf(".");
                String protocolPropertyName = shortProperty.substring(divider + 1);
                String protocolName = shortProperty.substring(0, divider);
                String protocolPropertyValue = properties.getProperty(property);
                boolean found = false;
                for (ProtocolConfiguration protocolConfiguration : protocolConfigurationList) {
                    if (!protocolConfiguration.getProtocolName().equals(protocolName)) continue;
                    protocolConfiguration.getProperties().put(protocolPropertyName, protocolPropertyValue);
                    found = true;
                    break;
                }
                if (found) continue;
                HashMap<String, String> hash = new HashMap<String, String>();
                hash.put(protocolPropertyName, protocolPropertyValue);
                ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocolName, hash);
                protocolConfigurationList.add(newProtocol);
            }
            ++n2;
        }
        return configurator;
    }

    private synchronized void updateMapAddressesFromView(Bus bus, JChannel channel, View view) {
        ArrayList modifiedMembers;
        boolean adding;
        int index = bus.ordinal();
        ArrayList newMembers = view.getMembers();
        View lastView = this.lastViews[index];
        if (lastView == null) {
            adding = true;
            modifiedMembers = newMembers;
        } else {
            List oldMembers = lastView.getMembers();
            adding = newMembers.containsAll(oldMembers);
            if (adding) {
                modifiedMembers = new ArrayList(newMembers);
                modifiedMembers.removeAll(oldMembers);
            } else {
                modifiedMembers = new ArrayList(oldMembers);
                modifiedMembers.removeAll(newMembers);
            }
        }
        this.lastViews[index] = view;
        if (adding) {
            for (Address address : modifiedMembers) {
                BusMembershipListener listener;
                String name = address.toString();
                if ("__".equals(name)) {
                    AgentAddresses agentAddresses = new AgentAddresses();
                    agentAddresses.agentName = "__";
                    agentAddresses.busAddresses[index] = address;
                    this.anonymousAddresses.add(agentAddresses);
                    logger.info((Object)("adding ====== " + address + " to " + bus), new String[0]);
                    continue;
                }
                boolean found = false;
                for (AgentAddresses agentAddresses : this.namedAgentAddresses) {
                    if (!agentAddresses.agentName.equals(name)) continue;
                    agentAddresses.busAddresses[index] = address;
                    logger.info((Object)("adding ====== " + address + " to " + bus), new String[0]);
                    found = true;
                    break;
                }
                if (!found) {
                    AgentAddresses agentAddresses;
                    agentAddresses = new AgentAddresses();
                    agentAddresses.agentName = name;
                    agentAddresses.busAddresses[index] = address;
                    this.namedAgentAddresses.add(agentAddresses);
                    logger.info((Object)("adding ====== " + address + " to " + bus), new String[0]);
                }
                if ((listener = this.membershipListeners[index]) == null) continue;
                String info = "";
                if (address instanceof UUID) {
                    info = ((UUID)address).toStringLong();
                }
                listener.connecting(name, info);
            }
        } else {
            block2: for (Address address : modifiedMembers) {
                String name = address.toString();
                if ("__".equals(name)) {
                    Iterator<AgentAddresses> it = this.anonymousAddresses.iterator();
                    AgentAddresses agentAddressesToRemove = null;
                    while (it.hasNext()) {
                        AgentAddresses agentAddresses = it.next();
                        Address storedAddress = agentAddresses.busAddresses[index];
                        if (!address.equals(storedAddress)) continue;
                        agentAddressesToRemove = agentAddresses;
                    }
                    if (agentAddressesToRemove == null) continue;
                    this.anonymousAddresses.remove(agentAddressesToRemove);
                    continue;
                }
                for (AgentAddresses agentAddresses : this.namedAgentAddresses) {
                    if (!agentAddresses.agentName.equals(name)) continue;
                    agentAddresses.busAddresses[index] = null;
                    BusMembershipListener listener = this.membershipListeners[index];
                    if (listener != null) {
                        String info = "";
                        if (address instanceof UUID) {
                            info = ((UUID)address).toStringLong();
                        }
                        listener.disconnecting(name, info);
                        continue block2;
                    }
                    logger.info((Object)("removing ====== " + address + " from " + bus), new String[0]);
                    continue block2;
                }
            }
        }
    }

    @Override
    public void closeFor(String agentName, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) != null) {
            AgentAddresses agentAddresses = null;
            if (!"__".equals(agentName)) {
                for (AgentAddresses agAddress : this.namedAgentAddresses) {
                    if (!agentName.equals(agAddress.agentName)) continue;
                    agentAddresses = agAddress;
                    break;
                }
            }
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                JChannel channel = localAgentChannels.channels[index];
                if (channel != null) {
                    channel.close();
                }
                if (agentAddresses != null) {
                    agentAddresses.busAddresses[index] = null;
                }
                ++n2;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (String key : this.mapLocalChannels.keySet()) {
            logger.info((Object)("******** removing " + key), new String[0]);
            LocalAgentChannels localAgentChannels = this.mapLocalChannels.get(key);
            JChannel[] jChannelArray = localAgentChannels.channels;
            int n = localAgentChannels.channels.length;
            int n2 = 0;
            while (n2 < n) {
                JChannel channel = jChannelArray[n2];
                if (channel != null) {
                    channel.close();
                }
                ++n2;
            }
        }
    }

    @Override
    public <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, T message, String ... destinations) throws IOException {
        LocalAgentChannels localAgentChannels;
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        ArrayList<Address> listDestinationAddress = null;
        int index = bus.ordinal();
        ArrayList<String> failed = new ArrayList<String>();
        if (destinations.length != 0 && !"".equals(destinations[0]) && !"*".equals(destinations[0])) {
            listDestinationAddress = new ArrayList<Address>();
            String[] stringArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                String destination = stringArray[n2];
                boolean found = false;
                for (AgentAddresses agentAddresses : this.namedAgentAddresses) {
                    if (!agentAddresses.agentName.equals(destination)) continue;
                    Address address = agentAddresses.busAddresses[index];
                    if (address != null) {
                        listDestinationAddress.add(address);
                    } else if (this.tryBroadcast) {
                        listDestinationAddress.add(null);
                        BusMembershipListener listener = this.membershipListeners[index];
                        if (listener != null) {
                            listener.anormalEvent(new DuplicateBusNameException(destination, " default broadcast"));
                        }
                        logger.info((Object)("trying broadcast instead of " + agentAddresses.agentName), new String[0]);
                    } else {
                        failed.add(destination);
                        logger.info((Object)("sending fail (closed)" + agentAddresses.agentName), new String[0]);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    if (this.tryBroadcast) {
                        listDestinationAddress.add(null);
                        logger.info((Object)("trying broadcast instead of " + destination), new String[0]);
                    } else {
                        failed.add(destination);
                        logger.info((Object)("sending fail to : " + destination), new String[0]);
                    }
                }
                ++n2;
            }
            for (AgentAddresses agentAddresses : this.anonymousAddresses) {
                Address address = agentAddresses.busAddresses[index];
                if (address == null) continue;
                listDestinationAddress.add(address);
            }
        }
        if ((localAgentChannels = this.mapLocalChannels.get(senderAgent)) == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        JChannel channel = localAgentChannels.channels[index];
        if (channel == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        try {
            if (listDestinationAddress == null) {
                channel.send(null, message);
            } else {
                boolean nullSent = false;
                for (Address dest : listDestinationAddress) {
                    if (dest == null) {
                        if (nullSent) continue;
                        nullSent = true;
                    }
                    channel.send(dest, message);
                }
            }
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
        if (failed.size() != 0) {
            DestinationsException exc = new DestinationsException(senderAgent, failed.toArray());
            BusMembershipListener listener = this.membershipListeners[index];
            if (listener != null) {
                listener.anormalEvent(exc);
            }
            throw exc;
        }
    }

    @Override
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) == null) {
            throw new IllegalArgumentException(" agent " + agentName + "not registered");
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
            ++n2;
        }
    }

    @Override
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) == null) {
            return;
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
            if (receiver != null) {
                receiver.removeForwarder(forwarder);
            }
            ++n2;
        }
    }

    @Override
    public void setMembershipListener(BusMembershipListener listener, Bus ... buses) {
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            this.membershipListeners[bus.ordinal()] = listener;
            ++n2;
        }
    }

    @Override
    public List<String> getConnectedNames(Bus bus) {
        int index = bus.ordinal();
        ArrayList<String> res = new ArrayList<String>();
        for (LocalAgentChannels localAgentChannels : this.mapLocalChannels.values()) {
            JChannel channel = localAgentChannels.channels[index];
            if (channel == null) continue;
            View view = channel.getView();
            for (Address address : view.getMembers()) {
                res.add(channel.getName(address));
            }
            return res;
        }
        return res;
    }

    class AgentAddresses {
        String agentName;
        Address[] busAddresses = new Address[Bus.values().length];

        AgentAddresses() {
        }
    }

    class BusReceiver
    extends ReceiverAdapter {
        Bus bus;
        JChannel curChan;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        String agentName;

        BusReceiver(String agentName, Bus bus, JChannel curChan) {
            this.agentName = agentName;
            this.bus = bus;
            this.curChan = curChan;
            curChan.setReceiver((Receiver)this);
        }

        public void addForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                this.listForwarders = new CopyOnWriteArrayList();
            }
            this.listForwarders.add(forwarder);
        }

        public void removeForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                return;
            }
            this.listForwarders.remove(forwarder);
        }

        public void receive(Message message) {
            String destination;
            if (this.listForwarders == null) {
                return;
            }
            if (this.listForwarders.size() == 0) {
                return;
            }
            BusMessage busMessInit = (BusMessage)message.getObject();
            BusMessage busMess = busMessInit;
            if (busMess.getOrigin().equals(this.agentName)) {
                logger.trace((Object)"message received by same agent than sender", new String[0]);
                return;
            }
            if (JGroupsBusMessagingLayer.this.tryBroadcast && !"__".equals(this.agentName) && busMess instanceof Command && (destination = ((Command)busMess).getDestination()) != null && !"".equals(destination) && !"*".equals(destination)) {
                String[] dests = destination.split(",");
                boolean found = false;
                String[] stringArray = dests;
                int n = dests.length;
                int n2 = 0;
                while (n2 < n) {
                    String dest = stringArray[n2];
                    if (destination.equalsIgnoreCase(dest)) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    return;
                }
            }
            for (BusMessageForwarder forwarder : this.listForwarders) {
                forwarder.update(busMess);
            }
        }

        public void viewAccepted(View view) {
            JGroupsBusMessagingLayer.this.updateMapAddressesFromView(this.bus, this.curChan, view);
        }

        public void suspect(Address address) {
            int index = this.bus.ordinal();
            for (AgentAddresses agentAddresses : JGroupsBusMessagingLayer.this.namedAgentAddresses) {
                Address localAddress = agentAddresses.busAddresses[index];
                if (!address.equals(localAddress)) continue;
                BusMembershipListener busMembershipListener = JGroupsBusMessagingLayer.this.membershipListeners[index];
                if (busMembershipListener != null) {
                    String info = "";
                    if (address instanceof UUID) {
                        info = ((UUID)address).toStringLong();
                    }
                    busMembershipListener.disconnecting(" guess on " + address.toString(), info);
                } else {
                    logger.warn((Object)("disconnection suspicion on " + address), new String[0]);
                }
                agentAddresses.busAddresses[index] = null;
                break;
            }
        }
    }

    class LocalAgentChannels {
        String agentName;
        JChannel[] channels = new JChannel[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgentChannels() {
        }
    }
}

