/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.lsst.ccs.utilities.logging.ContextLogManager;
import org.lsst.ccs.utilities.logging.StackTraceFormats;

public class TextFormatter
extends SimpleFormatter {
    String format;
    private final Date dat = new Date();

    public TextFormatter() {
        this.format = ContextLogManager.loaderGetStringProperty("org.lsst.ccs.utilities.logging.TextFormatter.format", "%2$s:%5$s%n%6$s");
        StackTraceFormats.setDepthFromInitialProperties();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public synchronized String format(LogRecord record) {
        String source;
        String indexStr = String.valueOf(record.getSequenceNumber());
        this.dat.setTime(record.getMillis());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = String.valueOf(source) + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwableStr = "";
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            throwableStr = StackTraceFormats.toString(throwable, 1);
        }
        String res = String.valueOf(indexStr) + " " + String.format(this.format, this.dat, source, record.getLoggerName(), record.getLevel(), message, throwableStr);
        return res;
    }
}

