/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.TransientObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.entry.CacheEntryStructure;
import org.hibernate.cache.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.entry.StructuredMapCacheEntry;
import org.hibernate.cache.entry.UnstructuredCacheEntry;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.CompositeElementPropertyMapping;
import org.hibernate.persister.collection.ElementPropertyMapping;
import org.hibernate.persister.collection.NamedQueryCollectionInitializer;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Alias;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.ordering.antlr.ColumnMapper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.FilterHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectionPersister
implements CollectionMetadata,
SQLLoadableCollection {
    private final String role;
    private final String sqlDeleteString;
    private final String sqlInsertRowString;
    private final String sqlUpdateRowString;
    private final String sqlDeleteRowString;
    private final String sqlSelectSizeString;
    private final String sqlSelectRowByIndexString;
    private final String sqlDetectRowByIndexString;
    private final String sqlDetectRowByElementString;
    protected final String sqlWhereString;
    private final String sqlOrderByStringTemplate;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    protected final boolean hasWhere;
    private final int baseIndex;
    private final String nodeName;
    private final String elementNodeName;
    private final String indexNodeName;
    protected final boolean indexContainsFormula;
    protected final boolean elementIsPureFormula;
    private final Type keyType;
    private final Type indexType;
    protected final Type elementType;
    private final Type identifierType;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] indexFormulaTemplates;
    protected final String[] indexFormulas;
    protected final boolean[] indexColumnIsSettable;
    protected final String[] elementColumnNames;
    protected final String[] elementColumnWriters;
    protected final String[] elementColumnReaders;
    protected final String[] elementColumnReaderTemplates;
    protected final String[] elementFormulaTemplates;
    protected final String[] elementFormulas;
    protected final boolean[] elementColumnIsSettable;
    protected final boolean[] elementColumnIsInPrimaryKey;
    protected final String[] indexColumnAliases;
    protected final String[] elementColumnAliases;
    protected final String[] keyColumnAliases;
    protected final String identifierColumnName;
    private final String identifierColumnAlias;
    protected final String qualifiedTableName;
    private final String queryLoaderName;
    private final boolean isPrimitiveArray;
    private final boolean isArray;
    protected final boolean hasIndex;
    protected final boolean hasIdentifier;
    private final boolean isLazy;
    private final boolean isExtraLazy;
    private final boolean isInverse;
    private final boolean isMutable;
    private final boolean isVersioned;
    protected final int batchSize;
    private final FetchMode fetchMode;
    private final boolean hasOrphanDelete;
    private final boolean subselectLoadable;
    private final Class elementClass;
    private final String entityName;
    private final Dialect dialect;
    private final SQLExceptionConverter sqlExceptionConverter;
    private final SessionFactoryImplementor factory;
    private final EntityPersister ownerPersister;
    private final IdentifierGenerator identifierGenerator;
    private final PropertyMapping elementPropertyMapping;
    private final EntityPersister elementPersister;
    private final CollectionRegionAccessStrategy cacheAccessStrategy;
    private final CollectionType collectionType;
    private CollectionInitializer initializer;
    private final CacheEntryStructure cacheEntryStructure;
    private final FilterHelper filterHelper;
    private final FilterHelper manyToManyFilterHelper;
    private final String manyToManyWhereString;
    private final String manyToManyWhereTemplate;
    private final boolean hasManyToManyOrder;
    private final String manyToManyOrderByTemplate;
    private final boolean insertCallable;
    private final boolean updateCallable;
    private final boolean deleteCallable;
    private final boolean deleteAllCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private ExecuteUpdateResultCheckStyle deleteAllCheckStyle;
    private final Serializable[] spaces;
    private Map collectionPropertyColumnAliases = new HashMap();
    private Map collectionPropertyColumnNames = new HashMap();
    private static final Logger log = LoggerFactory.getLogger((Class)AbstractCollectionPersister.class);
    private String[] indexFragments;

    public AbstractCollectionPersister(Collection collection, CollectionRegionAccessStrategy cacheAccessStrategy, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        ColumnMapper mapper;
        this.factory = factory;
        this.cacheAccessStrategy = cacheAccessStrategy;
        this.cacheEntryStructure = factory.getSettings().isStructuredCacheEntriesEnabled() ? (collection.isMap() ? new StructuredMapCacheEntry() : new StructuredCollectionCacheEntry()) : new UnstructuredCacheEntry();
        this.dialect = factory.getDialect();
        this.sqlExceptionConverter = factory.getSQLExceptionConverter();
        this.collectionType = collection.getCollectionType();
        this.role = collection.getRole();
        this.entityName = collection.getOwnerEntityName();
        this.ownerPersister = factory.getEntityPersister(this.entityName);
        this.queryLoaderName = collection.getLoaderName();
        this.nodeName = collection.getNodeName();
        this.isMutable = collection.isMutable();
        Table table = collection.getCollectionTable();
        this.fetchMode = collection.getElement().getFetchMode();
        this.elementType = collection.getElement().getType();
        this.isPrimitiveArray = collection.isPrimitiveArray();
        this.isArray = collection.isArray();
        this.subselectLoadable = collection.isSubselectLoadable();
        this.qualifiedTableName = table.getQualifiedName(this.dialect, factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
        int spacesSize = 1 + collection.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        this.spaces[0] = this.qualifiedTableName;
        Iterator iter = collection.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = (String)iter.next();
        }
        this.sqlWhereString = StringHelper.isNotEmpty(collection.getWhere()) ? "( " + collection.getWhere() + ") " : null;
        this.hasWhere = this.sqlWhereString != null;
        this.sqlWhereStringTemplate = this.hasWhere ? Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect, factory.getSqlFunctionRegistry()) : null;
        this.hasOrphanDelete = collection.hasOrphanDelete();
        int batch = collection.getBatchSize();
        if (batch == -1) {
            batch = factory.getSettings().getDefaultBatchFetchSize();
        }
        this.batchSize = batch;
        this.isVersioned = collection.isOptimisticLocked();
        this.keyType = collection.getKey().getType();
        iter = collection.getKey().getColumnIterator();
        int keySpan = collection.getKey().getColumnSpan();
        this.keyColumnNames = new String[keySpan];
        this.keyColumnAliases = new String[keySpan];
        int k = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.keyColumnNames[k] = col.getQuotedName(this.dialect);
            this.keyColumnAliases[k] = col.getAlias(this.dialect, collection.getOwner().getRootTable());
            ++k;
        }
        String elemNode = collection.getElementNodeName();
        if (this.elementType.isEntityType()) {
            String entityName = ((EntityType)this.elementType).getAssociatedEntityName();
            this.elementPersister = factory.getEntityPersister(entityName);
            if (elemNode == null) {
                elemNode = cfg.getClassMapping(entityName).getNodeName();
            }
        } else {
            this.elementPersister = null;
        }
        this.elementNodeName = elemNode;
        int elementSpan = collection.getElement().getColumnSpan();
        this.elementColumnAliases = new String[elementSpan];
        this.elementColumnNames = new String[elementSpan];
        this.elementColumnWriters = new String[elementSpan];
        this.elementColumnReaders = new String[elementSpan];
        this.elementColumnReaderTemplates = new String[elementSpan];
        this.elementFormulaTemplates = new String[elementSpan];
        this.elementFormulas = new String[elementSpan];
        this.elementColumnIsSettable = new boolean[elementSpan];
        this.elementColumnIsInPrimaryKey = new boolean[elementSpan];
        boolean isPureFormula = true;
        boolean hasNotNullableColumns = false;
        int j = 0;
        iter = collection.getElement().getColumnIterator();
        while (iter.hasNext()) {
            Selectable selectable = (Selectable)iter.next();
            this.elementColumnAliases[j] = selectable.getAlias(this.dialect);
            if (selectable.isFormula()) {
                Formula form = (Formula)selectable;
                this.elementFormulaTemplates[j] = form.getTemplate(this.dialect, factory.getSqlFunctionRegistry());
                this.elementFormulas[j] = form.getFormula();
            } else {
                Column col = (Column)selectable;
                this.elementColumnNames[j] = col.getQuotedName(this.dialect);
                this.elementColumnWriters[j] = col.getWriteExpr();
                this.elementColumnReaders[j] = col.getReadExpr(this.dialect);
                this.elementColumnReaderTemplates[j] = col.getTemplate(this.dialect, factory.getSqlFunctionRegistry());
                this.elementColumnIsSettable[j] = true;
                boolean bl = this.elementColumnIsInPrimaryKey[j] = !col.isNullable();
                if (!col.isNullable()) {
                    hasNotNullableColumns = true;
                }
                isPureFormula = false;
            }
            ++j;
        }
        this.elementIsPureFormula = isPureFormula;
        if (!hasNotNullableColumns) {
            Arrays.fill(this.elementColumnIsInPrimaryKey, true);
        }
        this.hasIndex = collection.isIndexed();
        if (this.hasIndex) {
            IndexedCollection indexedCollection = (IndexedCollection)collection;
            this.indexType = indexedCollection.getIndex().getType();
            int indexSpan = indexedCollection.getIndex().getColumnSpan();
            iter = indexedCollection.getIndex().getColumnIterator();
            this.indexColumnNames = new String[indexSpan];
            this.indexFormulaTemplates = new String[indexSpan];
            this.indexFormulas = new String[indexSpan];
            this.indexColumnIsSettable = new boolean[indexSpan];
            this.indexColumnAliases = new String[indexSpan];
            int i = 0;
            boolean hasFormula = false;
            while (iter.hasNext()) {
                Selectable s = (Selectable)iter.next();
                this.indexColumnAliases[i] = s.getAlias(this.dialect);
                if (s.isFormula()) {
                    Formula indexForm = (Formula)s;
                    this.indexFormulaTemplates[i] = indexForm.getTemplate(this.dialect, factory.getSqlFunctionRegistry());
                    this.indexFormulas[i] = indexForm.getFormula();
                    hasFormula = true;
                } else {
                    Column indexCol = (Column)s;
                    this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                    this.indexColumnIsSettable[i] = true;
                }
                ++i;
            }
            this.indexContainsFormula = hasFormula;
            this.baseIndex = indexedCollection.isList() ? ((List)indexedCollection).getBaseIndex() : 0;
            this.indexNodeName = indexedCollection.getIndexNodeName();
        } else {
            this.indexContainsFormula = false;
            this.indexColumnIsSettable = null;
            this.indexFormulaTemplates = null;
            this.indexFormulas = null;
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
            this.baseIndex = 0;
            this.indexNodeName = null;
        }
        this.hasIdentifier = collection.isIdentified();
        if (this.hasIdentifier) {
            if (collection.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collection;
            this.identifierType = idColl.getIdentifier().getType();
            iter = idColl.getIdentifier().getColumnIterator();
            Column col = (Column)iter.next();
            this.identifierColumnName = col.getQuotedName(this.dialect);
            this.identifierColumnAlias = col.getAlias(this.dialect);
            this.identifierGenerator = idColl.getIdentifier().createIdentifierGenerator(cfg.getIdentifierGeneratorFactory(), factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName(), null);
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.identifierGenerator = null;
        }
        if (collection.getCustomSQLInsert() == null) {
            this.sqlInsertRowString = this.generateInsertRowString();
            this.insertCallable = false;
            this.insertCheckStyle = ExecuteUpdateResultCheckStyle.COUNT;
        } else {
            this.sqlInsertRowString = collection.getCustomSQLInsert();
            this.insertCallable = collection.isCustomInsertCallable();
            ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = this.insertCheckStyle = collection.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(collection.getCustomSQLInsert(), this.insertCallable) : collection.getCustomSQLInsertCheckStyle();
        }
        if (collection.getCustomSQLUpdate() == null) {
            this.sqlUpdateRowString = this.generateUpdateRowString();
            this.updateCallable = false;
            this.updateCheckStyle = ExecuteUpdateResultCheckStyle.COUNT;
        } else {
            this.sqlUpdateRowString = collection.getCustomSQLUpdate();
            this.updateCallable = collection.isCustomUpdateCallable();
            ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = this.updateCheckStyle = collection.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(collection.getCustomSQLUpdate(), this.insertCallable) : collection.getCustomSQLUpdateCheckStyle();
        }
        if (collection.getCustomSQLDelete() == null) {
            this.sqlDeleteRowString = this.generateDeleteRowString();
            this.deleteCallable = false;
            this.deleteCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        } else {
            this.sqlDeleteRowString = collection.getCustomSQLDelete();
            this.deleteCallable = collection.isCustomDeleteCallable();
            this.deleteCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        }
        if (collection.getCustomSQLDeleteAll() == null) {
            this.sqlDeleteString = this.generateDeleteString();
            this.deleteAllCallable = false;
            this.deleteAllCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        } else {
            this.sqlDeleteString = collection.getCustomSQLDeleteAll();
            this.deleteAllCallable = collection.isCustomDeleteAllCallable();
            this.deleteAllCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        }
        this.sqlSelectSizeString = this.generateSelectSizeString(collection.isIndexed() && !collection.isMap());
        this.sqlDetectRowByIndexString = this.generateDetectRowByIndexString();
        this.sqlDetectRowByElementString = this.generateDetectRowByElementString();
        this.sqlSelectRowByIndexString = this.generateSelectRowByIndexString();
        this.logStaticSQL();
        this.isLazy = collection.isLazy();
        this.isExtraLazy = collection.isExtraLazy();
        this.isInverse = collection.isInverse();
        this.elementClass = collection.isArray() ? ((Array)collection).getElementClass() : null;
        this.elementPropertyMapping = this.elementType.isComponentType() ? new CompositeElementPropertyMapping(this.elementColumnNames, this.elementColumnReaders, this.elementColumnReaderTemplates, this.elementFormulaTemplates, (AbstractComponentType)this.elementType, factory) : (!this.elementType.isEntityType() ? new ElementPropertyMapping(this.elementColumnNames, this.elementType) : (this.elementPersister instanceof PropertyMapping ? (PropertyMapping)((Object)this.elementPersister) : new ElementPropertyMapping(this.elementColumnNames, this.elementType)));
        boolean bl = this.hasOrder = collection.getOrderBy() != null;
        if (this.hasOrder) {
            mapper = new ColumnMapper(){

                public String[] map(String reference) {
                    return AbstractCollectionPersister.this.elementPropertyMapping.toColumns(reference);
                }
            };
            this.sqlOrderByStringTemplate = Template.renderOrderByStringTemplate(collection.getOrderBy(), mapper, factory, this.dialect, factory.getSqlFunctionRegistry());
        } else {
            this.sqlOrderByStringTemplate = null;
        }
        this.filterHelper = new FilterHelper(collection.getFilterMap(), this.dialect, factory.getSqlFunctionRegistry());
        this.manyToManyFilterHelper = new FilterHelper(collection.getManyToManyFilterMap(), this.dialect, factory.getSqlFunctionRegistry());
        this.manyToManyWhereString = StringHelper.isNotEmpty(collection.getManyToManyWhere()) ? "( " + collection.getManyToManyWhere() + ")" : null;
        this.manyToManyWhereTemplate = this.manyToManyWhereString == null ? null : Template.renderWhereStringTemplate(this.manyToManyWhereString, factory.getDialect(), factory.getSqlFunctionRegistry());
        boolean bl2 = this.hasManyToManyOrder = collection.getManyToManyOrdering() != null;
        if (this.hasManyToManyOrder) {
            mapper = new ColumnMapper(){

                public String[] map(String reference) {
                    return AbstractCollectionPersister.this.elementPropertyMapping.toColumns(reference);
                }
            };
            this.manyToManyOrderByTemplate = Template.renderOrderByStringTemplate(collection.getManyToManyOrdering(), mapper, factory, this.dialect, factory.getSqlFunctionRegistry());
        } else {
            this.manyToManyOrderByTemplate = null;
        }
        this.initCollectionPropertyMap();
    }

    public void postInstantiate() throws MappingException {
        this.initializer = this.queryLoaderName == null ? this.createCollectionInitializer(LoadQueryInfluencers.NONE) : new NamedQueryCollectionInitializer(this.queryLoaderName, this);
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug("Static SQL for collection: " + this.getRole());
            if (this.getSQLInsertRowString() != null) {
                log.debug(" Row insert: " + this.getSQLInsertRowString());
            }
            if (this.getSQLUpdateRowString() != null) {
                log.debug(" Row update: " + this.getSQLUpdateRowString());
            }
            if (this.getSQLDeleteRowString() != null) {
                log.debug(" Row delete: " + this.getSQLDeleteRowString());
            }
            if (this.getSQLDeleteString() != null) {
                log.debug(" One-shot delete: " + this.getSQLDeleteString());
            }
        }
    }

    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        this.getAppropriateInitializer(key, session).initialize(key, session);
    }

    protected CollectionInitializer getAppropriateInitializer(Serializable key, SessionImplementor session) {
        if (this.queryLoaderName != null) {
            return this.initializer;
        }
        CollectionInitializer subselectInitializer = this.getSubselectInitializer(key, session);
        if (subselectInitializer != null) {
            return subselectInitializer;
        }
        if (session.getEnabledFilters().isEmpty()) {
            return this.initializer;
        }
        return this.createCollectionInitializer(session.getLoadQueryInfluencers());
    }

    private CollectionInitializer getSubselectInitializer(Serializable key, SessionImplementor session) {
        if (!this.isSubselectLoadable()) {
            return null;
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        SubselectFetch subselect = persistenceContext.getBatchFetchQueue().getSubselect(new EntityKey(key, this.getOwnerEntityPersister(), session.getEntityMode()));
        if (subselect == null) {
            return null;
        }
        Iterator iter = subselect.getResult().iterator();
        while (iter.hasNext()) {
            if (persistenceContext.containsEntity((EntityKey)iter.next())) continue;
            iter.remove();
        }
        return this.createSubselectInitializer(subselect, session);
    }

    protected abstract CollectionInitializer createSubselectInitializer(SubselectFetch var1, SessionImplementor var2);

    protected abstract CollectionInitializer createCollectionInitializer(LoadQueryInfluencers var1) throws MappingException;

    public CollectionRegionAccessStrategy getCacheAccessStrategy() {
        return this.cacheAccessStrategy;
    }

    public boolean hasCache() {
        return this.cacheAccessStrategy != null;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    protected String getSQLWhereString(String alias) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", alias);
    }

    public String getSQLOrderByString(String alias) {
        return this.hasOrdering() ? StringHelper.replace(this.sqlOrderByStringTemplate, "$PlaceHolder$", alias) : "";
    }

    public String getManyToManyOrderByString(String alias) {
        return this.hasManyToManyOrdering() ? StringHelper.replace(this.manyToManyOrderByTemplate, "$PlaceHolder$", alias) : "";
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public boolean hasOrdering() {
        return this.hasOrder;
    }

    public boolean hasManyToManyOrdering() {
        return this.isManyToMany() && this.hasManyToManyOrder;
    }

    public boolean hasWhere() {
        return this.hasWhere;
    }

    protected String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    protected String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    protected String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object readElement(ResultSet rs, Object owner, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        return this.getElementType().nullSafeGet(rs, aliases, session, owner);
    }

    public Object readIndex(ResultSet rs, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        Object index = this.getIndexType().nullSafeGet(rs, aliases, session, null);
        if (index == null) {
            throw new HibernateException("null index column for collection: " + this.role);
        }
        index = this.decrementIndexByBase(index);
        return index;
    }

    protected Object decrementIndexByBase(Object index) {
        if (this.baseIndex != 0) {
            index = new Integer((Integer)index - this.baseIndex);
        }
        return index;
    }

    public Object readIdentifier(ResultSet rs, String alias, SessionImplementor session) throws HibernateException, SQLException {
        Object id = this.getIdentifierType().nullSafeGet(rs, alias, session, null);
        if (id == null) {
            throw new HibernateException("null identifier column for collection: " + this.role);
        }
        return id;
    }

    public Object readKey(ResultSet rs, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        return this.getKeyType().nullSafeGet(rs, aliases, session, null);
    }

    protected int writeKey(PreparedStatement st, Serializable key, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (key == null) {
            throw new NullPointerException("null key for collection: " + this.role);
        }
        this.getKeyType().nullSafeSet(st, key, i, session);
        return i + this.keyColumnAliases.length;
    }

    protected int writeElement(PreparedStatement st, Object elt, int i, SessionImplementor session) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(st, elt, i, this.elementColumnIsSettable, session);
        return i + ArrayHelper.countTrue(this.elementColumnIsSettable);
    }

    protected int writeIndex(PreparedStatement st, Object index, int i, SessionImplementor session) throws HibernateException, SQLException {
        this.getIndexType().nullSafeSet(st, this.incrementIndexByBase(index), i, this.indexColumnIsSettable, session);
        return i + ArrayHelper.countTrue(this.indexColumnIsSettable);
    }

    protected Object incrementIndexByBase(Object index) {
        if (this.baseIndex != 0) {
            index = new Integer((Integer)index + this.baseIndex);
        }
        return index;
    }

    protected int writeElementToWhere(PreparedStatement st, Object elt, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (this.elementIsPureFormula) {
            throw new AssertionFailure("cannot use a formula-based element in the where condition");
        }
        this.getElementType().nullSafeSet(st, elt, i, this.elementColumnIsInPrimaryKey, session);
        return i + this.elementColumnAliases.length;
    }

    protected int writeIndexToWhere(PreparedStatement st, Object index, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (this.indexContainsFormula) {
            throw new AssertionFailure("cannot use a formula-based index in the where condition");
        }
        this.getIndexType().nullSafeSet(st, this.incrementIndexByBase(index), i, session);
        return i + this.indexColumnAliases.length;
    }

    public int writeIdentifier(PreparedStatement st, Object id, int i, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierType().nullSafeSet(st, id, i, session);
        return i + 1;
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String[] getKeyColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.keyColumnAliases);
    }

    public String[] getElementColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.elementColumnAliases);
    }

    public String[] getIndexColumnAliases(String suffix) {
        if (this.hasIndex) {
            return new Alias(suffix).toAliasStrings(this.indexColumnAliases);
        }
        return null;
    }

    public String getIdentifierColumnAlias(String suffix) {
        if (this.hasIdentifier) {
            return new Alias(suffix).toAliasString(this.identifierColumnAlias);
        }
        return null;
    }

    public String getIdentifierColumnName() {
        if (this.hasIdentifier) {
            return this.identifierColumnName;
        }
        return null;
    }

    public String selectFragment(String alias, String columnSuffix) {
        SelectFragment frag = this.generateSelectFragment(alias, columnSuffix);
        this.appendElementColumns(frag, alias);
        this.appendIndexColumns(frag, alias);
        this.appendIdentifierColumns(frag, alias);
        return frag.toFragmentString().substring(2);
    }

    protected String generateSelectSizeString(boolean isIntegerIndexed) {
        String selectValue = isIntegerIndexed ? "max(" + this.getIndexColumnNames()[0] + ") + 1" : "count(" + this.getElementColumnNames()[0] + ")";
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addColumn(selectValue).toStatementString();
    }

    protected String generateDetectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getIndexColumnNames(), "=?").addCondition(this.indexFormulas, "=?").addColumn("1").toStatementString();
    }

    protected String generateSelectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getIndexColumnNames(), "=?").addCondition(this.indexFormulas, "=?").addColumns(this.getElementColumnNames(), this.elementColumnAliases).addColumns(this.indexFormulas, this.indexColumnAliases).toStatementString();
    }

    protected String generateDetectRowByElementString() {
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getElementColumnNames(), "=?").addCondition(this.elementFormulas, "=?").addColumn("1").toStatementString();
    }

    protected SelectFragment generateSelectFragment(String alias, String columnSuffix) {
        return new SelectFragment().setSuffix(columnSuffix).addColumns(alias, this.keyColumnNames, this.keyColumnAliases);
    }

    protected void appendElementColumns(SelectFragment frag, String elemAlias) {
        for (int i = 0; i < this.elementColumnIsSettable.length; ++i) {
            if (this.elementColumnIsSettable[i]) {
                frag.addColumnTemplate(elemAlias, this.elementColumnReaderTemplates[i], this.elementColumnAliases[i]);
                continue;
            }
            frag.addFormula(elemAlias, this.elementFormulaTemplates[i], this.elementColumnAliases[i]);
        }
    }

    protected void appendIndexColumns(SelectFragment frag, String alias) {
        if (this.hasIndex) {
            for (int i = 0; i < this.indexColumnIsSettable.length; ++i) {
                if (this.indexColumnIsSettable[i]) {
                    frag.addColumn(alias, this.indexColumnNames[i], this.indexColumnAliases[i]);
                    continue;
                }
                frag.addFormula(alias, this.indexFormulaTemplates[i], this.indexColumnAliases[i]);
            }
        }
    }

    protected void appendIdentifierColumns(SelectFragment frag, String alias) {
        if (this.hasIdentifier) {
            frag.addColumn(alias, this.identifierColumnName, this.identifierColumnAlias);
        }
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getIndexFormulas() {
        return this.indexFormulas;
    }

    public String[] getIndexColumnNames(String alias) {
        return AbstractCollectionPersister.qualify(alias, this.indexColumnNames, this.indexFormulaTemplates);
    }

    public String[] getElementColumnNames(String alias) {
        return AbstractCollectionPersister.qualify(alias, this.elementColumnNames, this.elementFormulaTemplates);
    }

    private static String[] qualify(String alias, String[] columnNames, String[] formulaTemplates) {
        int span = columnNames.length;
        String[] result = new String[span];
        for (int i = 0; i < span; ++i) {
            result[i] = columnNames[i] == null ? StringHelper.replace(formulaTemplates[i], "$PlaceHolder$", alias) : StringHelper.qualify(alias, columnNames[i]);
        }
        return result;
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Serializable id, SessionImplementor session) throws HibernateException {
        if (this.isInverse) return;
        if (!this.isRowDeleteEnabled()) return;
        if (log.isDebugEnabled()) {
            log.debug("Deleting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()));
        }
        try {
            block10: {
                int offset = 1;
                PreparedStatement st = null;
                Expectation expectation = Expectations.appropriateExpectation(this.getDeleteAllCheckStyle());
                boolean callable = this.isDeleteAllCallable();
                boolean useBatch = expectation.canBeBatched();
                String sql = this.getSQLDeleteString();
                st = useBatch ? (callable ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareBatchStatement(sql)) : (callable ? session.getBatcher().prepareCallableStatement(sql) : session.getBatcher().prepareStatement(sql));
                try {
                    try {
                        this.writeKey(st, id, offset += expectation.prepare(st), session);
                        if (useBatch) {
                            session.getBatcher().addToBatch(expectation);
                        } else {
                            expectation.verifyOutcome(st.executeUpdate(), st, -1);
                        }
                    }
                    catch (SQLException sqle) {
                        if (!useBatch) throw sqle;
                        session.getBatcher().abortBatch(sqle);
                        throw sqle;
                    }
                    Object var11_10 = null;
                    if (useBatch) break block10;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (useBatch) throw throwable;
                    session.getBatcher().closeStatement(st);
                    throw throwable;
                }
                session.getBatcher().closeStatement(st);
            }
            if (!log.isDebugEnabled()) return;
            log.debug("done deleting collection");
            return;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not delete collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLDeleteString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (this.isInverse) return;
        if (!this.isRowInsertEnabled()) return;
        if (log.isDebugEnabled()) {
            log.debug("Inserting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()));
        }
        try {
            Iterator entries = collection.entries(this);
            if (!entries.hasNext()) {
                if (!log.isDebugEnabled()) return;
                log.debug("collection was empty");
                return;
            }
            collection.preInsert(this);
            int i = 0;
            int count = 0;
            while (true) {
                block15: {
                    if (!entries.hasNext()) {
                        if (!log.isDebugEnabled()) return;
                        log.debug("done inserting collection: " + count + " rows inserted");
                        return;
                    }
                    Object entry = entries.next();
                    if (collection.entryExists(entry, i)) {
                        Object var16_17;
                        int offset = 1;
                        PreparedStatement st = null;
                        Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
                        boolean callable = this.isInsertCallable();
                        boolean useBatch = expectation.canBeBatched();
                        String sql = this.getSQLInsertRowString();
                        st = useBatch ? (callable ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareBatchStatement(sql)) : (callable ? session.getBatcher().prepareCallableStatement(sql) : session.getBatcher().prepareStatement(sql));
                        try {
                            try {
                                int loc = this.writeKey(st, id, offset += expectation.prepare(st), session);
                                if (this.hasIdentifier) {
                                    loc = this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
                                }
                                if (this.hasIndex) {
                                    loc = this.writeIndex(st, collection.getIndex(entry, i, this), loc, session);
                                }
                                loc = this.writeElement(st, collection.getElement(entry), loc, session);
                                if (useBatch) {
                                    session.getBatcher().addToBatch(expectation);
                                } else {
                                    expectation.verifyOutcome(st.executeUpdate(), st, -1);
                                }
                                collection.afterRowInsert(this, entry, i);
                                ++count;
                            }
                            catch (SQLException sqle) {
                                if (!useBatch) throw sqle;
                                session.getBatcher().abortBatch(sqle);
                                throw sqle;
                            }
                            var16_17 = null;
                            if (useBatch) break block15;
                        }
                        catch (Throwable throwable) {
                            var16_17 = null;
                            if (useBatch) throw throwable;
                            session.getBatcher().closeStatement(st);
                            throw throwable;
                        }
                        session.getBatcher().closeStatement(st);
                    }
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not insert collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLInsertRowString());
        }
    }

    protected boolean isRowDeleteEnabled() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (this.isInverse) return;
        if (!this.isRowDeleteEnabled()) return;
        if (log.isDebugEnabled()) {
            log.debug("Deleting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()));
        }
        boolean deleteByIndex = !this.isOneToMany() && this.hasIndex && !this.indexContainsFormula;
        try {
            Iterator deletes = collection.getDeletes(this, !deleteByIndex);
            if (!deletes.hasNext()) {
                if (!log.isDebugEnabled()) return;
                log.debug("no rows to delete");
                return;
            }
            int offset = 1;
            int count = 0;
            while (deletes.hasNext()) {
                block15: {
                    Object var16_17;
                    PreparedStatement st = null;
                    Expectation expectation = Expectations.appropriateExpectation(this.getDeleteCheckStyle());
                    boolean callable = this.isDeleteCallable();
                    boolean useBatch = expectation.canBeBatched();
                    String sql = this.getSQLDeleteRowString();
                    st = useBatch ? (callable ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareBatchStatement(sql)) : (callable ? session.getBatcher().prepareCallableStatement(sql) : session.getBatcher().prepareStatement(sql));
                    try {
                        try {
                            expectation.prepare(st);
                            Object entry = deletes.next();
                            int loc = offset;
                            if (this.hasIdentifier) {
                                this.writeIdentifier(st, entry, loc, session);
                            } else {
                                loc = this.writeKey(st, id, loc, session);
                                if (deleteByIndex) {
                                    this.writeIndexToWhere(st, entry, loc, session);
                                } else {
                                    this.writeElementToWhere(st, entry, loc, session);
                                }
                            }
                            if (useBatch) {
                                session.getBatcher().addToBatch(expectation);
                            } else {
                                expectation.verifyOutcome(st.executeUpdate(), st, -1);
                            }
                            ++count;
                        }
                        catch (SQLException sqle) {
                            if (!useBatch) throw sqle;
                            session.getBatcher().abortBatch(sqle);
                            throw sqle;
                        }
                        var16_17 = null;
                        if (useBatch) break block15;
                    }
                    catch (Throwable throwable) {
                        var16_17 = null;
                        if (useBatch) throw throwable;
                        session.getBatcher().closeStatement(st);
                        throw throwable;
                    }
                    session.getBatcher().closeStatement(st);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("done deleting collection rows: " + count + " deleted");
            }
            return;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not delete collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLDeleteRowString());
        }
    }

    protected boolean isRowInsertEnabled() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (this.isInverse) return;
        if (!this.isRowInsertEnabled()) return;
        if (log.isDebugEnabled()) {
            log.debug("Inserting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()));
        }
        try {
            collection.preInsert(this);
            Iterator entries = collection.entries(this);
            Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
            boolean callable = this.isInsertCallable();
            boolean useBatch = expectation.canBeBatched();
            String sql = this.getSQLInsertRowString();
            int i = 0;
            int count = 0;
            while (true) {
                block17: {
                    if (!entries.hasNext()) {
                        if (!log.isDebugEnabled()) return;
                        log.debug("done inserting rows: " + count + " inserted");
                        return;
                    }
                    int offset = 1;
                    Object entry = entries.next();
                    PreparedStatement st = null;
                    if (collection.needsInserting(entry, i, this.elementType)) {
                        Object var16_15;
                        if (useBatch) {
                            if (st == null) {
                                st = callable ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareBatchStatement(sql);
                            }
                        } else {
                            st = callable ? session.getBatcher().prepareCallableStatement(sql) : session.getBatcher().prepareStatement(sql);
                        }
                        try {
                            try {
                                offset += expectation.prepare(st);
                                offset = this.writeKey(st, id, offset, session);
                                if (this.hasIdentifier) {
                                    offset = this.writeIdentifier(st, collection.getIdentifier(entry, i), offset, session);
                                }
                                if (this.hasIndex) {
                                    offset = this.writeIndex(st, collection.getIndex(entry, i, this), offset, session);
                                }
                                this.writeElement(st, collection.getElement(entry), offset, session);
                                if (useBatch) {
                                    session.getBatcher().addToBatch(expectation);
                                } else {
                                    expectation.verifyOutcome(st.executeUpdate(), st, -1);
                                }
                                collection.afterRowInsert(this, entry, i);
                                ++count;
                            }
                            catch (SQLException sqle) {
                                if (!useBatch) throw sqle;
                                session.getBatcher().abortBatch(sqle);
                                throw sqle;
                            }
                            var16_15 = null;
                            if (useBatch) break block17;
                        }
                        catch (Throwable throwable) {
                            var16_15 = null;
                            if (useBatch) throw throwable;
                            session.getBatcher().closeStatement(st);
                            throw throwable;
                        }
                        session.getBatcher().closeStatement(st);
                    }
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not insert collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLInsertRowString());
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getOwnerEntityName() {
        return this.entityName;
    }

    public EntityPersister getOwnerEntityPersister() {
        return this.ownerPersister;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    public Type toType(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            return this.indexType;
        }
        return this.elementPropertyMapping.toType(propertyName);
    }

    public abstract boolean isManyToMany();

    public String getManyToManyFilterFragment(String alias, Map enabledFilters) {
        StringBuffer buffer = new StringBuffer();
        this.manyToManyFilterHelper.render(buffer, alias, enabledFilters);
        if (this.manyToManyWhereString != null) {
            buffer.append(" and ").append(StringHelper.replace(this.manyToManyWhereTemplate, "$PlaceHolder$", alias));
        }
        return buffer.toString();
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            return AbstractCollectionPersister.qualify(alias, this.indexColumnNames, this.indexFormulaTemplates);
        }
        return this.elementPropertyMapping.toColumns(alias, propertyName);
    }

    public String[] toColumns(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            if (this.indexFragments == null) {
                String[] tmp = new String[this.indexColumnNames.length];
                for (int i = 0; i < this.indexColumnNames.length; ++i) {
                    tmp[i] = this.indexColumnNames[i] == null ? this.indexFormulas[i] : this.indexColumnNames[i];
                    this.indexFragments = tmp;
                }
            }
            return this.indexFragments;
        }
        return this.elementPropertyMapping.toColumns(propertyName);
    }

    public Type getType() {
        return this.elementPropertyMapping.getType();
    }

    public String getName() {
        return this.getRole();
    }

    public EntityPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return (Loadable)this.elementPersister;
    }

    public boolean isCollection() {
        return true;
    }

    public Serializable[] getCollectionSpaces() {
        return this.spaces;
    }

    protected abstract String generateDeleteString();

    protected abstract String generateDeleteRowString();

    protected abstract String generateUpdateRowString();

    protected abstract String generateInsertRowString();

    public void updateRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && collection.isRowUpdatePossible()) {
            if (log.isDebugEnabled()) {
                log.debug("Updating rows of collection: " + this.role + "#" + id);
            }
            int count = this.doUpdateRows(id, collection, session);
            if (log.isDebugEnabled()) {
                log.debug("done updating rows: " + count + " updated");
            }
        }
    }

    protected abstract int doUpdateRows(Serializable var1, PersistentCollection var2, SessionImplementor var3) throws HibernateException;

    public CollectionMetadata getCollectionMetadata() {
        return this;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected String filterFragment(String alias) throws MappingException {
        return this.hasWhere() ? " and " + this.getSQLWhereString(alias) : "";
    }

    public String filterFragment(String alias, Map enabledFilters) throws MappingException {
        StringBuffer sessionFilterFragment = new StringBuffer();
        this.filterHelper.render(sessionFilterFragment, alias, enabledFilters);
        return sessionFilterFragment.append(this.filterFragment(alias)).toString();
    }

    public String oneToManyFilterFragment(String alias) throws MappingException {
        return "";
    }

    protected boolean isInsertCallable() {
        return this.insertCallable;
    }

    protected ExecuteUpdateResultCheckStyle getInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    protected boolean isUpdateCallable() {
        return this.updateCallable;
    }

    protected ExecuteUpdateResultCheckStyle getUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    protected boolean isDeleteCallable() {
        return this.deleteCallable;
    }

    protected ExecuteUpdateResultCheckStyle getDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    protected boolean isDeleteAllCallable() {
        return this.deleteAllCallable;
    }

    protected ExecuteUpdateResultCheckStyle getDeleteAllCheckStyle() {
        return this.deleteAllCheckStyle;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.role + ')';
    }

    public boolean isVersioned() {
        return this.isVersioned && this.getOwnerEntityPersister().isVersioned();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getElementNodeName() {
        return this.elementNodeName;
    }

    public String getIndexNodeName() {
        return this.indexNodeName;
    }

    protected SQLExceptionConverter getSQLExceptionConverter() {
        return this.sqlExceptionConverter;
    }

    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    public boolean isAffectedByEnabledFilters(SessionImplementor session) {
        return this.filterHelper.isAffectedBy(session.getEnabledFilters()) || this.isManyToMany() && this.manyToManyFilterHelper.isAffectedBy(session.getEnabledFilters());
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public String[] getCollectionPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = (String[])this.collectionPropertyColumnAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = new Alias(suffix).toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    public void initCollectionPropertyMap() {
        this.initCollectionPropertyMap("key", this.keyType, this.keyColumnAliases, this.keyColumnNames);
        this.initCollectionPropertyMap("element", this.elementType, this.elementColumnAliases, this.elementColumnNames);
        if (this.hasIndex) {
            this.initCollectionPropertyMap("index", this.indexType, this.indexColumnAliases, this.indexColumnNames);
        }
        if (this.hasIdentifier) {
            this.initCollectionPropertyMap("id", this.identifierType, new String[]{this.identifierColumnAlias}, new String[]{this.identifierColumnName});
        }
    }

    private void initCollectionPropertyMap(String aliasName, Type type, String[] columnAliases, String[] columnNames) {
        this.collectionPropertyColumnAliases.put(aliasName, columnAliases);
        this.collectionPropertyColumnNames.put(aliasName, columnNames);
        if (type.isComponentType()) {
            AbstractComponentType ct = (AbstractComponentType)type;
            String[] propertyNames = ct.getPropertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String name = propertyNames[i];
                this.collectionPropertyColumnAliases.put(aliasName + "." + name, columnAliases[i]);
                this.collectionPropertyColumnNames.put(aliasName + "." + name, columnNames[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSize(Serializable key, SessionImplementor session) {
        try {
            int n;
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sqlSelectSizeString);
            try {
                this.getKeyType().nullSafeSet(st, key, 1, session);
                ResultSet rs = st.executeQuery();
                try {
                    n = rs.next() ? rs.getInt(1) - this.baseIndex : 0;
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            return n;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve collection size: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    public boolean indexExists(Serializable key, Object index, SessionImplementor session) {
        return this.exists(key, this.incrementIndexByBase(index), this.getIndexType(), this.sqlDetectRowByIndexString, session);
    }

    public boolean elementExists(Serializable key, Object element, SessionImplementor session) {
        return this.exists(key, element, this.getElementType(), this.sqlDetectRowByElementString, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists(Serializable key, Object indexOrElement, Type indexOrElementType, String sql, SessionImplementor session) {
        try {
            boolean bl;
            PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
            try {
                try {
                    this.getKeyType().nullSafeSet(st, key, 1, session);
                    indexOrElementType.nullSafeSet(st, indexOrElement, this.keyColumnNames.length + 1, session);
                    ResultSet rs = st.executeQuery();
                    try {
                        bl = rs.next();
                        Object var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var12_14 = null;
                }
                catch (TransientObjectException e) {
                    boolean bl2 = false;
                    Object var12_15 = null;
                    session.getBatcher().closeStatement(st);
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            return bl;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not check row existence: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getElementByIndex(Serializable key, Object index, SessionImplementor session, Object owner) {
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sqlSelectRowByIndexString);
            try {
                ResultSet rs;
                block7: {
                    Object object;
                    this.getKeyType().nullSafeSet(st, key, 1, session);
                    this.getIndexType().nullSafeSet(st, this.incrementIndexByBase(index), this.keyColumnNames.length + 1, session);
                    rs = st.executeQuery();
                    try {
                        if (!rs.next()) break block7;
                        object = this.getElementType().nullSafeGet(rs, this.elementColumnAliases, session, owner);
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var11_13 = null;
                    session.getBatcher().closeStatement(st);
                    return object;
                }
                Object var7_9 = null;
                Object var9_11 = null;
                rs.close();
                Object var11_14 = null;
                session.getBatcher().closeStatement(st);
                return var7_9;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not read row: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    public boolean isExtraLazy() {
        return this.isExtraLazy;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    public CollectionInitializer getInitializer() {
        return this.initializer;
    }
}

