/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class PropertyMapConstructorGeneratorExtension
implements GeneratorExtension {
    int ctor_modifiers = 1;

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.util.Map");
        return set;
    }

    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw) throws IOException {
        iw.print(CodegenUtils.getModifierString(this.ctor_modifiers));
        iw.print(' ' + info.getClassName() + "( Map map )");
        iw.println("{");
        iw.upIndent();
        iw.println("Object raw;");
        int len = props.length;
        for (int i = 0; i < len; ++i) {
            Property prop = props[i];
            String propName = prop.getName();
            Class propType = propTypes[i];
            iw.println("raw = map.get( \"" + propName + "\" );");
            iw.println("if (raw != null)");
            iw.println("{");
            iw.upIndent();
            iw.print("this." + propName + " = ");
            if (propType == Boolean.TYPE) {
                iw.println("((Boolean) raw ).booleanValue();");
            } else if (propType == Byte.TYPE) {
                iw.println("((Byte) raw ).byteValue();");
            } else if (propType == Character.TYPE) {
                iw.println("((Character) raw ).charValue();");
            } else if (propType == Short.TYPE) {
                iw.println("((Short) raw ).shortValue();");
            } else if (propType == Integer.TYPE) {
                iw.println("((Integer) raw ).intValue();");
            } else if (propType == Long.TYPE) {
                iw.println("((Long) raw ).longValue();");
            } else if (propType == Float.TYPE) {
                iw.println("((Float) raw ).floatValue();");
            } else if (propType == Double.TYPE) {
                iw.println("((Double) raw ).doubleValue();");
            }
            iw.println("raw = null;");
            iw.downIndent();
            iw.println("}");
        }
        iw.downIndent();
        iw.println("}");
    }
}

