/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.IndexColumn;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.Constraints;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.DeploymentDescriptor;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.TextAndNode;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.jutils.NamedRefParm;
import org.lsst.gruth.nodes.ComponentFactory;
import org.lsst.gruth.utils.Tracer;

@MappedSuperclass
public abstract class SubsystemDescription
implements Serializable {
    private long startTimestamp;
    private long endTimestamp = PackCst.STILL_VALID;
    private String subsystemName;
    private String tag = "";
    private String user;
    private String version;
    @Lob
    protected Serializable configurationData;
    @Enumerated(value=EnumType.STRING)
    protected DataFlavour dataFlavour;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @IndexColumn(name="id", base=1)
    private List<DeploymentDescriptor> deployDescriptors = new ArrayList<DeploymentDescriptor>();
    @Transient
    List<DeploymentDescriptor> unModifiableDescriptorList = Collections.unmodifiableList(this.deployDescriptors);
    private long previousDescriptionID;
    public static final ParameterFilter DEFAULT_TREE_PARAMETER_FILTER = new ParameterFilter(){

        @Override
        public boolean filter(String parameterName, Object value) {
            if ("name".equalsIgnoreCase(parameterName)) {
                return false;
            }
            return !(value instanceof NamedRefParm);
        }
    };

    SubsystemDescription() {
    }

    protected SubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour) {
        this.setSubsystemName(subsystemName);
        this.setTag(tag);
        if (configurationData == null) {
            throw new IllegalArgumentException("null configuration data");
        }
        this.user = user;
        this.version = version;
        switch (dataFlavour) {
            case TREE_FROM_SOURCE: {
                if (configurationData instanceof TextAndNode) {
                    this.configurationData = configurationData;
                    break;
                }
                this.configurationData = new TextAndNode(configurationData);
                break;
            }
            case DUMMY_TEXT: 
            case PURE_OBJECT_TREE: {
                this.configurationData = configurationData;
            }
        }
        this.dataFlavour = dataFlavour;
    }

    protected SubsystemDescription(SubsystemDescription other) {
        this(other.getSubsystemName(), other.getTag(), other.getUser(), other.getVersion(), other.getConfigurationData(), other.getDataFlavour());
        this.deployDescriptors.addAll(other.getDeployDescriptors());
    }

    public abstract long getId();

    abstract void setId(long var1);

    public abstract Set<? extends ParameterDescription> getParamDescriptionSet();

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    void setSubsystemName(String subsystemName) {
        if (subsystemName == null) {
            throw new IllegalArgumentException("null subsystemName");
        }
        this.subsystemName = subsystemName;
    }

    public String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.tag = tag;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public String getUser() {
        return this.user;
    }

    void setUser(String user) {
        this.user = user;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public Serializable getConfigurationData() {
        return this.configurationData;
    }

    void setConfigurationData(Serializable configurationData) {
        this.configurationData = configurationData;
    }

    public DataFlavour getDataFlavour() {
        return this.dataFlavour;
    }

    void setDataFlavour(DataFlavour dataFlavour) {
        this.dataFlavour = dataFlavour;
    }

    public long getPreviousDescriptionID() {
        return this.previousDescriptionID;
    }

    void setPreviousDescriptionID(long previousDescriptionID) {
        this.previousDescriptionID = previousDescriptionID;
    }

    public List<DeploymentDescriptor> getDeployDescriptors() {
        return this.unModifiableDescriptorList;
    }

    void setDeployDescriptors(List<DeploymentDescriptor> deploymentDescriptors) {
        this.deployDescriptors = deploymentDescriptors;
        this.unModifiableDescriptorList = Collections.unmodifiableList(deploymentDescriptors);
    }

    public void addDeploymentDescriptors(DeploymentDescriptor ... descriptors) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Deployment descriptor list");
        }
        DeploymentDescriptor[] deploymentDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DeploymentDescriptor descriptor = deploymentDescriptorArray[n2];
            this.deployDescriptors.add(descriptor);
            ++n2;
        }
    }

    public void removeDeploymentDescriptors(DeploymentDescriptor ... descriptors) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Deployment descriptor list");
        }
        DeploymentDescriptor[] deploymentDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DeploymentDescriptor descriptor = deploymentDescriptorArray[n2];
            this.deployDescriptors.remove(descriptor);
            ++n2;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubsystemDescription)) {
            return false;
        }
        SubsystemDescription that = (SubsystemDescription)o;
        if (this.getId() != that.getId()) {
            return false;
        }
        if (!this.getSubsystemName().equals(that.getSubsystemName())) {
            return false;
        }
        String tag = this.getTag();
        return !(tag != null ? !tag.equals(that.getTag()) : that.getTag() != null);
    }

    public int hashCode() {
        int result = this.getSubsystemName().hashCode();
        String tag = this.getTag();
        result = 31 * result + (tag != null ? tag.hashCode() : 0);
        long id = this.getId();
        result = 31 * result + (int)(id ^ id >>> 32);
        return result;
    }

    public String toString() {
        return "{id=" + this.getId() + ";descriptions=" + this.getParamDescriptionSet() + '}';
    }

    public ParameterDescription fetch(PathObject path) {
        for (ParameterDescription parameterDescription : this.getParamDescriptionSet()) {
            if (!parameterDescription.getPath().equals(path.getPath())) continue;
            return parameterDescription;
        }
        return null;
    }

    public abstract void addParameterDescriptions(ParameterDescription ... var1);

    public abstract void addParameterDescriptions(Collection<ParameterDescription> var1);

    public abstract void removeParameterDescriptions(ParameterDescription ... var1);

    public ComponentNode getTopComponentNode() {
        ComponentNode top;
        switch (this.dataFlavour) {
            case TREE_FROM_SOURCE: {
                top = ((TextAndNode)this.configurationData).getComponentNode();
                break;
            }
            case PURE_OBJECT_TREE: {
                if (!(this.configurationData instanceof ComponentNode)) {
                    throw new IllegalArgumentException("Object data not a ComponentNode");
                }
                top = (ComponentNode)this.configurationData;
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.dataFlavour) + " not supported yet!");
            }
        }
        return top;
    }

    public ComponentNode check() throws Exception {
        ComponentNode top = this.getTopComponentNode();
        this.checkNodeTree(top);
        ComponentFactory factory = new ComponentFactory(top);
        return factory.buildObjectTreeFrom(top);
    }

    private void checkNodeTree(ComponentNode top) {
        Collection<ParameterDescription> parmDesc = SubsystemDescription.parameterDescriptionsFromNode(top, DEFAULT_TREE_PARAMETER_FILTER, 10);
        for (ParameterDescription parameterDescription : parmDesc) {
            Constraints.check(parameterDescription.getTypeName(), parameterDescription.getDefaultValue(), parameterDescription.getConstraints());
        }
        ArrayList children = top.getChildren();
        if (children != null) {
            for (ComponentNode child : children) {
                this.checkNodeTree(child);
            }
        }
    }

    public void generateConfigProperties(PrintWriter writer, int levelMax) {
        ArrayList<? extends ParameterDescription> list = new ArrayList<ParameterDescription>(this.getParamDescriptionSet());
        Collections.sort(list, PathObject.COMPARATOR);
        for (ParameterDescription parameterDescription : list) {
            if (parameterDescription.getLevel() > levelMax) continue;
            writer.println(parameterDescription.toPropertyString());
        }
    }

    public ComponentNode getModifiedConfigurationData(Properties configProps) throws RuntimeException {
        ComponentNode res = this.getTopComponentNode().clone();
        Set<? extends ParameterDescription> paramDescriptions = this.getParamDescriptionSet();
        if (paramDescriptions.size() == 0) {
            throw new IllegalStateException("Description with no parametersDescription: populate first");
        }
        for (ParameterDescription parameterDescription : paramDescriptions) {
            ParameterPath path = parameterDescription.getPath();
            String pathName = path.toString();
            String value = configProps.getProperty(pathName);
            if (value == null && (value = configProps.getProperty(parameterDescription.getSimpleName())) == null) continue;
            Object realValue = Constraints.check(parameterDescription.getTypeName(), value, parameterDescription.getConstraints());
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            ComponentNode goalComponent = (ComponentNode)res.getNodeByName(componentName);
            Object rawParm = goalComponent.getAttributes().get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                hollow.modifyChecked(realValue);
                Tracer.trace((Tracer)Tracer.NODE_MODIF, (Object[])new Object[]{"modified parameter ", componentName, "//", parameterName, ". new value=", realValue});
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
        Tracer.trace((Tracer)Tracer.NODE_MODIF, (Object[])new Object[]{"modification of node ", res});
        return res;
    }

    public Map<String, ParameterDescription> generateDescriptionMap() {
        HashMap<String, ParameterDescription> map = new HashMap<String, ParameterDescription>();
        for (ParameterDescription parameterDescription : this.getParamDescriptionSet()) {
            map.put(parameterDescription.getPath().toString(), parameterDescription);
            String simpleName = parameterDescription.getSimpleName();
            if (simpleName == null || "".equals(simpleName.trim())) continue;
            map.put(simpleName.trim(), parameterDescription);
        }
        return map;
    }

    public Collection<ParameterBase> getBaseParameters(ParameterFilter filter) {
        ComponentNode top = this.getTopComponentNode();
        return this.getBaseParametersFromTree(top, filter);
    }

    public Collection<ParameterBase> getBaseParameters() {
        ComponentNode top = this.getTopComponentNode();
        return this.getBaseParametersFromTree(top, DEFAULT_TREE_PARAMETER_FILTER);
    }

    Collection<ParameterBase> getBaseParametersFromTree(ComponentNode top, ParameterFilter filter) {
        ArrayList<ParameterBase> list = new ArrayList<ParameterBase>();
        SubsystemDescription.populateParameterBasesFromTop(list, top, filter);
        return list;
    }

    public static Collection<ParameterBase> parametersFromNode(ComponentNode node, ParameterFilter filter) {
        ArrayList<ParameterBase> res = new ArrayList<ParameterBase>();
        Map attributes = node.getAttributes();
        String nodeKey = node.getKey();
        if (attributes != null) {
            Set keyVals = attributes.entrySet();
            for (Map.Entry entry : keyVals) {
                HollowParm hollow;
                Object val = entry.getValue();
                String parmName = (String)entry.getKey();
                if (!filter.filter(parmName, val) || !(val instanceof HollowParm) || (hollow = (HollowParm)val).isReadOnly()) continue;
                String typeName = hollow.getValueClass().getName();
                ParameterBase base = new ParameterBase(nodeKey, "", parmName, typeName, hollow.toString());
                res.add(base);
            }
        }
        return res;
    }

    public static void populateParameterBasesFromTop(Collection<ParameterBase> list, ComponentNode topNode, ParameterFilter filter) {
        list.addAll(SubsystemDescription.parametersFromNode(topNode, filter));
        ArrayList children = topNode.getChildren();
        if (children != null) {
            for (ComponentNode childNode : children) {
                SubsystemDescription.populateParameterBasesFromTop(list, childNode, filter);
            }
        }
    }

    public Collection<ParameterDescription> getPossibleDescriptions(int maxLevel, ParameterFilter filter) {
        ComponentNode top = this.getTopComponentNode();
        ArrayList<ParameterDescription> list = new ArrayList<ParameterDescription>();
        SubsystemDescription.populateParameterDescriptionsFromTop(list, top, filter, maxLevel);
        return list;
    }

    public Collection<ParameterDescription> getPossibleDescriptions(int maxLevel) {
        return this.getPossibleDescriptions(maxLevel, DEFAULT_TREE_PARAMETER_FILTER);
    }

    public static void populateParameterDescriptionsFromTop(Collection<ParameterDescription> list, ComponentNode topNode, ParameterFilter filter, int maxLevel) {
        list.addAll(SubsystemDescription.parameterDescriptionsFromNode(topNode, filter, maxLevel));
        ArrayList children = topNode.getChildren();
        if (children != null) {
            for (ComponentNode childNode : children) {
                SubsystemDescription.populateParameterDescriptionsFromTop(list, childNode, filter, maxLevel);
            }
        }
    }

    public static Collection<ParameterDescription> parameterDescriptionsFromNode(ComponentNode node, ParameterFilter filter, int maxLevel) {
        ArrayList<ParameterDescription> res = new ArrayList<ParameterDescription>();
        Map attributes = node.getAttributes();
        String nodeKey = node.getKey();
        if (attributes != null) {
            Set keyVals = attributes.entrySet();
            for (Map.Entry entry : keyVals) {
                HollowParm hollow;
                Object val = entry.getValue();
                String parmName = (String)entry.getKey();
                if (!filter.filter(parmName, val) || !(val instanceof HollowParm) || (hollow = (HollowParm)val).isReadOnly()) continue;
                String typeName = hollow.getValueClass().getName();
                ParameterBase base = new ParameterBase(nodeKey, "", parmName, typeName, hollow.toString());
                String description = "";
                String simpleName = "";
                String constraints = "";
                boolean notModifiableAtRuntime = false;
                int level = 10;
                Properties props = hollow.getProperties();
                if (props != null) {
                    String isStatic;
                    description = props.getProperty("description", "");
                    simpleName = props.getProperty("simpleName", "");
                    constraints = props.getProperty("constraints", "");
                    String request = props.getProperty("level");
                    if (request != null) {
                        level = Integer.parseInt(request);
                    }
                    if ((isStatic = props.getProperty("static")) != null) {
                        notModifiableAtRuntime = Boolean.valueOf(isStatic);
                    }
                }
                if (level > maxLevel) continue;
                AParameterDescription parmDescription = new AParameterDescription(base, description, simpleName, constraints, level);
                parmDescription.setNotModifiableAtRuntime(notModifiableAtRuntime);
                res.add(parmDescription);
            }
        }
        return res;
    }
}

