/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.gruth.jutils.CallBuilders;
import org.lsst.gruth.jutils.IndirectMap;
import org.lsst.gruth.jutils.MapArgs;
import org.lsst.gruth.jutils.MethodsCalls;
import org.lsst.gruth.jutils.PackCst;
import org.lsst.gruth.utils.Tracer;

public class ComponentNode
implements Serializable,
Cloneable {
    protected IndirectMap<String, Object> nodeDict;
    protected boolean root;
    protected boolean orphan;
    protected ComponentNode calls;
    protected String key;
    protected ComponentNode parent;
    protected String name;
    protected String simpleDescription;
    protected Object realValue;
    protected Map attributes;
    protected ArrayList<ComponentNode> children;

    public IndirectMap getNodeDict() {
        return this.nodeDict;
    }

    public void setNodeDict(IndirectMap<String, Object> registry) {
        this.nodeDict = registry;
    }

    private void checkDict(ComponentNode parent, Object name, Map attributes) {
        IndirectHash<String, Object> dict;
        if (parent == null) {
            dict = new IndirectHash<String, Object>();
            this.root = true;
        } else {
            dict = parent.getNodeDict();
        }
        this.setDict(dict, name, attributes);
    }

    private void setDict(IndirectMap<String, Object> registry, Object name, Map attributes) {
        String altName;
        Object valName;
        String keyStr;
        this.key = keyStr = String.valueOf(name);
        this.name = keyStr;
        if (attributes != null && (valName = attributes.get("name")) != null) {
            String realName;
            this.name = realName = String.valueOf(valName);
        }
        registry.put(keyStr, this);
        if (this.name != null && !keyStr.equalsIgnoreCase(altName = this.name.trim())) {
            registry.put(altName, this);
        }
        this.nodeDict = registry;
    }

    public ComponentNode(ComponentNode parent, Object name) {
        this(parent, name, null, null);
    }

    public ComponentNode(ComponentNode parent, Object name, Object value) {
        this(parent, name, null, value);
    }

    public ComponentNode(ComponentNode parent, Object name, Map attributes) {
        this(parent, name, attributes, null);
    }

    public ComponentNode(ComponentNode parent, Object name, Map attributes, Object value) {
        this.parent = parent;
        this.simpleDescription = this.name = String.valueOf(name);
        this.attributes = attributes;
        this.realValue = value;
        this.checkDict(parent, name, attributes);
    }

    private ComponentNode(IndirectMap<String, Object> registry, Object name, String key, Map attributes, Object value) {
        this.simpleDescription = this.name = String.valueOf(name);
        this.attributes = attributes;
        this.realValue = value;
        this.setDict(registry, name, attributes);
        this.orphan = true;
    }

    public ComponentNode clone() {
        Map newAttributes = this.attributes;
        if (this.attributes instanceof MapArgs) {
            newAttributes = ((MapArgs)this.attributes).clone();
        }
        ComponentNode res = new ComponentNode(null, this.name, newAttributes, this.realValue);
        res.setSimpleDescription(this.simpleDescription);
        if (this.children != null) {
            for (ComponentNode child : this.children) {
                ComponentNode newChild = child.clone();
                newChild.parent = null;
                res.addChild(newChild);
            }
        }
        if (this.calls != null) {
            res.calls = this.calls.clone();
        }
        return res;
    }

    public Object calls(Object callDescription) {
        CallBuilders.CallBuilds builder = CallBuilders.getCallBuilder();
        this.calls = builder.buildCalls(this, callDescription);
        return this;
    }

    public ComponentNode setCalls(ComponentNode callsNode) {
        this.calls = callsNode;
        return this;
    }

    public Object doInvoke(String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object support = this.getRealValue();
        return this.invocation(support, methodName, args);
    }

    private Object invocation(Object support, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (support != null) {
            return MethodsCalls.invokeMethod(support, methodName, args);
        }
        return null;
    }

    public Object invokeOn(String objectName, String methodName, Object ... args) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object obj = this.getIndirect(objectName);
        return this.invocation(obj, methodName, args);
    }

    public void doCalls() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object curObj = this.getRealValue();
        if (curObj == null) {
            return;
        }
        if (this.calls != null) {
            ComponentNode topCalls = this.calls;
            ArrayList<ComponentNode> children = topCalls.getChildren();
            if (children == null) {
                System.out.println("empty calls node");
                return;
            }
            for (ComponentNode child : children) {
                String methodName = child.getName();
                Map attrib = child.getAttributes();
                if (attrib == null) {
                    this.invocation(curObj, methodName, new Object[0]);
                    continue;
                }
                MapArgs mapArgs = (MapArgs)attrib;
                if (!(this.nodeDict instanceof IndirectMap)) continue;
                Object[] args = mapArgs.asFullArray(this.nodeDict);
                this.invocation(curObj, methodName, args);
            }
        }
    }

    public void doCallsFromTop() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.doCalls();
        ArrayList<ComponentNode> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ComponentNode child : children) {
            child.doCallsFromTop();
        }
    }

    public void doCallsFromBase() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        for (ComponentNode child : this.getChildren()) {
            child.doCalls();
        }
        this.doCalls();
    }

    public static ComponentNode createOrphan(IndirectMap<String, Object> registry, Object name, String key) {
        return new ComponentNode(registry, name, key, null, null);
    }

    public static ComponentNode createOrphan(IndirectMap<String, Object> registry, Object name, String key, Object value) {
        return new ComponentNode(registry, name, key, null, value);
    }

    public static ComponentNode createOrphan(IndirectMap<String, Object> registry, Object name, String key, Map attributes) {
        return new ComponentNode(registry, name, key, attributes, null);
    }

    public static ComponentNode createOrphan(IndirectMap<String, Object> registry, Object name, String key, Map attributes, Object value) {
        return new ComponentNode(registry, name, key, attributes, value);
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean isRoot) {
        this.root = isRoot;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public ComponentNode getCalls() {
        return this.calls;
    }

    public ComponentNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleDescription() {
        return this.simpleDescription;
    }

    public void setSimpleDescription(String simpleDescription) {
        this.simpleDescription = simpleDescription;
    }

    public Object getRealValue() {
        return this.realValue;
    }

    public Object getNodeByName(String name) {
        return this.nodeDict.get(name);
    }

    public Object getIndirect(Object key) {
        Object node = this.nodeDict.get(key);
        if (node instanceof ComponentNode) {
            return ((ComponentNode)node).getRealValue();
        }
        return node;
    }

    public Iterator<String> getAllKeys() {
        return this.nodeDict.keySet().iterator();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getKey() {
        return this.key;
    }

    public void adoptOrphans(IndirectMap<String, Object> registry, ArrayList<ComponentNode> children, ComponentNode parent) throws NullPointerException, IllegalArgumentException {
        for (ComponentNode child : children) {
            child.orphan = false;
            if (child.parent == null) {
                if (child.nodeDict != registry) {
                    registry.putAll(child.getNodeDict());
                    child.nodeDict = registry;
                }
            } else {
                throw new IllegalArgumentException("child added but is part of another node tree");
            }
            child.parent = parent;
            child.root = false;
        }
        if (this.children == null) {
            this.children = children;
        } else {
            this.children.addAll(children);
        }
    }

    public ArrayList<ComponentNode> getChildren() {
        return this.children;
    }

    public void addChild(ComponentNode child) throws NullPointerException {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (child.parent == null) {
            child.root = false;
            if (child.nodeDict != null && child.nodeDict != this.nodeDict) {
                this.nodeDict.putAll(child.getNodeDict());
                child.nodeDict = this.nodeDict;
            } else {
                child.setDict(this.nodeDict, child.getName(), child.getAttributes());
            }
        } else if (child.parent != this) {
            throw new IllegalArgumentException("child added but is part of another node tree");
        }
        this.children.add(child);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.name)) + "(" + String.valueOf(this.realValue) + "," + String.valueOf(this.attributes) + ") {" + String.valueOf(this.children) + "}";
    }

    static class IndirectHash<K, V>
    extends HashMap<K, V>
    implements IndirectMap<K, V> {
        IndirectHash() {
        }

        @Override
        public Object getIndirect(Object key) {
            Object obj = this.get(key);
            if (obj instanceof ComponentNode) {
                obj = ((ComponentNode)obj).getRealValue();
            }
            Tracer.trace(Tracer.NODE_BUILD, "reference to ", key, " ", obj);
            if (obj == null) {
                PackCst._LOGGER.log(Level.WARNING, "null reference associated to " + key);
            }
            return obj;
        }
    }
}

