/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jgroups;

import org.apache.log4j.Logger;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.MessagingApplicationLayer;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.jgroups.GroupTopic;
import org.lsst.ccs.utilities.dispatch.CommandFor;
import org.lsst.ccs.utilities.dispatch.ParallelCommandDispatcher;
import org.lsst.ccs.utilities.dispatch.ParallelDispatchProxy;

@Deprecated
public class JGroupsMessagingFactory
extends MessagingFactory {
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.bus.jgroups");
    private MessagingApplicationLayer appLayer = new MessagingApplicationLayer();
    private ParallelCommandDispatcher<CommandListener> dispatchCommands;
    private ParallelDispatchProxy<StatusListener> proxyStatus;
    private ParallelDispatchProxy<LogListener> proxyLog;
    private ReceiverAdapter receiverCommands;
    private ReceiverAdapter receiverStatus;
    private ReceiverAdapter receiverLog;
    private GroupTopic commandTopic;
    private GroupTopic statusTopic;
    private GroupTopic logTopic;

    public JGroupsMessagingFactory() {
        log.info((Object)"JGROUPS: creating factory");
        try {
            this.commandTopic = GroupTopic.create("command", "UDP(mcast_port=26969)");
            this.statusTopic = GroupTopic.create("status", "UDP(mcast_port=36969)");
            this.logTopic = GroupTopic.create("log", "UDP(mcast_port=46969)");
        }
        catch (Exception e) {
            log.fatal((Object)"group creation", (Throwable)e);
            throw new Error("group communication cannot start: " + e);
        }
    }

    synchronized void initListenToCommand() {
        if (this.commandTopic.getAdapter() == null) {
            log.info((Object)"JGROUPS:initializing command listen");
            this.dispatchCommands = new ParallelCommandDispatcher();
            this.receiverCommands = new ReceiverAdapter(){

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof Command) {
                            final Command command = (Command)payload;
                            log.info((Object)("####receiving command: " + command));
                            CommandFor<CommandListener> toBeDone = new CommandFor<CommandListener>(){

                                public void invokeOn(CommandListener listener) {
                                    Command transformed = JGroupsMessagingFactory.this.appLayer.receivingCommand(command);
                                    if (transformed != null) {
                                        listener.onCommand(transformed);
                                    }
                                }

                                public String toString() {
                                    return "CommandFor #" + command.hashCode();
                                }
                            };
                            JGroupsMessagingFactory.this.dispatchCommands.dispatchCommand((CommandFor)toBeDone);
                        } else if (payload instanceof CommandAckOrReply) {
                            final CommandAckOrReply reply = (CommandAckOrReply)payload;
                            log.info((Object)("####receiving reply: " + reply.hashCode() + "  " + reply));
                            CommandFor<CommandListener> toBeDone = new CommandFor<CommandListener>(){

                                public void invokeOn(CommandListener listener) {
                                    CommandAckOrReply transformed = JGroupsMessagingFactory.this.appLayer.receivingReply(reply);
                                    if (transformed != null) {
                                        if (transformed instanceof CommandReply) {
                                            listener.onReply((CommandReply)transformed);
                                        } else {
                                            listener.onAck((CommandAck)transformed);
                                        }
                                    }
                                }

                                public String toString() {
                                    return "ReplyFor #" + reply.hashCode();
                                }
                            };
                            JGroupsMessagingFactory.this.dispatchCommands.dispatchCommand((CommandFor)toBeDone);
                        } else {
                            log.warn((Object)("Message payload type " + payload.getClass().getName() + " not handled " + payload));
                        }
                    }
                    catch (Exception exc) {
                        log.error((Object)"object not deserialized: ", (Throwable)exc);
                    }
                }
            };
            this.commandTopic.setAdapter(this.receiverCommands);
        }
    }

    @Override
    public void addCommandListener(CommandListener l) {
        this.initListenToCommand();
        this.dispatchCommands.addExecutant((Object)l);
    }

    @Override
    public void removeCommandListener(CommandListener l) {
    }

    synchronized void initListenToStatus() {
        if (this.statusTopic.getAdapter() == null) {
            log.info((Object)"JGROUPS: initializing status listen");
            this.proxyStatus = new ParallelDispatchProxy(StatusListener.class);
            this.receiverStatus = new ReceiverAdapter(){
                StatusListener proxy;
                {
                    this.proxy = (StatusListener)JGroupsMessagingFactory.this.proxyStatus.getProxy();
                }

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof Status) {
                            Status status = JGroupsMessagingFactory.this.appLayer.receivingStatus((Status)payload);
                            if (status != null) {
                                this.proxy.onStatus((BusMessage)status);
                            }
                        } else {
                            log.warn((Object)("Message payload type " + payload.getClass().getName() + " not handled " + payload));
                        }
                    }
                    catch (Exception exc) {
                        log.error((Object)"object not deserialized: ", (Throwable)exc);
                    }
                }
            };
            this.statusTopic.setAdapter(this.receiverStatus);
        }
    }

    @Override
    public void addStatusListener(StatusListener l) {
        this.initListenToStatus();
        this.proxyStatus.addExecutant((Object)l);
    }

    @Override
    public void removeStatusListener(StatusListener l) {
    }

    synchronized void initListenToLog() {
        if (this.logTopic.getAdapter() == null) {
            log.info((Object)"JGROUPS: initializing log listen");
            this.proxyLog = new ParallelDispatchProxy(LogListener.class);
            this.receiverLog = new ReceiverAdapter(){
                LogListener proxy;
                {
                    this.proxy = (LogListener)JGroupsMessagingFactory.this.proxyLog.getProxy();
                }

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof LogEvent) {
                            LogEvent event = JGroupsMessagingFactory.this.appLayer.receivingLog((LogEvent)payload);
                            if (event != null) {
                                this.proxy.onLog(event);
                            }
                        } else {
                            log.warn((Object)("Message payload type " + payload.getClass().getName() + " not handled " + payload));
                        }
                    }
                    catch (Exception exc) {
                        log.error((Object)"object not deserialized: ", (Throwable)exc);
                    }
                }
            };
            this.logTopic.setAdapter(this.receiverLog);
        }
    }

    @Override
    public void addLogListener(LogListener l) {
        this.initListenToLog();
        this.proxyLog.addExecutant((Object)l);
    }

    @Override
    public void removeLogListener(LogListener l) {
    }

    @Override
    public void addCommandListener(CommandListener l, String selector) {
        this.initListenToCommand();
        this.dispatchCommands.addExecutant((Object)l);
    }

    @Override
    public void addStatusListener(StatusListener l, String selector) {
        this.initListenToStatus();
        this.proxyStatus.addExecutant((Object)l);
    }

    @Override
    public void addLogListener(LogListener l, String selector) {
        this.initListenToLog();
        this.proxyLog.addExecutant((Object)l);
    }

    @Override
    public void sendCommand(Command cmd) {
        Command todo = this.appLayer.commandForSending(cmd);
        if (todo == null) {
            return;
        }
        try {
            log.info((Object)("JGROUPS: sending command from" + MessagingFactory.getInstance().getSubsystemName() + "(" + cmd.getOrigin() + " ?) to " + cmd.getDestination()));
            this.commandTopic.sendMessage(todo);
        }
        catch (Exception e) {
            log.error((Object)"sending command message", (Throwable)e);
        }
    }

    @Override
    public void sendStatus(Status status) {
        log.info((Object)"JGROUPS: sending status");
        Status todo = this.appLayer.statusForSending(status);
        if (todo == null) {
            return;
        }
        try {
            this.statusTopic.sendMessage(todo);
        }
        catch (Exception e) {
            log.error((Object)"sending status message", (Throwable)e);
        }
    }

    @Override
    public void sendLogEvent(LogEvent evt) {
        LogEvent todo = this.appLayer.logForSending(evt);
        if (todo == null) {
            return;
        }
        try {
            this.logTopic.sendMessage(todo);
        }
        catch (Exception e) {
            log.error((Object)"sending log message", (Throwable)e);
        }
    }

    @Override
    public String getToken() {
        return this.appLayer.getToken();
    }

    @Override
    public void reply(CommandAckOrReply cmd) {
        CommandAckOrReply todo = this.appLayer.replyForSending(cmd);
        try {
            this.commandTopic.sendMessage(todo);
        }
        catch (Exception e) {
            log.error((Object)"sending reply message", (Throwable)e);
        }
    }

    @Override
    public boolean isReplyRequested() {
        return this.appLayer.isReplyRequested();
    }

    @Override
    public void noAutoReply() {
        this.appLayer.noAutoReply();
    }

    @Override
    public void shutdownBusAccess() {
        GroupTopic.closeAll();
    }
}

