/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.concurrent.Future;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.scripting.ScriptingCommandResponse;
import org.lsst.ccs.scripting.ScriptingTimeoutException;
import org.lsst.ccs.utilities.tracers.Names;

public class ScriptingSubsystemWrapper
extends Subsystem {
    private String subsystemName;
    private SynchronousCommandAgent cmdAgent;

    public ScriptingSubsystemWrapper(String subsystemName) {
        this.setName(Names.almostUniqueAgentName((String)(String.valueOf(subsystemName) + "-script")));
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
        this.cmdAgent = new SynchronousCommandAgent(this.fac);
        this.subsystemName = subsystemName;
    }

    public ScriptingCommandResponse invokeSynchronous(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException {
        try {
            ModuleInvokerCommand cmd = new ModuleInvokerCommand(commandName, args);
            cmd.setDestination(this.subsystemName);
            Object result = this.cmdAgent.invoke((Command)cmd, timeout);
            String res = "";
            if (result != null) {
                res = result.toString();
            }
            return new ScriptingCommandResponse(res);
        }
        catch (Exception ex) {
            throw new ScriptingTimeoutException("timeout", ex);
        }
    }

    public ScriptingCommandResponse invokeSynchronous(int timeout, String command) throws ScriptingTimeoutException {
        return this.invokeSynchronous(timeout, command, null);
    }

    public Future<Object> invokeAsynchronous(String commandName, Object ... args) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(commandName, args);
        cmd.setDestination(this.subsystemName);
        return this.cmdAgent.invokeFuture((Command)cmd);
    }

    public Future<Object> invokeAsynchronous(String command) {
        return this.invokeAsynchronous(command, null);
    }
}

