/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.ModuleRegistry;
import org.lsst.ccs.framework.NodeCommand;
import org.lsst.ccs.framework.NodeTreeWalker;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;

public class Module
extends Observable
implements Observer,
Configurable {
    public static ModuleRegistry registry;
    Context context;
    protected Configurable.Environment environment;
    private static final long serialVersionUID = 2086404413177085779L;
    protected static Logger log;
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int nObserverThreads = 1;
    protected int tickMillis = -1;
    TimerTask timerTask;
    ExecutorService exec;
    Timer timer;

    static {
        log = Logger.getLogger((String)"lsst.ccs.framework");
    }

    public Module() {
    }

    public Module(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public Module(String name, int tickMillis) {
        this.name = name;
        this.tickMillis = tickMillis;
    }

    public Module(String name) {
        this(name, -1);
    }

    public String getName() {
        if (this.name == null && this.environment != null) {
            this.name = this.environment.getNameOfComponent();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void alias(String alias) {
        if (registry == null) {
            log.warn((Object)"cannot call alias in build phase (in constructors)", new String[0]);
            System.err.println("cannot call alias in build phase (in constructors)");
        } else {
            registry.aliasModule(alias, this);
        }
        if (this.environment != null) {
            this.environment.alias(alias);
        }
    }

    @Override
    public Configurable.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Configurable.Environment environment) {
        this.environment = environment;
    }

    @Command(description="returns the Command dictionary for this component", type=Command.CommandType.QUERY)
    public Dictionary getDictionary() {
        return this.environment.getDictionary();
    }

    public void setObservables(List<Observable> l) {
        this.observables.addAll(l);
    }

    public void listens(Observable ... observs) {
        Observable[] observableArray = observs;
        int n = observs.length;
        int n2 = 0;
        while (n2 < n) {
            Observable observable = observableArray[n2];
            this.observables.add(observable);
            ++n2;
        }
    }

    public List<Observable> getObservables() {
        return this.observables;
    }

    @ConfigChanger(argNames={"tickInterval"})
    public void setTickMillis(int tickMillis) {
        int old = this.tickMillis;
        this.tickMillis = tickMillis;
        if (this.timerTask != null && this.timer != null && tickMillis != old) {
            this.timerTask.cancel();
            if (tickMillis > 0) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        Module.this.tick();
                    }
                };
                this.timer.scheduleAtFixedRate(this.timerTask, old, (long)tickMillis);
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    public final void init() {
        this.initModule();
        for (Observable o : this.observables) {
            o.addObserver(this);
        }
        this.exec = Executors.newFixedThreadPool(this.nObserverThreads);
    }

    public void initModule() {
    }

    protected <T> Map<String, T> getChildren(Class<T> clazz) {
        return this.environment.getChildren(clazz);
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Subsystem getSubsystem() {
        return this.getContext().getSubsystem();
    }

    public Module getModule(String moduleName) {
        if (registry != null) {
            return registry.getModule(moduleName);
        }
        return null;
    }

    public void start() {
    }

    public void checkHardware() throws Exception {
    }

    public void startTicking() {
        this.timer = new Timer("timer_" + this.name);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Module.this.tick();
            }
        };
        if (this.tickMillis > 0) {
            this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)this.tickMillis);
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg), new String[0]);
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                Module.this.processUpdate(o, (ValueUpdate)arg);
            }
        });
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    public void setBeanName(String n) {
        this.name = n;
    }

    public void setStateModularSubsystem(PublishedState newState) {
        this.setStateModularSubsystem(newState, "");
    }

    public void setStateModularSubsystem(PublishedState newState, String extraInfo) {
        switch (newState) {
            case Offline: {
                throw new IllegalArgumentException("switching to state " + newState + "not supported");
            }
            case Ready: {
                this.getSubsystem().switchToReadyState(extraInfo);
                break;
            }
            case Active: {
                throw new IllegalArgumentException("switching to state " + newState + "not supported");
            }
            case InError: {
                this.getSubsystem().switchToErrorState(extraInfo);
                break;
            }
            case Recovering: {
                throw new IllegalArgumentException("switching to state " + newState + "not supported");
            }
        }
    }

    @Deprecated
    public void publishData(String name, Object value, long tStamp) {
        this.getSubsystem().publishData(name, value, tStamp);
    }

    public void publishData(String name, Serializable value, long tStamp) {
        this.getSubsystem().publishData(name, value, tStamp);
    }

    @Deprecated
    public void publishData(String name, Object value) {
        this.getSubsystem().publishData(name, value);
    }

    public void publishData(String name, Serializable value) {
        this.getSubsystem().publishData(name, value);
    }

    public void publishData(List<ValueNotification> tdl) {
        this.getSubsystem().publishData(tdl);
    }

    @Deprecated
    public void publishData(ValueNotification td) {
        this.getSubsystem().publishData(td);
    }

    public void publishData(DataValueNotification td) {
        this.getSubsystem().publishData(td);
    }

    public void sendToStatus(Status status) {
        this.getSubsystem().broadcastStatus(status);
    }

    @Deprecated
    public void sendToReply(CommandReply myReply) {
        this.getSubsystem().publishReply(myReply);
    }

    public void shutdownNow() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    @Command(description="will shutdown the subsystem (asynchronous execution)", type=Command.CommandType.ACTION)
    public void shutdownCommand() {
        Thread shutter = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                Module.this.getSubsystem().shutdown();
            }
        };
        shutter.start();
    }

    public TreeWalkerDiag signal(Signal sig) {
        return TreeWalkerDiag.GO;
    }

    @Command(description="will propagate signal to Module and its children ", type=Command.CommandType.ABORT)
    public void interrupt(String signalString) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel);
        this.percolateSignal(signal);
    }

    @Command(description="will propagate signal to Module and its children with  an expected maximum delay", type=Command.CommandType.ABORT)
    public void interrupt(String signalString, long expectedMaxDelay) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel, expectedMaxDelay);
        this.percolateSignal(signal);
    }

    public void percolateSignal(final Signal signal) {
        NodeTreeWalker treeWalker = new NodeTreeWalker(new NodeCommand(){

            @Override
            public TreeWalkerDiag evalOn(Configurable configurable) {
                if (configurable instanceof Module) {
                    Module module = (Module)configurable;
                    return module.signal(signal);
                }
                return TreeWalkerDiag.GO;
            }
        });
        treeWalker.invokeOn(this);
    }

    @Command(description="will create a new context for modifying parameters (engineering mode)", type=Command.CommandType.CONFIGURATION)
    public final void newConfigurationContext() {
        this.environment.newConfigurationContext();
    }

    @Override
    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION)
    public final void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) throws Exception {
        this.environment.change(parameterName, value);
    }

    @Command(description="registers a new configuration with name and tag", type=Command.CommandType.CONFIGURATION)
    public final void register(@Argument(name="configurationName", description="The Name of the Configuration") String configurationName, @Argument(name="tag", description="The new tag name", defaultValue="") String tag) throws IOException {
        this.environment.register(configurationName, tag);
    }

    @Command(description="will drop context for modifying parameters (engineering mode)", type=Command.CommandType.CONFIGURATION)
    public void dropConfigurationContext() {
        this.environment.dropConfigurationContext();
    }

    protected ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.environment.getCheckedValueFromConfiguration(parameterName, value);
        return data;
    }

    protected void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.environment.notifyChangeWithoutPreliminaryChecks(parameterName, value);
    }

    protected void notifyChange(String parameterName, String value) throws Exception {
        this.environment.notifyChange(parameterName, value);
    }

    @Command(description="sets Level for Log Bus Handler")
    public void setHandlerLevel(@Argument(name="level", description="The new level for the Log Bus Handler") String levelName) {
        this.getSubsystem().setBusLogHandlerLevel(levelName);
    }

    @Command(description="sets Level for a given package or concern")
    public void setLogLevel(@Argument(name="loggerName", description="The name of logger") String loggerName, @Argument(name="level", description="The name of the level") String levelName) {
        this.getSubsystem().setLogLevel(loggerName, levelName);
    }

    @Command(description="tries to restore a Log bus that entered panic state")
    public void removeLogPanicState() {
        this.getSubsystem().removeLogPanicState();
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

