/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.utils;

import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.utilities.dispatch.InvocationDispenser;
import org.lsst.ccs.utilities.dispatch.Invoker;

public class SynchronousCommandAgent {
    private InvocationDispenser dispenser = new InvocationDispenser();
    private MessagingFactory fac;
    public static final Logger CURLOG = Logger.getLogger("org.lsst.ccs.core.bus.utils");
    Invoker dummyInvoker = new Invoker(){

        public Object invoke(Object ... args) throws Exception {
            return args[0];
        }
    };
    Invoker dumpInvoker = new Invoker(){

        public Object invoke(Object ... args) throws Exception {
            CURLOG.log(Level.INFO, " async command return " + Arrays.toString(args));
            return null;
        }
    };
    CommandListener commmandListener = new CommandListener(){

        public void onCommand(Command m) {
        }

        public void onReply(CommandReply r) {
            String correlId = r.getCorrelId();
            if (SynchronousCommandAgent.this.dispenser.isTokenUsed(correlId)) {
                Object res = r.getReply();
                try {
                    SynchronousCommandAgent.this.dispenser.callBack(correlId, new Object[]{res});
                }
                catch (Exception e) {
                    CURLOG.log(Level.SEVERE, "", e);
                }
            }
        }

        public void onAck(CommandAck a) {
        }
    };

    public SynchronousCommandAgent(MessagingFactory fac) {
        this.fac = fac;
        fac.addCommandListener(this.commmandListener);
    }

    public CommandListener getCommmandListener() {
        return this.commmandListener;
    }

    public Object invoke(Command command, long millisTimeout) throws Exception {
        String correlId = command.getCorrelId();
        if (correlId == null) {
            correlId = this.dispenser.generateToken();
            command.setCorrelId(correlId);
        }
        Future future = this.dispenser.registerFuture(correlId, this.dummyInvoker);
        this.fac.sendCommand(command);
        Object res = null;
        try {
            res = future.get(millisTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException exc) {
            this.dispenser.dumpTask(correlId);
            throw exc;
        }
        if (res instanceof Exception) {
            throw (Exception)res;
        }
        return res;
    }

    public Future<Object> invokeFuture(Command command) {
        String correlId = command.getCorrelId();
        if (correlId == null) {
            correlId = this.dispenser.generateToken();
            command.setCorrelId(correlId);
        }
        Future future = this.dispenser.registerFuture(correlId, this.dummyInvoker);
        this.fac.sendCommand(command);
        return future;
    }

    public String invokeAsync(Command command) {
        String correlId = command.getCorrelId();
        if (correlId == null) {
            correlId = this.dispenser.generateToken();
            command.setCorrelId(correlId);
        }
        this.dispenser.register(correlId, this.dumpInvoker);
        this.fac.sendCommand(command);
        return correlId;
    }
}

