/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.SystemState;
import org.lsst.ccs.bus.Alarm;
import org.lsst.ccs.bus.AlarmClear;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusForEnd;
import org.lsst.ccs.bus.StatusForStart;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.SystemCommand;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.locking.LockArbitrator;
import org.lsst.ccs.bus.locking.RegisterBusMasterCommand;
import org.lsst.ccs.bus.utils.LogBusHandler;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Tracer;

public class Subsystem
implements CommandListener,
StatusListener,
CommandExecutor {
    protected volatile SystemState state = SystemState.Offline;
    protected String stateExtraInfo;
    int activeThreads = 0;
    protected volatile boolean shuttingDown = false;
    volatile int statusBroadcastPeriod = 5;
    protected static Logger log;
    protected MessagingFactory fac = MessagingFactory.getInstance();
    static String revision;
    protected String commandBusSelector = null;
    protected String statusBusSelector = null;
    protected boolean inTestContext = Boolean.getBoolean("org.lsst.ccs.testcontext");
    protected ConfigurationProxy configurationProxy = ConfigurationProxy.NONE;
    protected LogBusHandler logBusHandler;
    protected CommandSet commandSet;
    String name = "";
    String configuration = "";
    String tag = "";
    boolean listeningToStatus = false;
    boolean multithreaded = true;
    protected volatile Thread statusBroadcasterThread = null;
    protected Object statusBroadcasterLock = new Object();
    protected Map<String, LockArbitrator.LockOwnerInfo> locks = new HashMap<String, LockArbitrator.LockOwnerInfo>();
    protected static ThreadLocal<Subsystem> currentSubsystem;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !Subsystem.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev: 29517 $", Subsystem.class, (String)"org-lsst-ccs-core")) {
            throw new AssertionError();
        }
        String frameworkName = "org.lsst.ccs.framework.FrameworkUtils";
        try {
            Class.forName(frameworkName);
        }
        catch (Exception exception) {
            System.err.println("could not initialize " + frameworkName);
        }
        log = Logger.getLogger((String)"org.lsst.ccs.subsystem");
        revision = "$Rev: 29517 $";
        currentSubsystem = new ThreadLocal();
    }

    public static String getSoftwareRevision() {
        return revision;
    }

    public static String getEthHardAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                byte[] z;
                NetworkInterface itf = e.nextElement();
                if (!itf.isUp() || itf.isLoopback() || (z = itf.getHardwareAddress()) == null) continue;
                return String.format("%02x:%02x:%02x:%02x:%02x:%02x", z[0], z[1], z[2], z[3], z[4], z[5]);
            }
        }
        catch (SocketException e1) {
            log.error((Object)"cannot get hardware address", (Throwable)e1, new String[0]);
        }
        return null;
    }

    public Logger getLogger() {
        return log;
    }

    public void setListenToStatus(boolean listenToStatus) {
        this.listeningToStatus = listenToStatus;
    }

    public boolean isListenToStatus() {
        return this.listeningToStatus;
    }

    @Command(description="is the system in test context", type=Command.CommandType.QUERY)
    public boolean isInTestContext() {
        return this.inTestContext;
    }

    public void setName(String name) {
        this.name = name;
        this.fac = MessagingFactory.getInstance().forSubsystem(name);
        this.configurationProxy.setMessagingFactory(this.fac);
        this.initLogBusHandler();
    }

    protected void initLogBusHandler() {
        if (this.logBusHandler == null) {
            Handler[] handlers;
            java.util.logging.Logger generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
            Handler[] handlerArray = handlers = generalLogger.getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                if (handler instanceof LogBusHandler) {
                    LogBusHandler logHandler = (LogBusHandler)handler;
                    if (this.getName().equals(logHandler.getSubSystemName())) {
                        this.logBusHandler = logHandler;
                        return;
                    }
                }
                ++n2;
            }
            this.logBusHandler = new LogBusHandler(this.fac);
            generalLogger.addHandler(this.logBusHandler);
            if (!LogManagement.isConfigInitialized()) {
                generalLogger.setLevel(Level.WARNING);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getConfiguration() {
        return this.configurationProxy.getConfigurationName();
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    public void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
        this.configurationProxy.setMessagingFactory(this.fac);
    }

    public String getDefaultSelector() {
        return "destination = '" + this.name + "' OR destination = '*' or destination like '" + this.name + "/%'";
    }

    public String getStatusBusSelector() {
        return this.statusBusSelector == null ? this.getDefaultSelector() : this.statusBusSelector;
    }

    public void setStatusBusSelector(String selector) {
        this.statusBusSelector = selector;
    }

    public String getCommandBusSelector() {
        return this.commandBusSelector == null ? this.getDefaultSelector() : this.commandBusSelector;
    }

    public void setCommandBusSelector(String selector) {
        this.commandBusSelector = selector;
    }

    public void start() {
        log.info((Object)("Subsystem " + this.name + " starting with revision " + Subsystem.getSoftwareRevision()), new String[0]);
        log.info((Object)("running on MAC " + Subsystem.getEthHardAddress()), new String[0]);
        this.updateCurrentSubsystem();
        this.state = SystemState.Ready;
        this.stateExtraInfo = "";
        this.doStart();
        this.fac.addCommandListener((CommandListener)this, this.getCommandBusSelector());
        if (this.listeningToStatus) {
            this.fac.addStatusListener((StatusListener)this, this.getStatusBusSelector());
        }
        try {
            this.checkHardware();
        }
        catch (HardwareException e) {
            log.error((Object)"check hardware problem ", (Throwable)((Object)e), new String[0]);
            this.state = SystemState.InError;
            this.stateExtraInfo = e.toString();
        }
        this.startStatusBroadcasting();
        log.info((Object)("Subsystem " + this.name + " started"), new String[0]);
        this.postStart();
    }

    public void doStart() {
    }

    public void postStart() {
    }

    public void checkHardware() throws HardwareException {
    }

    public Status getStatus() {
        Status s = new Status();
        return this.fillStatus(s);
    }

    protected synchronized Status fillStatus(Status s) {
        s.setOrigin(this.getName());
        s.setState(this.state.getPublishedState());
        s.setSummary(this.stateExtraInfo);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusBroadcastPeriod(int statusBroadcastPeriod) {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            this.statusBroadcastPeriod = statusBroadcastPeriod;
            if (this.state != SystemState.Offline) {
                if (statusBroadcastPeriod == 0) {
                    this.stopStatusBroadcasting();
                } else {
                    this.startStatusBroadcasting();
                }
            }
        }
    }

    public int getStatusBroadcastPeriod() {
        return this.statusBroadcastPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            while (true) {
                if (this.statusBroadcasterThread == null) {
                    return;
                }
                if (this.statusBroadcastPeriod > 0) {
                    this.statusBroadcastPeriod = -this.statusBroadcastPeriod;
                }
                if (this.statusBroadcasterThread != null) {
                    this.statusBroadcasterThread.interrupt();
                }
                try {
                    this.statusBroadcasterLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (this.statusBroadcastPeriod == 0) {
                return;
            }
            if (this.statusBroadcastPeriod < 0) {
                this.statusBroadcastPeriod = -this.statusBroadcastPeriod;
            }
            if (this.statusBroadcasterThread != null) {
                this.stopStatusBroadcasting();
            }
            StatusForStart startMessage = new StatusForStart(this.configuration, this.tag);
            startMessage.setInTestContext(this.inTestContext);
            this.broadcastStatus((Status)startMessage);
            StatusBroadcaster run = new StatusBroadcaster();
            this.statusBroadcasterThread = new Thread((Runnable)run, String.valueOf(this.getName()) + "-broadcast");
            this.statusBroadcasterThread.start();
        }
    }

    public void broadcastStatus() {
        this.updateCurrentSubsystem();
        Status s = this.getStatus();
        log.debug((Object)("sending status " + s), new String[0]);
        this.fac.sendStatus(s);
    }

    public void broadcastStatus(Status s) {
        this.updateCurrentSubsystem();
        s = this.fillStatus(s);
        log.debug((Object)("sending status " + s), new String[0]);
        this.fac.sendStatus(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(description="shutdown", type=Command.CommandType.ABORT)
    public void shutdown() {
        log.info((Object)("Subsystem " + this.name + " shutdown starting"), new String[0]);
        this.shuttingDown = true;
        this.stopStatusBroadcasting();
        Subsystem subsystem = this;
        synchronized (subsystem) {
            while (true) {
                if (this.state != SystemState.Active) {
                    this.updateState(SystemState.Offline);
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.warn((Object)"wait interrupted", (Throwable)e, new String[0]);
                }
            }
        }
        this.broadcastStatus();
        StatusForEnd endmessage = new StatusForEnd(this.configuration, this.tag);
        endmessage.setInTestContext(this.inTestContext);
        this.broadcastStatus((Status)endmessage);
        log.info((Object)("Subsystem " + this.name + " shutdown completed"), new String[0]);
        this.fac.shutdownBusAccess();
    }

    @Command(description="halt", type=Command.CommandType.ABORT)
    public void halt() {
        log.info((Object)("Subsystem " + this.name + " halt requested"), new String[0]);
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.ABORT)
    public void halt(long expectedMaxDelay) {
        log.info((Object)("Subsystem " + this.name + " halt requested"), new String[0]);
    }

    public synchronized SystemState updateState(SystemState newState, String extraInfo) {
        this.stateExtraInfo = extraInfo;
        SystemState oldState = this.state;
        this.state = newState;
        if (oldState != newState) {
            if (newState == SystemState.InError) {
                this.broadcastAlarm();
            } else {
                this.broadcastStatus();
            }
        }
        return oldState;
    }

    public SystemState updateState(SystemState newState) {
        return this.updateState(newState, "");
    }

    public void switchToErrorState(String message) {
        this.updateState(SystemState.InError, message);
    }

    public void switchToReadyState(String message) {
        this.updateState(SystemState.Ready, message);
    }

    public boolean isMultithreaded() {
        return this.multithreaded;
    }

    public synchronized void setMultithreaded(boolean multithreaded) {
        this.multithreaded = multithreaded;
    }

    public static String getCurrentSubsystemName() {
        Subsystem sys = currentSubsystem.get();
        if (sys == null) {
            return null;
        }
        return sys.getName();
    }

    protected void updateCurrentSubsystem() {
        currentSubsystem.set(this);
    }

    public void addLock(String target, LockArbitrator.LockOwnerInfo info) {
        log.info((Object)("lock requested by " + info.ownerSubsystem), new String[0]);
        LockArbitrator.LockOwnerInfo old = this.locks.put(target, info);
        if (old != null) {
            log.warn((Object)("lock on " + target + "(" + info.ownerSubsystem + ") was alread held by " + old.ownerSubsystem + " overriden by " + info.ownerSubsystem), new String[0]);
        }
    }

    public void removeLock(String target) {
        LockArbitrator.LockOwnerInfo old = this.locks.remove(target);
        if (old == null) {
            log.warn((Object)("removal of nonexistent lock on " + target), new String[0]);
        } else {
            log.debug((Object)("lock on " + target + "(" + old.ownerSubsystem + ") held by token " + old.token + " removed"), new String[0]);
        }
    }

    public void lockUpdate(String target, LockArbitrator.LockOwnerInfo info, boolean isAdd) {
        if (isAdd) {
            this.addLock(target, info);
        } else {
            this.removeLock(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(org.lsst.ccs.bus.Command cmd) {
        block41: {
            if (!$assertionsDisabled && !Tracer.trace((String)("receiving : " + cmd))) {
                throw new AssertionError();
            }
            log.debug((Object)("subsytem got command " + cmd), new String[0]);
            Object result = null;
            CommandReply.CommandStatus status = CommandReply.CommandStatus.OK;
            if (this.shuttingDown) {
                log.warn((Object)("Command" + cmd + " rejected, shutting down"), new String[0]);
                return;
            }
            Subsystem subsystem = this;
            synchronized (subsystem) {
                if (cmd.isWrite()) {
                    String sys = cmd.getDestination();
                    while (sys != null) {
                        LockArbitrator.LockOwnerInfo lockInfo = this.locks.get(sys);
                        if (lockInfo != null && !lockInfo.token.equals(cmd.getKey())) {
                            log.warn((Object)("Command rejected, invalid lock key " + cmd.getKey() + " subsystem " + sys + " locked by " + lockInfo.ownerSubsystem), new String[0]);
                            status = CommandReply.CommandStatus.INVALID_LOCK;
                        }
                        if (sys.contains("/")) {
                            if (lockInfo == null) {
                                sys = sys.substring(0, sys.lastIndexOf(47));
                                continue;
                            }
                            log.warn((Object)("Command rejected, no lock, no access to subsystem " + sys), new String[0]);
                            status = CommandReply.CommandStatus.INVALID_LOCK;
                            continue;
                        }
                        sys = null;
                    }
                }
                if (!this.state.canProcess(cmd, this)) {
                    log.warn((Object)("Command rejected, invalid state" + (Object)((Object)this.state)), new String[0]);
                    status = CommandReply.CommandStatus.ERROR;
                }
                this.updateCurrentSubsystem();
                if (status == CommandReply.CommandStatus.OK) {
                    while (this.state == SystemState.Active && !cmd.canRunInActiveMode()) {
                        try {
                            log.warn((Object)"command not in active mode", new String[0]);
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)"wait interrupted", (Throwable)e, new String[0]);
                        }
                    }
                }
                this.updateState(SystemState.Active, cmd.getCorrelId());
                ++this.activeThreads;
            }
            try {
                try {
                    if (status == CommandReply.CommandStatus.OK) {
                        CommandAck ack = new CommandAck(cmd, MessagingFactory.getInstance().getSubsystemName());
                        this.fac.reply((CommandAckOrReply)ack);
                        Object realDestination = cmd instanceof SystemCommand ? this : this.getCommandDestination(cmd.getDestination());
                        CommandSet realCommandSet = this.getCommandSetFor(realDestination);
                        if (realCommandSet == null) {
                            result = this.rawCommandExecution(cmd, realDestination);
                        } else {
                            Object[] parms = cmd.getParameters();
                            String commandName = cmd.getCommand();
                            DictionaryCommand dictionaryCommand = realCommandSet.getCommandDictionary().findCommand(commandName, parms.length);
                            result = dictionaryCommand == null ? this.rawCommandExecution(cmd, realDestination) : (cmd.isUnParsed() ? realCommandSet.invoke(new TokenizedCommand(commandName)) : realCommandSet.invoke(new RawCommand(commandName, Arrays.asList(parms))));
                        }
                    }
                }
                catch (Throwable e) {
                    Object reply;
                    log.debug((Object)e, new String[0]);
                    status = CommandReply.CommandStatus.ERROR;
                    result = e;
                    if (this.fac.isReplyRequested()) {
                        reply = new CommandReply(cmd, result, status, MessagingFactory.getInstance().getSubsystemName());
                        log.trace((Object)("  reply will be sent  " + reply), new String[0]);
                        this.fac.reply((CommandAckOrReply)reply);
                    } else {
                        log.trace((Object)(" no reply will be sent for " + cmd), new String[0]);
                    }
                    reply = this;
                    synchronized (reply) {
                        --this.activeThreads;
                        if (this.activeThreads == 0 && this.state == SystemState.Active) {
                            this.updateState(SystemState.Ready);
                        }
                        this.notify();
                        break block41;
                    }
                }
            }
            catch (Throwable throwable) {
                Object reply;
                if (this.fac.isReplyRequested()) {
                    reply = new CommandReply(cmd, result, status, MessagingFactory.getInstance().getSubsystemName());
                    log.trace((Object)("  reply will be sent  " + reply), new String[0]);
                    this.fac.reply((CommandAckOrReply)reply);
                } else {
                    log.trace((Object)(" no reply will be sent for " + cmd), new String[0]);
                }
                reply = this;
                synchronized (reply) {
                    --this.activeThreads;
                    if (this.activeThreads == 0 && this.state == SystemState.Active) {
                        this.updateState(SystemState.Ready);
                    }
                    this.notify();
                }
                throw throwable;
            }
            if (this.fac.isReplyRequested()) {
                CommandReply reply = new CommandReply(cmd, result, status, MessagingFactory.getInstance().getSubsystemName());
                log.trace((Object)("  reply will be sent  " + reply), new String[0]);
                this.fac.reply((CommandAckOrReply)reply);
            } else {
                log.trace((Object)(" no reply will be sent for " + cmd), new String[0]);
            }
            Subsystem subsystem2 = this;
            synchronized (subsystem2) {
                --this.activeThreads;
                if (this.activeThreads == 0 && this.state == SystemState.Active) {
                    this.updateState(SystemState.Ready);
                }
                this.notify();
            }
        }
    }

    protected synchronized Object executeCommandSingleThread(org.lsst.ccs.bus.Command cmd) {
        return null;
    }

    protected Object getCommandDestination(String commandDestination) {
        return this;
    }

    protected CommandSet getCommandSetFor(Object object) {
        if (this.commandSet == null) {
            this.commandSet = new CommandSetBuilder().buildCommandSet(this);
        }
        return this.commandSet;
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY)
    public Dictionary getSystemDictionary() {
        return this.getCommandSetFor(this).getCommandDictionary();
    }

    protected Object rawCommandExecution(org.lsst.ccs.bus.Command cmd, Object obj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        log.trace((Object)("raw execution of  " + cmd + " for object " + obj), new String[0]);
        return MethodUtils.invokeMethod((Object)obj, (String)cmd.getCommand(), (Object[])cmd.getParameters());
    }

    public void onStatus(BusMessage s) {
    }

    public void onReply(CommandReply r) {
    }

    public void onAck(CommandAck a) {
    }

    public void registerAsBusMaster() {
        RegisterBusMasterCommand cmd = new RegisterBusMasterCommand();
        MessagingFactory mfac = MessagingFactory.getInstance().forSubsystem(this.getName());
        mfac.sendCommand((org.lsst.ccs.bus.Command)cmd);
    }

    @Deprecated
    public void publishData(String name, Object value, long tStamp) {
        ValueNotification td = new ValueNotification(name, value, tStamp);
        this.publishData(td);
    }

    public void publishData(String name, Serializable value, long tStamp) {
        DataValueNotification td = new DataValueNotification(name, value, tStamp);
        this.publishData(td);
    }

    @Deprecated
    public void publishData(String name, Object value) {
        ValueNotification td = new ValueNotification(name, value);
        this.publishData(td);
    }

    public void publishData(String name, Serializable value) {
        DataValueNotification td = new DataValueNotification(name, value);
        this.publishData(td);
    }

    public void publishData(List<? extends ValueNotification> tdl) {
        TrendingStatus ts = new TrendingStatus(tdl);
        this.publishTrendingStatus(ts);
    }

    @Deprecated
    public void publishData(ValueNotification td) {
        TrendingStatus ts = new TrendingStatus((Object)td);
        this.publishTrendingStatus(ts);
    }

    public void publishData(DataValueNotification td) {
        TrendingStatus ts = new TrendingStatus(td);
        this.publishTrendingStatus(ts);
    }

    protected void publishTrendingStatus(TrendingStatus ts) {
        ts = (TrendingStatus)this.fillStatus((Status)ts);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)ts);
    }

    public void publishMetaData(String dataname, String metadataname, String value) {
        MetadataStatus mst = new MetadataStatus(dataname, metadataname, value);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)mst);
    }

    public void broadcastAlarm() {
        this.broadcastAlarm(null);
    }

    public void broadcastAlarm(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((Status)alrm);
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
    }

    public void broadcastAlarmClear(String message) {
        AlarmClear alrm = new AlarmClear();
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
    }

    @Deprecated
    public void publishReply(CommandReply myReply) {
        this.fac.reply((CommandAckOrReply)myReply);
    }

    public void setBusLogHandlerLevel(String levelName) {
        if (this.logBusHandler != null) {
            Level level = Level.parse(levelName);
            this.logBusHandler.setLevel(level);
        }
    }

    public void setLogLevel(String keyLogger, String levelName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    public void removeLogPanicState() {
        if (this.logBusHandler != null) {
            this.logBusHandler.setPanicState(false);
        }
    }

    protected class StatusBroadcaster
    implements Runnable {
        protected StatusBroadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                Subsystem.this.updateCurrentSubsystem();
                while (true) {
                    Subsystem.this.broadcastStatus();
                    try {
                        int period = Subsystem.this.statusBroadcastPeriod;
                        if (period > 0) {
                            Thread.sleep(1000L * (long)period);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    Object object = Subsystem.this.statusBroadcasterLock;
                    // MONITORENTER : object
                    if (Subsystem.this.statusBroadcastPeriod > 0) break block17;
                    Subsystem.this.statusBroadcasterThread = null;
                    Subsystem.this.statusBroadcasterLock.notifyAll();
                    // MONITOREXIT : object
                    Object object2 = Subsystem.this.statusBroadcasterLock;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : object
                        throw throwable;
                    }
                }
                {
                    block17: {
                        // MONITORENTER : object2
                        Subsystem.this.statusBroadcasterThread = null;
                        Subsystem.this.statusBroadcasterLock.notifyAll();
                        // MONITOREXIT : object2
                        return;
                    }
                    // MONITOREXIT : object
                    continue;
                }
            }
            catch (Throwable throwable) {
                Object object = Subsystem.this.statusBroadcasterLock;
                // MONITORENTER : object
                Subsystem.this.statusBroadcasterThread = null;
                Subsystem.this.statusBroadcasterLock.notifyAll();
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }
}

