/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.annotationfactory;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationProxy;
import org.hibernate.annotations.common.test.annotationfactory.TestAnnotation;

public class AnnotationProxyTest
extends TestCase {
    private AnnotationProxy ann;
    private AnnotationDescriptor descriptor;

    public void setUp() {
        this.descriptor = new AnnotationDescriptor(TestAnnotation.class);
        this.descriptor.setValue("stringElement", (Object)"x");
        this.descriptor.setValue("booleanElement", (Object)false);
        this.descriptor.setValue("someOtherElement", (Object)"y");
        this.ann = new AnnotationProxy(this.descriptor);
    }

    public void testConstructionFailsIfYouDoNotAssignValuesToAllTheElementsWithoutADefault() {
        try {
            AnnotationDescriptor desc = new AnnotationDescriptor(TestAnnotation.class);
            desc.setValue("stringElement", (Object)"x");
            desc.setValue("booleanElement", (Object)false);
            new AnnotationProxy(desc);
            AnnotationProxyTest.fail();
        }
        catch (Exception e) {
            AnnotationProxyTest.assertEquals((String)"No value provided for someOtherElement", (String)e.getMessage());
        }
    }

    public void testConstructionFailsIfYouDefineElementsThatAreNotInTheAnnotationInterface() {
        try {
            AnnotationDescriptor desc = new AnnotationDescriptor(Deprecated.class);
            desc.setValue("wrongElement", (Object)"xxx");
            new AnnotationProxy(desc);
            AnnotationProxyTest.fail();
        }
        catch (Exception e) {
            AnnotationProxyTest.assertTrue((boolean)e.getMessage().contains("unknown elements"));
        }
    }

    public void testSupportsGenericCallsToAllElements() throws Throwable {
        AnnotationProxyTest.assertEquals((Object)"x", (Object)this.invoke(this.ann, "stringElement", new Object[0]));
        AnnotationProxyTest.assertFalse((boolean)((Boolean)this.invoke(this.ann, "booleanElement", new Object[0])));
    }

    public void testPretendsThatItHasTheGivenType() {
        AnnotationProxyTest.assertSame(TestAnnotation.class, (Object)this.ann.annotationType());
    }

    public void testItsToStringConformsToTheJavaAnnotationDocumentation() throws Throwable {
        String expectedString = "@org.hibernate.annotations.common.test.annotationfactory.TestAnnotation(booleanElement=false, elementWithDefault=abc, someOtherElement=y, stringElement=x)";
        AnnotationProxyTest.assertEquals((Object)expectedString, (Object)this.invoke(this.ann, "toString", new Object[0]));
    }

    public void testSupportsGenericCallsToMethods() throws Throwable {
        AnnotationProxyTest.assertEquals((Object)this.ann.annotationType(), (Object)this.invoke(this.ann, "annotationType", new Object[0]));
        AnnotationProxyTest.assertEquals((Object)this.ann.toString(), (Object)this.invoke(this.ann, "toString", new Object[0]));
    }

    public void testThrowsARuntimeExceptionIfYouUseAnElementWhichIsNotInTheAnnotationInterface() {
        AnnotationDescriptor elements = new AnnotationDescriptor(TestAnnotation.class);
        elements.setValue("anOddElement", (Object)"x");
        try {
            new AnnotationProxy(elements);
            AnnotationProxyTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testUsesTheDefaultValueForUndefinedElementsWhenAvailable() throws Throwable {
        AnnotationProxyTest.assertEquals((Object)"abc", (Object)this.invoke(this.ann, "elementWithDefault", new Object[0]));
    }

    public void testThrowsANoSuchMethodExceptionWhenAccessingAnUndefinedMethod() throws Throwable {
        try {
            this.invoke(this.ann, "anElementThatDoesNotExist", new Object[0]);
            AnnotationProxyTest.fail();
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            this.invoke(this.ann, "anOddElement", "arg1", "arg2");
            AnnotationProxyTest.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private Object invoke(AnnotationProxy proxy, String methodName, Object ... args) throws Throwable {
        Object[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        Method method = TestAnnotation.class.getMethod(methodName, (Class<?>[])parameterTypes);
        return proxy.invoke((Object)proxy, method, parameterTypes);
    }
}

