/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.ModuleRegistry;
import org.lsst.ccs.utilities.logging.Logger;

public class BasicModularSubSystem
extends Subsystem
implements ModuleRegistry {
    private Map<String, Module> moduleMap = new HashMap<String, Module>();
    private Set<Module> moduleSet = new HashSet<Module>();
    private Map<String, Configurable> configurableMap = new HashMap<String, Configurable>();
    private ModuleRegistry registry = new ModuleRegistry(){

        @Override
        public Module getModule(String moduleName) {
            return (Module)BasicModularSubSystem.this.moduleMap.get(moduleName);
        }

        @Override
        public Configurable getConfigurable(String name) {
            return (Configurable)BasicModularSubSystem.this.configurableMap.get(name);
        }

        @Override
        public void aliasModule(String alias, Configurable module) {
            if (module instanceof Module) {
                BasicModularSubSystem.this.moduleMap.put(alias, (Module)module);
            }
            BasicModularSubSystem.this.configurableMap.put(alias, module);
        }
    };
    private Context context;
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.framework");

    public BasicModularSubSystem(String name) {
        this.setName(name);
        Module.registry = this.registry;
        this.context = new Context();
        this.context.setSubsystem(this);
        this.context.setSubsystemName(name);
    }

    public void addModule(Module rawModule) {
        String key = rawModule.getName();
        if (key == null) {
            log.error((Object)("module " + rawModule + "with no name!"), new String[0]);
        } else {
            this.moduleMap.put(key, rawModule);
            this.moduleSet.add(rawModule);
            this.configurableMap.put(key, rawModule);
            rawModule.setContext(this.context);
            rawModule.init();
        }
    }

    protected void registerModule(Module rawModule) {
        String key = rawModule.getName();
        if (key == null) {
            log.error((Object)("module " + rawModule + "with no name!"), new String[0]);
        } else {
            this.moduleMap.put(key, rawModule);
            this.moduleSet.add(rawModule);
            this.configurableMap.put(key, rawModule);
        }
    }

    protected void registerConfigurable(String name, Configurable configurable) {
        String moduleName = null;
        if (configurable instanceof Module) {
            Module module = (Module)configurable;
            moduleName = module.getName();
            if (moduleName == null) {
                module.setName(name);
            } else if (!moduleName.equals(name)) {
                this.moduleMap.put(moduleName, module);
                this.configurableMap.put(moduleName, module);
            }
            this.moduleSet.add(module);
            this.moduleMap.put(name, module);
        }
        this.configurableMap.put(name, configurable);
    }

    protected void rawInitModule(Module rawModule) {
        rawModule.setContext(this.context);
        rawModule.init();
    }

    public void addModules(Module ... list) {
        Module[] moduleArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            this.addModule(module);
            ++n2;
        }
    }

    @Override
    public void doStart() {
        for (Module module : this.moduleSet) {
            module.start();
        }
    }

    @Override
    public void postStart() {
        for (Module module : this.moduleSet) {
            module.startTicking();
        }
    }

    @Override
    public void checkHardware() throws HardwareException {
        HardwareException excList = null;
        for (Module module : this.moduleSet) {
            try {
                module.checkHardware();
            }
            catch (Exception exc) {
                excList = new HardwareException(exc, excList);
            }
        }
        if (excList != null) {
            throw excList;
        }
    }

    @Override
    public Module getModule(String name) {
        return this.registry.getModule(name);
    }

    @Override
    public Configurable getConfigurable(String name) {
        return this.registry.getConfigurable(name);
    }

    @Override
    public void aliasModule(String alias, Configurable module) {
        this.registry.aliasModule(alias, module);
    }

    @Override
    public void shutdown() {
        log.info((Object)("Subsystem " + this.getName() + " shutdown starting"), new String[0]);
        this.shuttingDown = true;
        for (Module module : this.moduleSet) {
            module.shutdownNow();
        }
        super.shutdown();
    }
}

