/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ModuleRegistry;
import org.lsst.ccs.utilities.tracers.Tracer;

public class ModuleInvokerCommand
extends Command {
    private static final long serialVersionUID = 968478338587037799L;
    String method;
    Object[] params;

    public ModuleInvokerCommand(String method, Object ... params) {
        assert (Tracer.trace((String)("creating " + method + " " + Arrays.toString(params))));
        this.method = method;
        this.params = params;
    }

    public String getMethod() {
        return this.method;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Object execute(CommandExecutor s) {
        assert (Tracer.trace((String)"entering execute"));
        log.trace((Object)("executing command " + (Object)((Object)this)), new String[0]);
        if (!(s instanceof ModuleRegistry)) {
            String err = "Subsystem " + s + " is not a ModularSubsystem, cannot execute " + (Object)((Object)this);
            log.error((Object)err, new String[0]);
            throw new RuntimeException(err);
        }
        Configurable configurable = null;
        String configurableName = "main";
        if (!this.destination.contains("/")) {
            configurable = ((ModuleRegistry)s).getConfigurable(configurableName);
        } else {
            configurableName = this.destination.substring(this.destination.indexOf("/") + 1);
            configurable = ((ModuleRegistry)s).getConfigurable(configurableName);
        }
        if (configurable == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName);
        }
        try {
            log.trace((Object)("executing now " + this.method + " for Configurable " + configurable), new String[0]);
            return MethodUtils.invokeMethod((Object)configurable, (String)this.method, (Object[])this.params);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e, new String[0]);
            RuntimeException ex = new RuntimeException("bad command " + this.method + " parameters or parameter org.lsst.gruth.types.", e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getCause(), new String[0]);
            throw new RuntimeException(e.getCause());
        }
    }
}

