/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.ModuleRegistry;

public class ModuleConfigCommand
extends Command {
    private static final long serialVersionUID = -7939715381472174640L;
    Map<String, Object> configParams = new HashMap<String, Object>();

    public Object put(String aKey, Object value) {
        return this.configParams.put(aKey, value);
    }

    public void putAll(Map<String, ? extends Object> map) {
        this.configParams.putAll(map);
    }

    public Object execute(CommandExecutor s) {
        if (!(s instanceof ModuleRegistry)) {
            String err = "subsystem " + s + " is not a ModularSubsystem, cannot execute " + (Object)((Object)this);
            log.error((Object)err, new String[0]);
            throw new RuntimeException(err);
        }
        String destModuleName = this.destination.contains("/") ? this.destination.substring(this.destination.indexOf(47) + 1) : null;
        for (Map.Entry<String, Object> e : this.configParams.entrySet()) {
            String p;
            String m;
            if (e.getKey().contains("/")) {
                int i = e.getKey().indexOf(47);
                m = e.getKey().substring(0, i);
                p = e.getKey().substring(i + 1);
                if (destModuleName != null) {
                    m = String.valueOf(destModuleName) + "/" + m;
                }
            } else {
                m = destModuleName;
                p = e.getKey();
            }
            log.debug((Object)("config set " + m + " : " + p + " <- " + e.getValue()), new String[0]);
            Module module = ((ModuleRegistry)s).getModule(m);
            try {
                BeanUtils.setProperty((Object)module, (String)p, (Object)e.getValue());
            }
            catch (IllegalAccessException e1) {
                log.error((Object)e1, new String[0]);
            }
            catch (InvocationTargetException e1) {
                log.error((Object)e1, new String[0]);
            }
        }
        return null;
    }
}

