/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bootstrap.resources.ResourceDirectory;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesTreeProperties;

public class ResourcesUtils {
    public static List<String> getResourcesInResourcesTreeByExtension(ResourcesTree tree, String extension) {
        ArrayList<String> resources = new ArrayList<String>();
        for (ResourceDirectory dir : tree.getResourceDirectoryList()) {
            for (String resource : dir.getResources()) {
                if (extension != null && !resource.endsWith("." + extension) || resources.contains(resource)) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    public static List<String> getAllResourcesInResourcesTree(ResourcesTree tree) {
        return ResourcesUtils.getResourcesInResourcesTreeByExtension(tree, null);
    }

    public static Properties getMergedPropertyFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedPropertyFile(tree, fileName, false);
    }

    public static Properties getMergedPropertyFile(ResourcesTree tree, String fileName, boolean useSystem) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName}, useSystem);
    }

    public static Properties getMergedProperties(ResourcesTree tree, String[] properties, boolean useSystem) {
        Properties props = null;
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        ListIterator<ResourceDirectory> reverseIterator = resourceList.listIterator(resourceList.size());
        while (reverseIterator.hasPrevious()) {
            ResourceDirectory dir = reverseIterator.previous();
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyFile = stringArray[n2];
                if (propertyFile != null) {
                    if (!propertyFile.endsWith(".properties")) {
                        propertyFile = String.valueOf(propertyFile) + ".properties";
                    }
                    if (dir.hasResource(propertyFile)) {
                        try {
                            FileInputStream in = new FileInputStream(new File(dir.getResouceDirectoryPath(), propertyFile));
                            Properties parent = props != null ? props : (useSystem ? System.getProperties() : null);
                            props = new ResourcesTreeProperties(propertyFile, dir.getResouceDirectoryPath(), parent);
                            props.load(in);
                            in.close();
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                }
                ++n2;
            }
        }
        return props;
    }

    public static void printProperties(Properties props) {
        ResourcesTreeProperties p;
        System.out.println("*****************");
        if (props instanceof ResourcesTreeProperties) {
            p = (ResourcesTreeProperties)props;
            String output = "Properties from " + p.getPropertyFileName();
            if (p.getResourceDirectory() != null) {
                output = String.valueOf(output) + " in resource directory " + p.getResourceDirectory();
            }
            System.out.println(output);
        } else {
            System.out.println("External System properties");
        }
        for (Object key : props.keySet()) {
            System.out.println("\t" + key + " = " + props.getProperty((String)key));
        }
        if (props instanceof ResourcesTreeProperties && (p = (ResourcesTreeProperties)props).hasParent()) {
            ResourcesUtils.printProperties(p.getParent());
        }
    }

    public static Set<Object> getAllKeysInProperties(Properties props) {
        HashSet<Object> keySet = new HashSet<Object>();
        if (props != null) {
            ResourcesUtils.loadKeySetForProperties(props, keySet);
        }
        return keySet;
    }

    private static void loadKeySetForProperties(Properties props, Set<Object> set) {
        Set<Object> propsKey = props.keySet();
        for (Object obj : propsKey) {
            if (set.contains(obj)) continue;
            set.add(obj);
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)props).getParent() != null) {
            ResourcesUtils.loadKeySetForProperties(((ResourcesTreeProperties)props).getParent(), set);
        }
    }

    public static Properties getFlatPropertiesObject(Properties props) {
        Properties newProps = new Properties();
        Set<Object> keys = ResourcesUtils.getAllKeysInProperties(props);
        for (Object key : keys) {
            newProps.put(key, props.getProperty((String)key));
        }
        return newProps;
    }
}

