/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesTreeProperties;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public abstract class BootstrapUtils {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String DISTRIBUTION_JARS_DIRECTORY = "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_RESOURCES_DIRECTORY = "etc" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_LIB_DIRECTORY = "lib" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_JNI_DIRECTORY = String.valueOf(DISTRIBUTION_LIB_DIRECTORY) + "jni" + FILE_SEPARATOR;
    static final String APPLICATION_MAINJAR_PROPERTY = "org.lsst.ccs.application.mainJar";
    private static final String TRANSPORT_DEFINITION_PROPERTY = "lsst.ccs.transport";
    private static List<String> orderedListOfResourceDirectories = null;
    private static List<String> listOfApplications = null;
    private static List<String> listOfTransports = null;
    public static final String CCS_RESOURCE_PATH_ENV_VAR = "CCS_RESOURCE_PATH";
    private static String ccsDistributionRootDirectory = null;
    private static ResourcesTree resourcesTree = null;

    public static ResourcesTree getBootstrapResourcesTree() {
        if (resourcesTree == null) {
            resourcesTree = new ResourcesTree();
            List<String> resourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories();
            for (String resourceDirectory : resourceDirectories) {
                resourcesTree.addResourceDirectory(resourceDirectory);
            }
        }
        return resourcesTree;
    }

    public static List<String> getOrderedListOfResourceDirectories() {
        if (orderedListOfResourceDirectories == null) {
            String userProvidedResourceDirs = System.getenv(CCS_RESOURCE_PATH_ENV_VAR);
            orderedListOfResourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories(userProvidedResourceDirs, true);
        }
        return orderedListOfResourceDirectories;
    }

    static List<String> getOrderedListOfResourceDirectories(String userProvidedResourceDirs, boolean checkExistance) {
        String resourceDirectories = BootstrapUtils.getDistributionResourcesDirectory();
        if (userProvidedResourceDirs != null && !userProvidedResourceDirs.equals("")) {
            resourceDirectories = String.valueOf(userProvidedResourceDirs) + PATH_SEPARATOR + resourceDirectories;
        }
        orderedListOfResourceDirectories = new ArrayList<String>();
        StringTokenizer dirsToken = new StringTokenizer(resourceDirectories, ":;");
        while (dirsToken.hasMoreTokens()) {
            String resourceDir = dirsToken.nextToken().trim();
            if (!resourceDir.endsWith(FILE_SEPARATOR)) {
                resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
            }
            Path p = Paths.get(BootstrapUtils.getCCSDistributionRootDirectory(), new String[0]);
            resourceDir = resourceDir.replace("~", System.getProperty("user.home"));
            if (!(resourceDir = p.resolve(resourceDir).normalize().toString()).endsWith(FILE_SEPARATOR)) {
                resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
            }
            File dir = new File(resourceDir);
            if (checkExistance && !dir.exists()) continue;
            orderedListOfResourceDirectories.add(resourceDir);
        }
        return orderedListOfResourceDirectories;
    }

    public static String getDistributionResourcesDirectory() {
        return BootstrapUtils.getDistributionResourcesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionResourcesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_RESOURCES_DIRECTORY;
    }

    public static String getDistributionLibDirectory() {
        return BootstrapUtils.getDistributionLibDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionLibDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_LIB_DIRECTORY;
    }

    public static String getDistributionJniDirectory() {
        return BootstrapUtils.getDistributionJniDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJniDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JNI_DIRECTORY;
    }

    public static String getDistributionJarFilesDirectory() {
        return BootstrapUtils.getDistributionJarFilesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJarFilesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JARS_DIRECTORY;
    }

    public static String getCCSDistributionRootDirectory() {
        if (ccsDistributionRootDirectory == null) {
            ccsDistributionRootDirectory = BootstrapUtils.getCCSDistributionRootDirectory(BootstrapUtils.class);
        }
        return ccsDistributionRootDirectory;
    }

    static String getCCSDistributionRootDirectory(Class clazz) {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        String sourceCodeLocation = location.getFile();
        if (sourceCodeLocation.endsWith(".jar")) {
            ccsDistributionRootDirectory = sourceCodeLocation.substring(0, sourceCodeLocation.lastIndexOf(FILE_SEPARATOR) + 1);
        } else if (sourceCodeLocation.endsWith(FILE_SEPARATOR)) {
            ccsDistributionRootDirectory = sourceCodeLocation;
        } else {
            throw new RuntimeException("Could not process souce code location " + sourceCodeLocation + " It is neither a directory nor a jar file.");
        }
        if (ccsDistributionRootDirectory.endsWith(DISTRIBUTION_JARS_DIRECTORY)) {
            ccsDistributionRootDirectory = ccsDistributionRootDirectory.replace(DISTRIBUTION_JARS_DIRECTORY, "");
        }
        return ccsDistributionRootDirectory;
    }

    public static List<String> getBootstrapListOfApplications() {
        if (listOfApplications == null) {
            listOfApplications = new ArrayList<String>();
            List<String> allPropertiesInResources = ResourcesUtils.getResourcesInResourcesTreeByExtension(BootstrapUtils.getBootstrapResourcesTree(), "properties");
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String mainJar = props.getProperty(APPLICATION_MAINJAR_PROPERTY);
                if (mainJar == null || mainJar.isEmpty()) continue;
                listOfApplications.add(propertyFile.replace(".properties", ""));
            }
        }
        return listOfApplications;
    }

    public static List<String> getBootstrapListOfTransports() {
        if (listOfTransports == null) {
            listOfTransports = new ArrayList<String>();
            List<String> allPropertiesInResources = ResourcesUtils.getResourcesInResourcesTreeByExtension(BootstrapUtils.getBootstrapResourcesTree(), "properties");
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String transportProperty = props.getProperty(TRANSPORT_DEFINITION_PROPERTY);
                if (transportProperty == null) continue;
                listOfTransports.add(propertyFile.replace(".properties", ""));
            }
        }
        return listOfTransports;
    }

    public static Properties getPropertiesForTransport(String transport) {
        return BootstrapUtils.getMergedProperties(transport);
    }

    public static Properties getApplicationDefinitionProperties(String application) {
        return BootstrapUtils.getMergedProperties(application);
    }

    public static Properties getMergedProperties(String propertyFile) {
        String shortName = propertyFile.replace(".properties", "");
        ResourcesTreeProperties props = null;
        String applicationLevel = Bootstrap.getBootstrapApplication();
        String topicLevel = shortName;
        if (BootstrapUtils.getBootstrapListOfApplications().contains(shortName)) {
            applicationLevel = shortName;
            topicLevel = null;
        }
        props = (ResourcesTreeProperties)ResourcesUtils.getMergedProperties(BootstrapUtils.getBootstrapResourcesTree(), new String[]{topicLevel, "ccsGlobal", applicationLevel}, false);
        if (!Bootstrap.getCmdLineProperties().isEmpty()) {
            ResourcesTreeProperties cmdLinePros = new ResourcesTreeProperties("Command Line Properties", null, props);
            cmdLinePros.putAll((Map<?, ?>)Bootstrap.getCmdLineProperties());
            props = cmdLinePros;
        }
        return props;
    }

    public static String getBootstrapLibraryPath() {
        String existingLibraryPath = System.getenv("LD_LIBRARY_PATH");
        String libraryPath = "";
        if (existingLibraryPath != null && !existingLibraryPath.isEmpty()) {
            libraryPath = String.valueOf(existingLibraryPath) + File.pathSeparator;
        }
        libraryPath = String.valueOf(libraryPath) + BootstrapUtils.getDistributionJniDirectory() + File.pathSeparator + BootstrapUtils.getDistributionLibDirectory();
        return libraryPath;
    }
}

