/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DictionaryParameter
implements Serializable {
    private String name;
    private String description;
    private String type;
    private String[] values;

    DictionaryParameter(String name, Class type, String description) {
        this.name = name;
        this.type = type.getSimpleName();
        if (type.isEnum()) {
            Enum[] enums = (Enum[])type.getEnumConstants();
            this.values = new String[enums.length];
            int i = 0;
            while (i < enums.length) {
                this.values[i] = enums[i].name();
                ++i;
            }
        }
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getValues() {
        return this.values == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this.values));
    }

    String getDefaultValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

