/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryBuilder;
import org.lsst.ccs.command.InputConversionEngine;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;

public class CommandSetBuilder {
    private DictionaryBuilder dictBuilder = new DictionaryBuilder();
    private InputConversionEngine engine = new InputConversionEngine();

    public CommandSet buildCommandSet(Object object) {
        Class<?> targetClass = object.getClass();
        Dictionary dict = this.dictBuilder.build(targetClass);
        CommandSetImplementation result = new CommandSetImplementation(dict, object);
        Method[] methodArray = targetClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Command annotation = method.getAnnotation(Command.class);
            if (annotation != null) {
                result.add(method);
            }
            ++n2;
        }
        return result;
    }

    private class CommandSetImplementation
    implements CommandSet {
        private final Dictionary dict;
        private final Object target;
        private final List<Method> methods = new ArrayList<Method>();

        private CommandSetImplementation(Dictionary dict, Object target) {
            this.dict = dict;
            this.target = target;
        }

        @Override
        public Dictionary getCommandDictionary() {
            return this.dict;
        }

        @Override
        public Object invoke(TokenizedCommand tc) throws CommandInvocationException {
            int index = this.dict.findCommand(tc);
            if (index >= 0) {
                return this.invoke(this.target, this.methods.get(index), tc);
            }
            throw new CommandInvocationException("No handler found for command %s with %d arguments", tc.getCommand(), tc.getArgumentCount());
        }

        private void add(Method method) {
            this.methods.add(method);
        }

        private Object invoke(Object target, Method method, TokenizedCommand tc) throws CommandInvocationException {
            try {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] args = new Object[parameterTypes.length];
                boolean varArgs = method.isVarArgs();
                int i = 0;
                while (i < parameterTypes.length) {
                    if (varArgs && i == parameterTypes.length - 1) {
                        Class<?> varClass = parameterTypes[i];
                        Class<?> elemClass = varClass.getComponentType();
                        Object theArray = Array.newInstance(elemClass, tc.getArgumentCount() - args.length + 1);
                        int j = 0;
                        while (j < Array.getLength(theArray)) {
                            Array.set(theArray, j, CommandSetBuilder.this.engine.convertArgToType(tc.getArgument(i + j), elemClass));
                            ++j;
                        }
                        args[i] = theArray;
                    } else {
                        args[i] = CommandSetBuilder.this.engine.convertArgToType(tc.getArgument(i), parameterTypes[i]);
                    }
                    ++i;
                }
                return method.invoke(target, args);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new CommandInvocationException("Error invoking command", ex);
            }
            catch (InvocationTargetException ex) {
                throw new CommandInvocationException(ex);
            }
        }
    }
}

