/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusdbUtils {
    public static AnnotationConfiguration ac;
    public static Configuration cfg;
    public static SessionFactory fac;

    public static SessionFactory getSessionFactory(Properties inputProperties) {
        if (ac == null) {
            ac = new AnnotationConfiguration();
        }
        if (cfg == null) {
            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            cfg = ac.configure(hibernateConfigFile);
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");
            Properties cfgProps = BootstrapUtils.getMergedProperties((String)propertiesFile);
            cfgProps = ResourcesUtils.getFlatPropertiesObject((Properties)cfgProps);
            if (inputProperties != null) {
                cfg = cfg.addProperties(inputProperties);
            }
            cfg = cfg.addProperties(cfgProps);
            Logger log = Logger.getLogger((String)"lsst.ccs.db");
            Properties finalP = cfg.getProperties();
            log.info((Object)"*** Working with connection properties ", new String[0]);
            for (Object key : finalP.keySet()) {
                String skey = (String)key;
                if (!skey.contains("connection")) continue;
                log.info((Object)(String.valueOf(skey) + ": " + finalP.getProperty(skey)), new String[0]);
            }
            log.info((Object)"*********************************", new String[0]);
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
        return fac;
    }
}

