/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.ArrayList;
import java.util.Iterator;
import org.lsst.ccs.framework.BasicModularSubSystem;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.startup.NodeLookup;
import org.lsst.gruth.jutils.ComponentNode;

public class NodeModularSubsystem
extends BasicModularSubSystem {
    private ComponentLookupService lookup;

    public NodeModularSubsystem(String name, ConfigurationProxy proxy) {
        super(name);
        this.configurationProxy = proxy;
    }

    public void registerNodes(ComponentNode node) {
        this.lookup = new NodeLookup(node);
        Iterator iter = node.getAllKeys();
        if (iter != null) {
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = node.getIndirect((Object)key);
                if (value instanceof Module) {
                    this.registerConfigurable(key, (Configurable)value);
                    continue;
                }
                if (!(value instanceof Configurable)) continue;
                this.registerConfigurable(key, (Configurable)value);
            }
        }
        this.realRegisterNodes(node);
    }

    private void realRegisterNodes(ComponentNode node) {
        ArrayList children = node.getChildren();
        if (children != null) {
            for (ComponentNode child : children) {
                this.realRegisterNodes(child);
            }
        }
        String key = node.getKey();
        Object value = node.getRealValue();
        if (value instanceof Configurable) {
            Configurable configurable = (Configurable)value;
            configurable.setEnvironment(new Configurable.Environment(key, configurable, this.configurationProxy, this.lookup));
            if (value instanceof Module) {
                this.rawInitModule((Module)value);
            }
        }
    }
}

