/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.ggre;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.lsst.gruth.ggre.ReportsPanelNotification;
import org.lsst.gruth.grutils.Advice;
import org.lsst.gruth.grutils.AnnotatedReport;
import org.lsst.gruth.grutils.Modification;
import org.lsst.gruth.grutils.RawDiagnostic;
import org.lsst.gruth.reports.StoreAgent;

public class ReportsPanel
extends JPanel {
    private static final int MARK_COLUMN_INDEX = 0;
    private static final int KEY_COLUMN_INDEX = 1;
    private static final int RAWRESULT_COLUMN_INDEX = 2;
    private static final int ADVICE_COLUMN_INDEX = 3;
    private static final int COLUMN_COUNT = 4;
    private StoreAgent store;
    private JTable table;
    private JScrollPane scroll;
    private ReportsTableTableModel tm;
    private List<AnnotatedReport> originalCopyReports;
    private static Color defaultTableSelectionBackground;
    private static Color defaultTableBackground;
    private JComboBox cbo;
    private int possibleWidth;
    private Observable observable = new ReportsPanelObservable();

    Observable getObservable() {
        return this.observable;
    }

    public int getPossibleWidth() {
        return this.possibleWidth;
    }

    private ReportsPanelObservable getPrivateObservable() {
        return (ReportsPanelObservable)this.observable;
    }

    public StoreAgent getStore() {
        return this.store;
    }

    public void setStore(StoreAgent store) {
        this.store = store;
        this.tm.setStore(store);
        int size = store.size();
        this.originalCopyReports = new ArrayList<AnnotatedReport>(size);
        int ix = 0;
        while (ix < size) {
            this.originalCopyReports.add(null);
            ++ix;
        }
    }

    public ReportsPanel(StoreAgent store) {
        this();
        this.setStore(store);
    }

    public ReportsPanel() {
        this.initPLAFwise();
        this.setLayout(new BorderLayout());
        this.tm = new ReportsTableTableModel();
        DefaultListSelectionModel lsm = new DefaultListSelectionModel();
        lsm.setSelectionMode(0);
        this.cbo = new JComboBox();
        Advice[] adviceArray = Advice.values();
        int n = adviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Advice advice = adviceArray[n2];
            this.cbo.addItem(advice);
            ++n2;
        }
        this.table = new ReportsTable(this.tm, null, lsm);
        this.table.getSelectionModel().addListSelectionListener(new ReportsTableSelectionListener());
        DefaultCellEditor editor = new DefaultCellEditor(this.cbo);
        this.table.getColumnModel().getColumn(3).setCellEditor(editor);
        ReportsTableAdviceRenderer renderer = new ReportsTableAdviceRenderer();
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            columns.nextElement().setCellRenderer(renderer);
        }
        int maxSize = 0;
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        TableColumn col = this.table.getColumnModel().getColumn(0);
        int width = 4;
        width = this.sizeOf(fontMetrics, width);
        maxSize += width;
        col.setPreferredWidth(width);
        col.setMaxWidth(width);
        col.setMinWidth(width);
        col.setWidth(width);
        maxSize += width;
        col = this.table.getColumnModel().getColumn(1);
        width = 50;
        width = this.sizeOf(fontMetrics, width);
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        col.setWidth(width);
        maxSize += width;
        col = this.table.getColumnModel().getColumn(2);
        width = 20;
        width = this.sizeOf(fontMetrics, width);
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        col.setWidth(width);
        maxSize += width;
        col = this.table.getColumnModel().getColumn(3);
        width = 40;
        width = this.sizeOf(fontMetrics, width);
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        col.setWidth(width);
        this.possibleWidth = (maxSize += width) + 4;
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.table);
        this.scroll = new JScrollPane(this.table);
        this.add(this.scroll);
    }

    private String strOfLength(int length) {
        StringBuilder stb = new StringBuilder();
        int ix = 0;
        while (ix < length) {
            stb.append('-');
            ++ix;
        }
        return stb.toString();
    }

    private int sizeOf(FontMetrics metric, int length) {
        String st = this.strOfLength(length);
        return metric.stringWidth(st);
    }

    private void initPLAFwise() {
        defaultTableSelectionBackground = UIManager.getDefaults().getColor("Table.selectionBackground");
        if (defaultTableSelectionBackground == null) {
            defaultTableSelectionBackground = Color.BLUE;
        }
        if ((defaultTableBackground = UIManager.getDefaults().getColor("Table.background")) == null) {
            defaultTableBackground = Color.WHITE;
        }
    }

    public void showReport() {
        this.tm.fireTableDataChanged();
    }

    class ReportsPanelObservable
    extends Observable {
        ReportsPanelObservable() {
        }

        public ReportsPanelNotification buildNotification(int index, Boolean differenceNotification) {
            AnnotatedReport editedReport = ReportsPanel.this.store.get(index);
            AnnotatedReport originalReport = null;
            try {
                originalReport = (AnnotatedReport)ReportsPanel.this.originalCopyReports.get(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            if (originalReport == null) {
                originalReport = editedReport.clone();
                ReportsPanel.this.originalCopyReports.set(index, originalReport);
                if (editedReport.getModification() == null) {
                    RawDiagnostic diag = editedReport.getReport().getRawDiagnostic();
                    if (diag.compareTo(RawDiagnostic.OK_MARK) < 0) {
                        editedReport.setModification(Modification.ACKNOWLEDGED_NEGATIVE);
                    } else {
                        editedReport.setModification(Modification.ACKNOWLEDGED_POSITIVE);
                    }
                    editedReport.setModificationOrigin(AnnotatedReport.Origin.USER);
                }
            }
            return new ReportsPanelNotification(originalReport, editedReport, index, differenceNotification);
        }

        public ReportsPanelNotification buildNotification(int index) {
            return this.buildNotification(index, null);
        }

        public void sendNotification(int index) {
            this.setChanged();
            if (index == -1) {
                this.notifyObservers(null);
            } else {
                ReportsPanelNotification message = this.buildNotification(index);
                this.notifyObservers(message);
            }
        }
    }

    private class ReportsTable
    extends JTable {
        public ReportsTable(TableModel tm, TableColumnModel tcm, ListSelectionModel lsm) {
            super(tm, tcm, lsm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void editingStopped(ChangeEvent e) {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null && editor.getCellEditorValue() instanceof Advice) {
                Advice tableAdvice;
                Advice editorAdvice = (Advice)((Object)editor.getCellEditorValue());
                if (!editorAdvice.equals((Object)(tableAdvice = (Advice)((Object)ReportsPanel.this.table.getValueAt(this.editingRow, 3))))) {
                    ReportsPanel reportsPanel = ReportsPanel.this;
                    synchronized (reportsPanel) {
                        AnnotatedReport aReport = ReportsPanel.this.store.get(this.editingRow);
                        aReport.userModification(editorAdvice);
                        ReportsPanelObservable obs = ReportsPanel.this.getPrivateObservable();
                        obs.sendNotification(this.editingRow);
                    }
                } else {
                    System.out.println(" => false positive");
                }
            }
            super.editingStopped(e);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)this.getParent();
                return viewport.getWidth() > this.getPreferredSize().width;
            }
            return true;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }
    }

    private class ReportsTableAdviceRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setBackground(isSelected ? defaultTableSelectionBackground : defaultTableBackground);
            AnnotatedReport annotatedReport = (AnnotatedReport)ReportsPanel.this.originalCopyReports.get(row);
            if (annotatedReport != null && !annotatedReport.equals(ReportsPanel.this.store.get(row))) {
                c.setBackground(isSelected ? Color.ORANGE : Color.YELLOW);
            }
            return c;
        }
    }

    private class ReportsTableSelectionListener
    implements ListSelectionListener {
        private int previousIndex = -1;

        private ReportsTableSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            int newIndex = ((ListSelectionModel)e.getSource()).getMaxSelectionIndex();
            if (newIndex != this.previousIndex) {
                ReportsPanel reportsPanel = ReportsPanel.this;
                synchronized (reportsPanel) {
                    this.previousIndex = newIndex;
                    ReportsPanel.this.getPrivateObservable().sendNotification(newIndex);
                }
            }
        }
    }

    private class ReportsTableTableModel
    extends AbstractTableModel {
        StoreAgent store;

        public ReportsTableTableModel(StoreAgent store) {
            this.store = store;
        }

        public ReportsTableTableModel() {
        }

        public StoreAgent getStore() {
            return this.store;
        }

        public void setStore(StoreAgent store) {
            this.store = store;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex >= 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.store == null) {
                return null;
            }
            AnnotatedReport aReport = this.store.get(row);
            if (aReport == null) {
                return null;
            }
            switch (column) {
                case 0: {
                    Modification modif = aReport.getModification();
                    if (modif == null) {
                        return "";
                    }
                    return modif.getSimplifiedNotation();
                }
                case 1: {
                    return aReport.getReport().getUniqueKey();
                }
                case 2: {
                    return aReport.getReport().getRawDiagnostic();
                }
                case 3: {
                    return aReport.getAdvice();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return RawDiagnostic.class;
                }
                case 3: {
                    return Advice.class;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            if (this.store == null) {
                return 0;
            }
            return this.store.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Key\u21e8object";
                }
                case 2: {
                    return "RawDiagnostic";
                }
                case 3: {
                    return "Advice";
                }
            }
            return null;
        }
    }
}

