/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.ModularSubsystem;
import org.lsst.ccs.framework.ModuleRegistry;
import org.lsst.ccs.framework.annotations.BusCommand;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystem.command.SubsystemCommandDefinition;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.springframework.beans.factory.annotation.Required;

public class Module
extends Observable
implements Observer,
Serializable,
Configurable {
    public static ModuleRegistry registry;
    Context context;
    protected Configurable.Environment environment;
    private static final long serialVersionUID = 2086404413177085779L;
    protected static Logger log;
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int nObserverThreads = 1;
    protected int tickMillis = -1;
    TimerTask timerTask;
    ExecutorService exec;
    Timer timer;

    static {
        log = Logger.getLogger((String)"lsst.ccs.framework");
    }

    public Module() {
    }

    public Module(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public Module(String name, int tickMillis) {
        this.name = name;
        this.tickMillis = tickMillis;
    }

    public Module(String name) {
        this(name, -1);
    }

    public String getName() {
        if (this.name == null && this.environment != null) {
            this.name = this.environment.getNameOfComponent();
        }
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public void alias(String alias) {
        if (registry == null) {
            log.warn((Object)"cannot call alias in build phase (in constructors)", new String[0]);
            System.err.println("cannot call alias in build phase (in constructors)");
        } else {
            registry.aliasModule(alias, this);
        }
        if (this.environment != null) {
            this.environment.alias(alias);
        }
    }

    @Override
    public void setEnvironment(Configurable.Environment environment) {
        this.environment = environment;
    }

    public void setObservables(List<Observable> l) {
        this.observables.addAll(l);
    }

    public void listens(Observable ... observs) {
        Observable[] observableArray = observs;
        int n = observs.length;
        int n2 = 0;
        while (n2 < n) {
            Observable observable = observableArray[n2];
            this.observables.add(observable);
            ++n2;
        }
    }

    public List<Observable> getObservables() {
        return this.observables;
    }

    @ConfigChanger(argNames={"tickInterval"})
    public void setTickMillis(int tickMillis) {
        int old = this.tickMillis;
        this.tickMillis = tickMillis;
        if (this.timerTask != null && this.timer != null && tickMillis != old) {
            this.timerTask.cancel();
            if (tickMillis > 0) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        Module.this.tick();
                    }
                };
                this.timer.scheduleAtFixedRate(this.timerTask, old, (long)tickMillis);
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    @PostConstruct
    public final void init() {
        this.initModule();
        for (Observable o : this.observables) {
            o.addObserver(this);
        }
        this.exec = Executors.newFixedThreadPool(this.nObserverThreads);
    }

    public void initModule() {
    }

    protected <T> Map<String, T> getChildren(Class<T> clazz) {
        return this.environment.getChildren(clazz);
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Subsystem getSubsystem() {
        return this.getContext().getSubsystem();
    }

    public Module getModule(String moduleName) {
        if (registry != null) {
            return registry.getModule(moduleName);
        }
        return null;
    }

    public void start() {
    }

    public void checkHardware() throws Exception {
    }

    public void startTicking() {
        this.timer = new Timer("timer_" + this.name);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Module.this.tick();
            }
        };
        if (this.tickMillis > 0) {
            this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)this.tickMillis);
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg), new String[0]);
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                Module.this.processUpdate(o, (ValueUpdate)arg);
            }
        });
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    public void setBeanName(String n) {
        this.name = n;
    }

    public void setStateModularSubsystem(State newState) {
        this.setStateModularSubsystem(newState, "");
    }

    public void setStateModularSubsystem(State newState, String extraInfo) {
        this.getSubsystem().updateState(newState, extraInfo);
    }

    @Deprecated
    public void publishData(String name, Object value, long tStamp) {
        this.getSubsystem().publishData(name, value, tStamp);
    }

    public void publishData(String name, Serializable value, long tStamp) {
        this.getSubsystem().publishData(name, value, tStamp);
    }

    @Deprecated
    public void publishData(String name, Object value) {
        this.getSubsystem().publishData(name, value);
    }

    public void publishData(String name, Serializable value) {
        this.getSubsystem().publishData(name, value);
    }

    public void publishData(List<ValueNotification> tdl) {
        this.getSubsystem().publishData(tdl);
    }

    @Deprecated
    public void publishData(ValueNotification td) {
        this.getSubsystem().publishData(td);
    }

    public void publishData(DataValueNotification td) {
        this.getSubsystem().publishData(td);
    }

    public void sendToStatus(Status status) {
        this.getSubsystem().broadcastStatus(status);
    }

    @Deprecated
    public void sendToReply(CommandReply myReply) {
        this.getSubsystem().publishReply(myReply);
    }

    public void shutdownNow() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    @BusCommand(doc="will shutdown the subsystem (asynchronous execution)")
    public void shutdownCommand() {
        Thread shutter = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                Module.this.getSubsystem().shutdown();
            }
        };
        shutter.start();
    }

    @BusCommand(doc="will create a new context for modifying parameters (engineering mode)", configFacade=true)
    public void newConfigurationContext() {
        this.environment.newConfigurationContext();
    }

    @Override
    @BusCommand(argNames={"parameterName", "value"}, doc="engineering mode change of parameter value", configFacade=true)
    public void change(String parameterName, Object value) throws Exception {
        this.environment.change(parameterName, value);
    }

    @BusCommand(argNames={"configurationName", "tag"}, doc="registers a new configuration with name and tag", configFacade=true)
    public void register(String configurationName, String tag) throws IOException {
        this.environment.register(configurationName, tag);
    }

    @BusCommand(argNames={"configurationName"}, doc="registers a new configuration", configFacade=true)
    public void register(String configurationName) throws IOException {
        this.environment.register(configurationName);
    }

    @BusCommand(doc="will drop context for modifying parameters (engineering mode)", configFacade=true)
    public void dropConfigurationContext() {
        this.environment.dropConfigurationContext();
    }

    protected ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.environment.getCheckedValueFromConfiguration(parameterName, value);
        return data;
    }

    protected void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.environment.notifyChangeWithoutPreliminaryChecks(parameterName, value);
    }

    protected void notifyChange(String parameterName, String value) throws Exception {
        this.environment.notifyChange(parameterName, value);
    }

    public List<SubsystemCommandDefinition> getAvailableCommands() {
        return ((ModularSubsystem)this.getSubsystem()).getAvailableCommands();
    }

    @BusCommand(argNames={"level"}, doc="sets Level for Log Bus Handler")
    public void setHandlerLevel(String levelName) {
        this.getSubsystem().setBusLogHandlerLevel(levelName);
    }

    @BusCommand(argNames={"loggerName", "level"}, doc="sets Level for a given package or concern")
    public void setLogLevel(String loggerName, String levelName) {
        this.getSubsystem().setLogLevel(loggerName, levelName);
    }

    @BusCommand(doc="tries to restore a Log bus that entered panic state")
    public void removeLogPanicState() {
        this.getSubsystem().removeLogPanicState();
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

