/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.utils;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.utilities.logging.IsLoggableDelegate;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.tracers.Tracer;

public class LogBusHandler
extends Handler {
    protected static IsLoggableDelegate isLoggableDelegate = new IsLoggableDelegate();
    protected MessagingFactory fac;
    protected boolean panicState = false;
    protected String subSystemName;

    public LogBusHandler(MessagingFactory fac) {
        this.fac = fac;
        this.subSystemName = fac.getSubsystemName();
    }

    public LogBusHandler() {
        MessagingFactory fact;
        this.subSystemName = Subsystem.getCurrentSubsystemName();
        this.fac = fact = MessagingFactory.getInstance().forSubsystem(this.subSystemName);
    }

    public boolean inPanicState() {
        return this.panicState;
    }

    public void setPanicState(boolean panicState) {
        this.panicState = panicState;
    }

    public String getSubSystemName() {
        return this.subSystemName;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Object object;
        Object[] objects;
        assert (Tracer.trace((String)(" busHandler publishing: [" + this.getLevel() + "] " + record)));
        if (record.getLevel().equals(Level.SEVERE) && (objects = record.getParameters()).length > 0 && (object = objects[0]) instanceof LogEvent) {
            Throwable th = record.getThrown();
            LogManagement.ERROR_MANAGER.error("suspected panic for: " + object, th instanceof Exception ? (Exception)th : null, 1);
            return;
        }
        if (!this.inPanicState() && this.isLoggable(record)) {
            try {
                this.fac.sendLogEvent(new LogEvent((Object)record));
            }
            catch (Throwable th) {
                this.setPanicState(true);
                LogManagement.ERROR_MANAGER.error("suspected panic for: " + th.toString(), th instanceof Exception ? (Exception)th : null, 1);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record) && isLoggableDelegate.isLoggable(record);
    }
}

