/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.ggre;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.lsst.gruth.ggre.ReportsPanelNotification;
import org.lsst.gruth.grutils.Advice;
import org.lsst.gruth.grutils.AnnotatedReport;
import org.lsst.gruth.grutils.TztReport;

public class ReportDetailPanel
extends JTabbedPane
implements Observer {
    private AnnotatedReport aReport;
    private ReportPanel mainPanel = new ReportPanel();
    private ReportPanel previousPanel;

    public ReportDetailPanel() {
        this.mainPanel.txtPostComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportDetailPanel.this.aReport != null) {
                    ReportDetailPanel.this.aReport.setUserComment(ReportDetailPanel.this.mainPanel.txtPostComment.getText());
                }
            }
        });
        this.previousPanel = new ReportPanel();
        this.previousPanel.txtPostComment.setEnabled(false);
        this.addTab("current Report", this.mainPanel);
        this.addTab("                        ", this.previousPanel);
    }

    @Override
    public void update(Observable o, Object notification) {
        if (notification == null) {
            this.mainPanel.populateFields(null);
            this.previousPanel.populateFields(null);
            this.mainPanel.txtAdvice.setToolTipText(null);
        } else if (notification instanceof ReportsPanelNotification) {
            ReportsPanelNotification notif = (ReportsPanelNotification)notification;
            this.aReport = notif.getEditedReport();
            this.setSelectedComponent(this.mainPanel);
            this.mainPanel.populateFields(this.aReport);
            this.mainPanel.txtAdvice.setToolTipText(notif.isDifferenceNotification() ? "Original advice was " + (Object)((Object)notif.getOriginalReport().getAdvice()) : null);
            if (this.aReport.getNeededPreviousReport() != null) {
                this.previousPanel.setEnabled(true);
                this.previousPanel.populateFields(this.aReport.getNeededPreviousReport());
                this.setTitleAt(1, "previous report version :" + this.aReport.getNeededPreviousVersion());
            } else {
                this.previousPanel.setEnabled(false);
                this.previousPanel.populateFields(null);
                this.setTitleAt(1, "                   ");
            }
        } else {
            this.previousPanel.setEnabled(false);
            this.mainPanel.populateFields(null);
            this.previousPanel.populateFields(null);
            this.mainPanel.txtAdvice.setToolTipText(null);
            throw new RuntimeException("ReportDetailPanel Observer received a " + notification.getClass() + " ; a ReportsPanelNotification (or null) was expected.");
        }
    }

    private class ReportPanel
    extends JPanel {
        private int fieldCount = 0;
        private JTextField txtKey;
        private JTextField txtAdvice;
        private JTextField txtPostComment;
        private JTextField txtRawResult;
        private JTextField txtName;
        private JTextField txtClass;
        private JTextField txtMethod;
        private JTextField txtData;
        private JTextField txtAdditionalData;
        private JTextField txtMessages;
        private JTextField txtAssertions;
        private JTextField txtCaughts;

        public ReportPanel() {
            this.init();
        }

        public void init() {
            GridBagLayout gbl = new GridBagLayout();
            gbl.columnWidths = new int[1];
            gbl.rowHeights = new int[1];
            gbl.columnWeights = new double[]{Double.MIN_VALUE};
            gbl.rowWeights = new double[]{Double.MIN_VALUE};
            this.setLayout(gbl);
            this.txtKey = new JTextField();
            this.manageLabelsAndFields(new JLabel("Key\u21e8object:"), this.txtKey, false);
            this.txtAdvice = new JTextField();
            this.manageLabelsAndFields(new JLabel("Advice:"), this.txtAdvice, false);
            this.txtPostComment = new JTextField();
            this.manageLabelsAndFields(new JLabel("Review comment:"), this.txtPostComment, true);
            this.manageLabelsAndFields(new JLabel("    "), null, false);
            this.txtRawResult = new JTextField();
            this.manageLabelsAndFields(new JLabel("RawResults:"), this.txtRawResult, false);
            this.txtName = new JTextField();
            this.manageLabelsAndFields(new JLabel("Name:"), this.txtName, false);
            this.txtClass = new JTextField();
            this.manageLabelsAndFields(new JLabel("Class:"), this.txtClass, false);
            this.txtMethod = new JTextField();
            this.manageLabelsAndFields(new JLabel("Method:"), this.txtMethod, false);
            this.txtData = new JTextField();
            this.manageLabelsAndFields(new JLabel("Data:"), this.txtData, false);
            this.txtAdditionalData = new JTextField();
            this.manageLabelsAndFields(new JLabel("Add. data:"), this.txtAdditionalData, false);
            this.txtMessages = new JTextField();
            this.manageLabelsAndFields(new JLabel("Messages:"), this.txtMessages, false);
            this.txtAssertions = new JTextField();
            this.manageLabelsAndFields(new JLabel("Assertions:"), this.txtAssertions, false);
            this.txtCaughts = new JTextField();
            this.manageLabelsAndFields(new JLabel("Caughts:"), this.txtCaughts, false);
        }

        private void manageLabelsAndFields(JComponent lbl, JTextField txt, boolean editable) {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 12;
            c.insets = new Insets(0, 0, 5, 5);
            c.gridx = 0;
            c.gridy = this.fieldCount;
            c.insets = new Insets(0, 0, 5, 5);
            this.add((Component)lbl, c);
            if (txt != null) {
                txt.setEditable(editable);
                txt.setColumns(30);
                txt.setAlignmentY(1.0f);
                txt.setAlignmentX(0.0f);
                txt.setHorizontalAlignment(10);
                if (!editable) {
                    txt.setBackground(Color.LIGHT_GRAY);
                }
                c.gridx = 1;
                c.anchor = 18;
                this.add((Component)txt, c);
            }
            ++this.fieldCount;
        }

        private void populateFields(AnnotatedReport aReport, String defaultContents) {
            if (defaultContents == null) {
                defaultContents = "";
            }
            if (aReport != null) {
                TztReport report = aReport.getReport();
                report.getSupportingObjectString();
                this.txtKey.setText(report.getUniqueKey());
                this.txtRawResult.setText(report.getRawDiagnostic().toString());
                Advice advice = aReport.getAdvice();
                this.txtAdvice.setText(advice != null ? advice.toString() : "");
                this.txtName.setText(report.getTestName());
                this.txtClass.setText(report.getClassName());
                this.txtMethod.setText(report.getMethodName());
                this.txtPostComment.setText(aReport.getUserComment() != null ? aReport.getUserComment() : "");
                this.txtData.setText(report.getData() != null ? report.getData().toString() : "");
                this.txtAdditionalData.setText(report.getAdditionalData() != null ? report.getAdditionalData().toString() : "");
                this.txtMessages.setText(String.valueOf(report.getMessages()));
                this.txtAssertions.setText(String.valueOf(report.getListAssertions()));
                this.txtCaughts.setText(String.valueOf(report.getCaught()));
            } else {
                this.txtKey.setText(defaultContents);
                this.txtRawResult.setText(defaultContents);
                this.txtName.setText(defaultContents);
                this.txtClass.setText(defaultContents);
                this.txtMethod.setText(defaultContents);
                this.txtPostComment.setText(defaultContents);
                this.txtData.setText(defaultContents);
                this.txtAdditionalData.setText(defaultContents);
                this.txtMessages.setText(defaultContents);
                this.txtAssertions.setText(defaultContents);
                this.txtCaughts.setText(defaultContents);
            }
        }

        private void populateFields(AnnotatedReport aReport) {
            this.populateFields(aReport, null);
        }
    }
}

