/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Constraint;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.FrameworkUtils;
import org.lsst.ccs.framework.MethodConstraint;
import org.lsst.ccs.framework.ModularSubsystem;
import org.lsst.ccs.framework.Module;

@Aspect
public class ConstraintAspect {
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.bus.framework.contraints");
    static Set<Constraint> constraints = new HashSet<Constraint>();
    protected Context context;
    static volatile int i = 0;
    static ReentrantLock lock = new ReentrantLock();

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void init() {
        log.debug((Object)"pointcut initialization started");
        Subsystem sub = this.getContext().getSubsystem();
        String nameOfFile = null;
        if (!(sub instanceof ModularSubsystem)) {
            log.warn((Object)"no pointcut: no Xmlconfiguration file (no use of modularsubsystem");
            return;
        }
        nameOfFile = ((ModularSubsystem)sub).getXmlConfigFile();
        final String configFile = nameOfFile;
        try {
            String line;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            InputStream xsl2spring = this.getClass().getResourceAsStream("/org/lsst/ccs/framework/xsl/desc2constraint.xsl");
            final Transformer transformer = tFactory.newTransformer(new StreamSource(xsl2spring));
            final PipedOutputStream pipeOut = new PipedOutputStream();
            PipedInputStream pipeIn = new PipedInputStream(pipeOut);
            new Thread(){

                @Override
                public void run() {
                    try {
                        StreamSource ss = new StreamSource(FrameworkUtils.getConfigFileInputStream((String)configFile));
                        transformer.transform(ss, new StreamResult(pipeOut));
                        pipeOut.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            BufferedReader configDesc = new BufferedReader(new InputStreamReader(pipeIn));
            while ((line = configDesc.readLine()) != null) {
                String[] words = line.trim().split(" +");
                if (words.length < 1) continue;
                Constraint c = null;
                String[] stringArray = words;
                int n = words.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    if (c == null) {
                        c = (Constraint)Class.forName(word).newInstance();
                    } else {
                        int ii = word.indexOf("=");
                        String prop = word.substring(0, ii);
                        String val = word.substring(ii + 1);
                        if (val.startsWith("\"")) {
                            val = val.substring(1, val.length() - 1);
                        }
                        BeanUtils.setProperty((Object)c, (String)prop, (Object)val);
                    }
                    ++n2;
                }
                constraints.add(c);
                log.debug((Object)("adding constraint " + c));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e);
            throw new RuntimeException(e);
        }
        log.debug((Object)"pointcut initialized");
    }

    @Pointcut(value="execution(@org.lsst.ccs.framework.Guarded * *.*(..))")
    public void pointcutGuarded() {
    }

    @Around(value="pointcutGuarded()")
    public Object checkConstraints(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Object retVal;
            lock.lock();
            Object target = pjp.getTarget();
            String methName = pjp.getSignature().getName();
            if (!(target instanceof Module)) {
                log.debug((Object)("target " + target + " is not a module"));
                return null;
            }
            Module m = (Module)target;
            for (Constraint c : constraints) {
                MethodConstraint mc;
                if (!(c instanceof MethodConstraint) || !(mc = (MethodConstraint)c).isApplicable(target, methName) || mc.isVerified(m.getContext())) continue;
                log.debug((Object)("rejecting " + m.getName() + "." + methName));
                throw new RuntimeException("operation " + methName + " on " + target + " forbidden");
            }
            Object object = retVal = pjp.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

