/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ModuleRegistry;

public class ModuleInvokerCommand
extends Command {
    private static final long serialVersionUID = 968478338587037799L;
    String method;
    Object[] params;

    public ModuleInvokerCommand(String method, Object ... params) {
        this.method = method;
        this.params = params;
    }

    public String getMethod() {
        return this.method;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Object execute(CommandExecutor s) {
        log.trace((Object)("executing command " + (Object)((Object)this)));
        if (!(s instanceof ModuleRegistry)) {
            String err = "Subsystem " + s + " is not a ModularSubsystem, cannot execute " + (Object)((Object)this);
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        Configurable configurable = null;
        String configurableName = "main";
        if (!this.destination.contains("/")) {
            configurable = ((ModuleRegistry)s).getConfigurable(configurableName);
        } else {
            configurableName = this.destination.substring(this.destination.indexOf("/") + 1);
            configurable = ((ModuleRegistry)s).getConfigurable(configurableName);
        }
        if (configurable == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName);
        }
        try {
            log.trace((Object)("executing now " + this.method + " for Configurable " + configurable));
            return MethodUtils.invokeMethod((Object)configurable, (String)this.method, (Object[])this.params);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e);
            RuntimeException ex = new RuntimeException("bad command " + this.method + " parameters or parameter types.", e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

