/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.reports;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.lsst.gruth.grutils.AnnotatedReport;
import org.lsst.gruth.grutils.ResultReporter;
import org.lsst.gruth.jutils.NumberedStringGenerator;
import org.lsst.gruth.reports.StoreAgent;

public class FileStore
extends ResultReporter
implements StoreAgent {
    public static final String RAW_EXTENSION = ".rawres";
    private String bundleName;
    private String realName;
    private ArrayList<AnnotatedReport> list = new ArrayList();
    private int version;

    public FileStore(String bundleName) throws Exception {
        this.setBundle(bundleName);
    }

    public FileStore() {
    }

    @Override
    public int getVersionNumberFor(String bundleName) {
        File dir = new File(".");
        NumberedStringGenerator generator = new NumberedStringGenerator(String.valueOf(bundleName) + "#" + RAW_EXTENSION);
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            generator.submit(fileName);
            ++n2;
        }
        return generator.getMax();
    }

    @Override
    public void setBundle(String bundleName) throws Exception {
        this.setBundleName(bundleName);
        this.openFile(this.realName);
    }

    private void setBundleName(String bundleName) {
        this.list.clear();
        this.bundleName = bundleName;
        File dir = new File(".");
        NumberedStringGenerator generator = new NumberedStringGenerator(String.valueOf(bundleName) + "#" + RAW_EXTENSION);
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            generator.submit(fileName);
            ++n2;
        }
        this.realName = generator.getMaxString();
        this.version = generator.getMax();
    }

    @Override
    public void setBundle(String bundleName, int version) throws Exception {
        this.realName = String.valueOf(bundleName) + version + RAW_EXTENSION;
        this.version = version;
        this.openFile(this.realName);
    }

    public synchronized void openFile(String realName) throws Exception {
        FileInputStream is = new FileInputStream(realName);
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
        try {
            while (true) {
                AnnotatedReport report = (AnnotatedReport)ois.readObject();
                this.list.add(report);
            }
        }
        catch (EOFException eOFException) {
            ois.close();
            return;
        }
    }

    @Override
    public String[] listBundles() {
        return new String[0];
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public AnnotatedReport get(int index) {
        return this.list.get(index);
    }

    @Override
    public void set(int index, AnnotatedReport report) {
        this.list.set(index, report);
    }

    @Override
    public void save() throws IOException {
        String fileName = this.realName;
        FileOutputStream os = new FileOutputStream(fileName);
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(os));
        for (AnnotatedReport aReport : this.list) {
            oos.writeObject(aReport);
        }
        oos.flush();
        oos.close();
    }

    @Override
    public void copyTo(ResultReporter reporter) {
        reporter.begin();
        for (AnnotatedReport aReport : this.list) {
            reporter.report(aReport);
        }
        reporter.end();
    }

    @Override
    public Object report(AnnotatedReport report) {
        this.list.add(report);
        return "";
    }

    @Override
    public Object begin() {
        return "";
    }

    @Override
    public Object end() {
        return "";
    }

    @Override
    public Object groupReportsUnderName(String name) {
        this.setBundleName(name);
        return "";
    }

    @Override
    public void close() throws IOException {
        this.save();
    }
}

