<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>


<html>

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>PlotMain</title>
    </head>
    <body>

        <%--
    <c:choose>
        <c:when test="${empty selectedPath && empty selectedData}">
            <form name="DataSelectionForm">
                Please select a path from the navigation tree on the left or type the mnenomic :
                <b><app:formElement application="${srsApplication}" parname="selectedData" size="20"/></b>
            </form>

        </c:when>
        <c:otherwise>

            <table width="100%">
                <tr>
                    <td align="right">
                <c:choose>
                    <c:when test="${showTable}">
                        <a href="?showTable=false">Show Plots</a>
                    </c:when>
                    <c:otherwise>
                        <a href="?showTable=true">Show Table</a>
                    </c:otherwise>
                </c:choose>
                </td>
                <td align="right">
                <c:choose>
                    <c:when test="${showDataDescription}">
                        <a href="?showDataDescription=false">Hide Data Description</a>
                    </c:when>
                    <c:otherwise>
                        <a href="?showDataDescription=true">Show Data Description</a>
                    </c:otherwise>
                </c:choose>
                </td>
                </tr>
            </table>

            <c:choose>
                <c:when test="${showTable}">
                    <c:set var="tableData" value="${app:telemetryTrendingTable(srsApplication)}"/>
                    <c:if test="${tableData.columns-1 > -1 }">
                        <br>

                        <display:table class="datatable" name="${tableData.trendingAxisValuesList}" export="true" defaultorder="descending"  defaultsort="1" sort="list" id="tableId" decorator="org.srs.web.base.decorator.BaseDecorator" >


                            <display:column class="leftAligned" sortable="true" title="Time" value="${tableId.time}" decorator="org.srs.web.base.decorator.TimeDecorator"/>
                            <c:forEach var="i" begin="0" end="${tableData.columns-1}" varStatus="count">
                                <c:set var="dataName" value="${app:columnName(tableData,i)}"/>
                                <c:if test="${app:hasColumnData(tableData,i)}">
                                    <c:choose>
                                        <c:when test="${app:isColumnRawData(tableData,i)}">
                                            <display:column sortable="true" title="${dataName} Value" value="${app:cellValue(tableId,'value',i)}"/>
                                        </c:when>
                                        <c:otherwise>
                                            <display:column sortable="true" title="${dataName} Mean" value="${app:cellValue(tableId,'mean',i)}"/>
                                            <display:column sortable="true" title="${dataName} Rms" value="${app:cellValue(tableId,'rms',i)}" />
                                        </c:otherwise>
                                    </c:choose>
                                </c:if>
                            </c:forEach>
                        </display:table>
                    </c:if>
                </c:when>
                <c:otherwise>

                    <c:forEach items="${selectedData}" var="data">

                        <c:set var="dataDescription" value="${datainfo:dataDescription(dataInfoBean,data)}"/>

                        <c:choose>
                            <c:when test="${!empty dataDescription}">
                                <table>
                                    <tr>
                                        <td>
                                            Variable: <b>${data}</b><br>
                                        </td>
                                    <c:if test="${showDataDescription}">
                                        <td style="border: 1px solid #f00">
                                            ${dataDescription}
                                        </td>
                                    </c:if>
                                    </tr>
                                </table>
                            </c:when>
                            <c:otherwise>
                                Variable: <b>${data}</b><br>
                            </c:otherwise>
                        </c:choose>



                        <c:set var="dataTitle" value="${datainfo:dataTitle(dataInfoBean,data)}" />
                        <c:if test="${isSinglePlot && showPlotInfo}">
                            <c:if test="${fn:length(app:parameterValueList(srsApplication,'runId')) == 1}">
                                <c:set var="dataTitle" value="${dataTitle} - Run: ${runId}" />
                            </c:if>
                        </c:if>
                        <c:set var="dataLabel" value="${datainfo:dataLabelOnTree(dataInfoBean,data)}" />


                        <table width="100%">
                            <tr>
                                <td align="center">
                                    <aida:plotter width="600" height="400" allowDownload="true" createImageMap="false">
                                        <aida:region var="region" title="${dataTitle}" >
                                            <aida:style>
                                                <aida:style type="statisticsBox">
                                                    <aida:attribute name="isVisible" value="true"/>
                                                </aida:style>
                                                <aida:style type="data">
                                                    <aida:style type="fill">
                                                        <aida:attribute name="isVisible" value="true"/>
                                                        <aida:attribute name="color" value="blue"/>
                                                    </aida:style>
                                                    <aida:style type="marker">
                                                        <aida:attribute name="isVisible" value="true"/>
                                                        <aida:attribute name="color" value="blue"/>
                                                        <aida:attribute name="shape" value="dot"/>
                                                        <aida:attribute name="size" value="4"/>
                                                    </aida:style>
                                                    <aida:style type="line">
                                                        <aida:attribute name="isVisible" value="true"/>
                                                        <aida:attribute name="color" value="blue"/>
                                                    </aida:style>
                                                    <aida:style type="errorBar">
                                                        <aida:attribute name="color" value="black"/>
                                                    </aida:style>
                                                </aida:style>
                                                <aida:style type="yAxis">
                                                    <aida:attribute name="labelVertical" value="true"/>
                                                </aida:style>
                                                <aida:style type="yAxis">
                                                    <aida:style type="label">
                                                        <aida:attribute name="bold" value="true"/>
                                                    </aida:style>
                                                </aida:style>
                                                <aida:style type="xAxis">
                                                    <aida:style type="label">
                                                        <aida:attribute name="bold" value="true"/>
                                                    </aida:style>
                                                </aida:style>
                                                <aida:style type="title">
                                                    <aida:style type="text">
                                                        <aida:attribute name="bold" value="true"/>
                                                    </aida:style>
                                                </aida:style>
                                            </aida:style>


                                    <c:set var="state" value="${srsApplication.applicationParameterState}"/>
                                    ${app:setParameterStateValue(state,'selectedData',data)}
                                    <jsp:useBean id="hints" scope="page" class="org.srs.base.application.plotter.ApplicationPlotHints" />
                                    ${app:plotData(srsApplication,region,state,hints)}
                                </aida:region>
                            </aida:plotter>
                            </td>
                            </tr>
                        </table>

                    </c:forEach>
                </c:otherwise>
            </c:choose>

        </c:otherwise>
    </c:choose>
        --%>
</body>
</html>
