/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.EnumMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.AbstractDispatcher;
import org.lsst.ccs.messaging.util.AlertGate;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.messaging.util.KeyQueueExecutor;
import org.lsst.ccs.messaging.util.Throttle;
import org.lsst.ccs.utilities.scheduler.BasicThreadFactory;

public class MultiQueueDispatcher
extends AbstractDispatcher {
    private volatile boolean off = true;
    private final EnumMap<Bus, Object> inExecutors;
    private final EnumMap<Bus, ExecutorService> outNormExecutors;
    private final ThreadPoolExecutor outOobCcExec;
    private final ThreadPoolExecutor oobExec;
    private final AlertGate[] gatesDuration;
    private final AlertGate[] gatesQueueSize;
    private final Throttle[] throttles;
    private final AtomicInteger[] queueSize;

    public MultiQueueDispatcher(String args) {
        super(args);
        String prefixIncomingBus;
        String prefixIncoming;
        int incoming;
        int[] inThreads = this.getIntArrayArg("inThreads", new int[]{1, 1, 8});
        this.gatesDuration = new AlertGate[2 * Bus.values().length * Dispatcher.Stage.values().length];
        int index = 0;
        String prefix = "duration/";
        for (incoming = 0; incoming < 2; ++incoming) {
            prefixIncoming = prefix + (incoming == 0 ? "in" : "out") + "/";
            for (Bus bus : Bus.values()) {
                prefixIncomingBus = prefixIncoming + bus + "/";
                for (Dispatcher.Stage stage : Dispatcher.Stage.values()) {
                    String prefixIncomingBusStage = prefixIncomingBus + stage;
                    int[] duration = this.getIntArrayArg(prefixIncomingBusStage, new int[0]);
                    this.gatesDuration[index++] = new AlertGate(this, "dispatcher/" + prefixIncomingBusStage, "High message processing time.", duration);
                }
            }
        }
        this.gatesQueueSize = new AlertGate[2 * Bus.values().length];
        index = 0;
        prefix = "queue/";
        for (incoming = 0; incoming < 2; ++incoming) {
            prefixIncoming = prefix + (incoming == 0 ? "in" : "out") + "/";
            for (Bus bus : Bus.values()) {
                prefixIncomingBus = prefixIncoming + bus;
                int[] size = this.getIntArrayArg(prefixIncomingBus, new int[0]);
                this.gatesQueueSize[index++] = new AlertGate(this, "dispatcher/" + prefixIncomingBus, "Long message queue.", size);
            }
        }
        int size = this.getIntArg("throttle/size", 0);
        int rate = this.getIntArg("throttle/rate", 0);
        if (size > 0 && rate > 0) {
            this.throttles = new Throttle[Bus.values().length];
            for (Bus bus : Bus.values()) {
                this.throttles[bus.ordinal()] = new Throttle(this, "dispatcher/throttle/" + bus, size, rate);
            }
        } else {
            this.throttles = null;
        }
        this.inExecutors = new EnumMap(Bus.class);
        for (Bus bus : Bus.values()) {
            int n = inThreads[bus.ordinal()];
            if (n == 1) {
                this.inExecutors.put(bus, (Object)Executors.newSingleThreadExecutor((ThreadFactory)((Object)new TFactory("MESSAGING_IN_" + bus))));
                continue;
            }
            this.inExecutors.put(bus, (Object)new KeyQueueExecutor("MESSAGING_IN_" + bus, n));
        }
        this.outNormExecutors = new EnumMap(Bus.class);
        for (Bus bus : Bus.values()) {
            this.outNormExecutors.put(bus, Executors.newSingleThreadExecutor((ThreadFactory)((Object)new TFactory("MESSAGING_OUT_" + bus))));
        }
        this.outOobCcExec = new ThreadPoolExecutor(2, 2, 70L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)((Object)new TFactory("MESSAGING_OUT_OOB_CC")));
        this.outOobCcExec.allowCoreThreadTimeOut(true);
        this.oobExec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 70L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)((Object)new TFactory("MESSAGING_OOB")));
        int n = 2 * Bus.values().length;
        this.queueSize = new AtomicInteger[n];
        for (int i = 0; i < n; ++i) {
            this.queueSize[i] = new AtomicInteger(0);
        }
        this.config = null;
    }

    @Override
    public void initialize() {
        this.off = false;
    }

    @Override
    public void shutdown() {
        this.off = true;
        this.oobExec.shutdown();
        this.outOobCcExec.shutdown();
        this.outNormExecutors.values().forEach(exec -> exec.shutdown());
        this.inExecutors.values().forEach(exec -> {
            if (exec instanceof KeyQueueExecutor) {
                ((KeyQueueExecutor)exec).shutdown();
            } else {
                ((ExecutorService)exec).shutdown();
            }
        });
        try {
            this.oobExec.awaitTermination(1L, TimeUnit.MINUTES);
            this.outOobCcExec.awaitTermination(1L, TimeUnit.MINUTES);
            for (ExecutorService executorService : this.outNormExecutors.values()) {
                executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            for (Object object : this.inExecutors.values()) {
                if (object instanceof KeyQueueExecutor) {
                    ((KeyQueueExecutor)object).awaitTermination(1L, TimeUnit.MINUTES);
                    continue;
                }
                ((ExecutorService)object).awaitTermination(1L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        super.shutdown();
    }

    @Override
    protected void in(AbstractDispatcher.DTask run, Bus bus, String ... agents) {
        if (this.off) {
            return;
        }
        Dispatcher.Order order = agents == null ? Dispatcher.Order.OOB : (agents.length == 0 ? Dispatcher.Order.OOB_CC : Dispatcher.Order.NORM);
        TaskRunner runner = new TaskRunner(run, order);
        this.stageEnded(runner, Dispatcher.Stage.START);
        try {
            switch (order) {
                case NORM: 
                case OOB_CC: {
                    Object exec = this.inExecutors.get((Object)bus);
                    if (exec instanceof KeyQueueExecutor) {
                        ((KeyQueueExecutor)exec).execute(runner, agents);
                        break;
                    }
                    ((ExecutorService)exec).execute(runner);
                    break;
                }
                case OOB: {
                    this.oobExec.execute(runner);
                }
            }
            int queueSizeIndex = 0 + bus.ordinal();
            int size = this.queueSize[queueSizeIndex].incrementAndGet();
            this.gatesQueueSize[queueSizeIndex].check(size);
        }
        catch (RejectedExecutionException x) {
            throw new TransportStateException(x);
        }
        finally {
            this.stageEnded(runner, Dispatcher.Stage.SUBMIT);
        }
    }

    @Override
    protected void out(AbstractDispatcher.DTask run, Bus bus, Dispatcher.Order order) {
        if (this.off) {
            throw new TransportStateException();
        }
        TaskRunner runner = new TaskRunner(run, order);
        this.stageEnded(runner, Dispatcher.Stage.START);
        try {
            switch (order) {
                case NORM: {
                    this.outNormExecutors.get((Object)bus).execute(runner);
                    break;
                }
                case OOB_CC: {
                    this.outOobCcExec.execute(runner);
                    break;
                }
                case OOB: {
                    this.oobExec.execute(runner);
                }
            }
            int queueSizeIndex = 1 + bus.ordinal();
            int size = this.queueSize[queueSizeIndex].incrementAndGet();
            this.gatesQueueSize[queueSizeIndex].check(size);
        }
        catch (RejectedExecutionException x) {
            throw new TransportStateException();
        }
        finally {
            this.stageEnded(runner, Dispatcher.Stage.SUBMIT);
        }
    }

    private void stageEnded(TaskRunner runner, Dispatcher.Stage stage) {
        int duration = this.notifyTaskListeners(runner.getTask(), stage);
        int i = (runner.getTask().isOutgoing() ? 1 : 0) * (Bus.values().length * Dispatcher.Stage.values().length) + runner.getTask().getBus().ordinal() * Dispatcher.Stage.values().length + stage.ordinal();
        this.gatesDuration[i].check(duration);
    }

    private class TFactory
    extends BasicThreadFactory {
        TFactory(String name) {
            super(name, null, true);
        }

        public Thread newThread(Runnable r) {
            Thread thread = super.newThread(r);
            thread.setUncaughtExceptionHandler((t, x) -> MultiQueueDispatcher.this.getLogger().log(Level.WARNING, "Exception thrown from messaging executor: " + thread.getName(), x));
            return thread;
        }
    }

    private class TaskRunner
    implements Runnable {
        private final AbstractDispatcher.DTask task;
        private final Dispatcher.Order order;

        TaskRunner(AbstractDispatcher.DTask runnable, Dispatcher.Order order) {
            this.task = runnable;
            this.order = order;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean outgoing = this.task.isOutgoing();
            BusMessage busMessage = this.task.getBusMessage();
            Bus bus = this.task.getBus();
            int queueSizeIndex = (outgoing ? 1 : 0) + bus.ordinal();
            int size = MultiQueueDispatcher.this.queueSize[queueSizeIndex].decrementAndGet();
            MultiQueueDispatcher.this.gatesQueueSize[queueSizeIndex].check(size);
            MultiQueueDispatcher.this.stageEnded(this, Dispatcher.Stage.WAIT);
            try {
                if (outgoing && MultiQueueDispatcher.this.throttles != null) {
                    MultiQueueDispatcher.this.throttles[bus.ordinal()].process(busMessage);
                }
                this.task.run();
            }
            catch (RuntimeException x) {
                String warningMessage = "Exception " + (outgoing ? "sending" : "receiving") + " message ";
                if (busMessage != null) {
                    warningMessage = warningMessage + busMessage.getClass().getSimpleName() + " (" + busMessage.getClassName() + ") ";
                    if (!outgoing) {
                        warningMessage = warningMessage + "from " + busMessage.getOriginAgentInfo().getName() + " ";
                    }
                } else {
                    warningMessage = warningMessage + "null ";
                }
                warningMessage = warningMessage + "on " + bus + " bus, (" + this.order + ")";
                MultiQueueDispatcher.this.getLogger().log(Level.WARNING, warningMessage, x);
            }
            finally {
                MultiQueueDispatcher.this.stageEnded(this, Dispatcher.Stage.RUN);
            }
        }

        AbstractDispatcher.DTask getTask() {
            return this.task;
        }
    }
}

