/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.MessageFlag;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayerMBean;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.MessagingLayer;
import org.lsst.ccs.messaging.OutgoingMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class AgentMessagingLayer
implements AgentMessagingLayerMBean {
    private static final List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<AgentMessagingLayer>();
    private Predicate<BusMessage<? extends Serializable, ?>> filterMessagesFromThisAgent;
    private final Logger curLogger = Logger.getLogger(AgentMessagingLayer.class.getName());
    private final BusApplicationLayer layer;
    private volatile ConnectionStatus connectionStatus = ConnectionStatus.NOT_CONNECTED;
    private final Object connectionLock = new Object();
    private final AgentInfo agentInfo;
    private final LockLevelService lockLevelService;
    private final Scheduler scheduler;
    private boolean accumulateMsgStatistics = false;
    private final Object accumulationLock = new Object();
    private volatile MessageAccumulator msgAccumulator = null;
    private final Map<Bus, List<OutgoingMessageListener>> outgoingMessageListenersMap = new ConcurrentHashMap<Bus, List<OutgoingMessageListener>>();

    public static AgentMessagingLayer createInstance(AgentInfo agentInfo, LockLevelService lockLevelService) {
        AgentMessagingLayer agentMessagingLayer = new AgentMessagingLayer(agentInfo, lockLevelService);
        return agentMessagingLayer;
    }

    AgentMessagingLayer(AgentInfo agentInfo, LockLevelService lockLevelService) {
        this.layer = new BusApplicationLayer(agentInfo, this);
        this.filterMessagesFromThisAgent = BusMessageFilterFactory.messageOrigin(agentInfo.getName()).negate();
        this.agentInfo = agentInfo;
        this.lockLevelService = lockLevelService;
        this.scheduler = new Scheduler("AgentMessagingLayer scheduler", 1);
        this.scheduler.setLogger(this.curLogger);
        this.accumulateMsgStatistics = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.messaging.accumulate.msg.statistics", "false").toLowerCase().equals("true");
        if (this.accumulateMsgStatistics) {
            this.msgAccumulator = new MessageAccumulator();
        }
    }

    AgentMessagingLayer(AgentInfo agentInfo) {
        this.layer = null;
        this.agentInfo = agentInfo;
        this.scheduler = new Scheduler("AgentMessagingLayer scheduler", 1);
        this.lockLevelService = null;
    }

    @Override
    public void restart(int seconds) {
        this.shutdownBusAccess();
        Thread restart = new Thread(() -> {
            try {
                Thread.sleep(1000 * seconds);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            this.connectToBuses();
        });
    }

    public final void addBusMessagePreProcessor(BusMessagePreProcessor preProcessor) {
        this.layer.addBusMessagePreProcessor(preProcessor);
    }

    public BusApplicationLayer getApplicationLayer() {
        return this.layer;
    }

    public MessagingLayer getMessagingLayer() {
        return this.layer.getBusMessagingLayer();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownBusAccess() {
        this.layer.close();
        msgAccesses.remove(this);
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionStatus = ConnectionStatus.DISCONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToBuses() {
        if (this.accumulateMsgStatistics) {
            this.scheduler.scheduleAtFixedRate(() -> this.printAndResetAccumulation(), 1L, 1L, TimeUnit.MINUTES);
        }
        this.layer.connectToBuses();
        msgAccesses.add(this);
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionStatus = ConnectionStatus.CONNECTED;
            this.connectionLock.notify();
        }
    }

    private void printAndResetAccumulation() {
        MessageAccumulator oldMessageAccumulator = this.msgAccumulator;
        this.msgAccumulator = new MessageAccumulator();
        this.curLogger.log(Level.FINE, oldMessageAccumulator.toString());
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.layer.getAgentPresenceManager();
    }

    public boolean needsHeartbeat() {
        return !this.layer.hasInternalHeartbeat();
    }

    public LockLevelService getAgentLockService() {
        return this.lockLevelService;
    }

    public void addLogMessageListener(LogMessageListener listener) {
        this.addLogMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addLogMessageListener(LogMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addLogListener(listener, filter);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.addStatusMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addStatusMessageListener(StatusMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addStatusListener(listener, filter);
    }

    public void addCommandMessageListener(CommandMessageListener listener) {
        this.addCommandMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addCommandMessageListener(CommandMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addCommandListener(listener, filter);
    }

    public void removeLogMessageListener(LogMessageListener listener) {
        this.layer.removeLogListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.layer.removeStatusListener(listener);
    }

    public void removeCommandMessageListener(CommandMessageListener listener) {
        this.layer.removeCommandListener(listener);
    }

    public void sendLogMessage(LogMessage msg) {
        this.checkMessageLayerConnection();
        msg.setOriginAgentInfo(this.agentInfo);
        this.layer.sendLog(msg, MessageFlag.NO_RELIABILITY);
        if (this.msgAccumulator != null) {
            this.msgAccumulator.accumulateMessage(Bus.LOG, msg);
        }
        for (OutgoingMessageListener l : this.getOutgoingMessageListenersForBus(Bus.LOG)) {
            l.outgoingMessage(msg);
        }
    }

    public void sendStatusMessage(StatusMessage msg) {
        this.sendStatusMessage(msg, new MessageFlag[0]);
    }

    public void sendStatusMessage(StatusMessage msg, MessageFlag ... flags) {
        this.checkMessageLayerConnection();
        msg.setOriginAgentInfo(this.agentInfo);
        this.curLogger.finest("sending status " + msg);
        this.layer.sendStatus(msg, flags);
        if (this.msgAccumulator != null) {
            this.msgAccumulator.accumulateMessage(Bus.STATUS, msg);
        }
        for (OutgoingMessageListener l : this.getOutgoingMessageListenersForBus(Bus.STATUS)) {
            l.outgoingMessage(msg);
        }
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator) {
        this.sendCommandRequest(cmd, originator, true);
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator, boolean checkDestinationExists) {
        String destination;
        this.checkMessageLayerConnection();
        if (this.lockLevelService != null) {
            destination = BusMessagingLayer.parseDestination(cmd.getDestination());
            AgentLock lock = this.lockLevelService.getLockForAgent(destination);
            int desiredLevel = this.lockLevelService.getLevelForAgent(destination);
            if (lock == null && cmd.getBasicCommand().getOptions().hasOption("withLock")) {
                lock = new AgentLockInfo(destination, this.lockLevelService.getUserId(), 0, AgentLockInfo.Status.INFO, "withLock", this.agentInfo);
            }
            cmd.setLockAndLevel(lock, desiredLevel);
        }
        cmd.setOriginAgentInfo(this.agentInfo);
        if (checkDestinationExists) {
            destination = BusMessagingLayer.parseDestination(cmd.getDestination());
            if (!this.getAgentPresenceManager().agentExists(destination)) {
                DestinationsException exc = new DestinationsException(this.agentInfo.getName(), destination);
                this.curLogger.log(Level.FINE, "sending fail (closed){0} to destination {1}", new Object[]{this.agentInfo.getName(), destination});
                this.curLogger.log(Level.WARNING, "destination problem", exc);
                throw exc;
            }
        }
        this.layer.sendCommand(cmd, originator);
        if (this.msgAccumulator != null) {
            this.msgAccumulator.accumulateMessage(Bus.COMMAND, cmd);
        }
        for (OutgoingMessageListener l : this.getOutgoingMessageListenersForBus(Bus.COMMAND)) {
            l.outgoingMessage(cmd);
        }
    }

    public void sendCommandReply(CommandReply reply) {
        this.checkMessageLayerConnection();
        reply.setOriginAgentInfo(this.agentInfo);
        this.layer.reply(reply);
        if (this.msgAccumulator != null) {
            this.msgAccumulator.accumulateMessage(Bus.COMMAND, reply);
        }
        for (OutgoingMessageListener l : this.getOutgoingMessageListenersForBus(Bus.COMMAND)) {
            l.outgoingMessage(reply);
        }
    }

    private void checkMessageLayerConnection() {
        switch (this.connectionStatus) {
            case NOT_CONNECTED: {
                throw new RuntimeException("The CCS Buses have not been connected yet.");
            }
            case DISCONNECTED: {
                throw new RuntimeException("The CCS Buses have been shutdown. It's no longer possible to send messages.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessageLayerConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            switch (this.connectionStatus) {
                case CONNECTED: {
                    return;
                }
                case DISCONNECTED: {
                    throw new RuntimeException("The connection to the messaging layer has been lost");
                }
            }
            try {
                this.connectionLock.wait(1000L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Failed to wait for bus connection", ie);
            }
        }
    }

    public void setCommandExecutor(CommandExecutor executor) {
        this.layer.setCommandExecutor(executor);
    }

    public void setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler h) {
        this.layer.setClusterDeserializationErrorHandler(h);
    }

    public void addOutgoingMessageListenerForBus(OutgoingMessageListener listener, Bus ... bus) {
        for (Bus b : bus) {
            this.getOutgoingMessageListenersForBus(b).add(listener);
        }
    }

    public void removeOutgoingMessageListenerForBus(OutgoingMessageListener listener) {
        for (Bus b : Bus.values()) {
            this.getOutgoingMessageListenersForBus(b).remove(listener);
        }
    }

    private List<OutgoingMessageListener> getOutgoingMessageListenersForBus(Bus bus) {
        return this.outgoingMessageListenersMap.computeIfAbsent(bus, b -> new CopyOnWriteArrayList());
    }

    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;
    }

    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess " + msgAccess.agentInfo.getName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer " + layer);
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer " + messagingLayer);
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents " + localAgents.size());
        for (String agent : localAgents) {
            System.out.println("\t" + agent);
        }
    }

    static byte[] serialize(Serializable object) {
        byte[] byArray;
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);
        try {
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byArray = byteOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ieo) {
                return new byte[0];
            }
        }
        objectOutputStream.close();
        return byArray;
    }

    static double sizeOf(Serializable object) {
        return (double)AgentMessagingLayer.serialize(object).length / 1000.0;
    }

    public static enum ConnectionStatus {
        NOT_CONNECTED,
        CONNECTED,
        DISCONNECTED;

    }

    private class MessageAccumulator {
        private final Map<Bus, BusMessageAccumulator> accums = new ConcurrentHashMap<Bus, BusMessageAccumulator>();

        MessageAccumulator() {
            for (Bus b : Bus.values()) {
                this.accums.put(b, new BusMessageAccumulator(b));
            }
        }

        void accumulateMessage(Bus bus, BusMessage msg) {
            this.accums.get((Object)bus).accumulateMessage(msg);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            for (Bus bus : Bus.values()) {
                sb.append(this.accums.get((Object)bus).toString());
            }
            return sb.toString();
        }
    }

    private class BusMessageAccumulator {
        private final Bus bus;
        private volatile int totalCount = 0;
        private volatile double totalSize = 0.0;
        private final Map<Class, BusMessageAccumulator> classMap = new ConcurrentHashMap<Class, BusMessageAccumulator>();

        BusMessageAccumulator(Bus bus) {
            this.bus = bus;
        }

        void accumulateMessage(BusMessage msg) {
            this.increaseCount();
            double size = AgentMessagingLayer.sizeOf(msg);
            this.increaseSize(size);
            Class<?> msgClass = msg.getClass();
            BusMessageAccumulator msgAccum = this.classMap.computeIfAbsent(msgClass, c -> new BusMessageAccumulator(this.bus));
            msgAccum.increaseCount();
            msgAccum.increaseSize(size);
        }

        private void increaseCount() {
            ++this.totalCount;
        }

        private void increaseSize(double size) {
            this.totalSize += size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.bus + " messages in last minute: ").append(this.totalCount).append(" for total size: ").append(String.format("%.2f", this.totalSize)).append(" Kb \n");
            for (Class c : this.classMap.keySet()) {
                BusMessageAccumulator bma = this.classMap.get(c);
                sb.append("\t").append("Class: ").append(c.getSimpleName()).append(": ").append(bma.totalCount).append(" for total size: ").append(String.format("%.2f", bma.totalSize)).append(" Kb \n");
            }
            return sb.toString();
        }
    }
}

