/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import java.util.List;
import org.influxdb.InfluxDB;
import org.influxdb.annotation.Measurement;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.impl.InfluxDBResultMapper;

public class InfluxDBMapper
extends InfluxDBResultMapper {
    private final InfluxDB influxDB;

    public InfluxDBMapper(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }

    public <T> List<T> query(Query query, Class<T> clazz, String measurementName) {
        QueryResult queryResult = this.influxDB.query(query);
        return this.toPOJO(queryResult, clazz, measurementName);
    }

    public <T> List<T> query(Query query, Class<T> clazz) {
        this.throwExceptionIfMissingAnnotation(clazz);
        QueryResult queryResult = this.influxDB.query(query);
        return this.toPOJO(queryResult, clazz);
    }

    public <T> List<T> query(Class<T> clazz) {
        this.throwExceptionIfMissingAnnotation(clazz);
        String measurement = this.getMeasurementName(clazz);
        String database = this.getDatabaseName(clazz);
        if ("[unassigned]".equals(database)) {
            throw new IllegalArgumentException(Measurement.class.getSimpleName() + " of class " + clazz.getName() + " should specify a database value for this operation");
        }
        QueryResult queryResult = this.influxDB.query(new Query("SELECT * FROM " + measurement, database));
        return this.toPOJO(queryResult, clazz);
    }

    public <T> void save(T model) {
        this.throwExceptionIfMissingAnnotation(model.getClass());
        Class<?> modelType = model.getClass();
        String database = this.getDatabaseName(modelType);
        String retentionPolicy = this.getRetentionPolicy(modelType);
        Point.Builder pointBuilder = Point.measurementByPOJO(modelType).addFieldsFromPOJO(model);
        Point point = pointBuilder.build();
        if ("[unassigned]".equals(database)) {
            this.influxDB.write(point);
        } else {
            this.influxDB.write(database, retentionPolicy, point);
        }
    }
}

