/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.Arrays;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;

public class GenericSubsystemBoot {
    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException("Currently only two arguments are supported: agentType and agentName");
        }
        String agentType = args[0];
        AgentInfo.AgentType type = AgentInfo.AgentType.valueOf((String)agentType.toUpperCase());
        if (type == null) {
            throw new IllegalArgumentException("Invalid agent type: " + type + " Supported values are " + Arrays.asList(AgentInfo.AgentType.values()));
        }
        String agentName = null;
        if (args.length == 2) {
            agentName = args[1];
        }
        GenericSubsystemBoot.startSubsystem(agentName, type);
    }

    public static Subsystem startSubsystem(String agentName, AgentInfo.AgentType type) {
        Subsystem s = new Subsystem(agentName, type);
        s.startAgent();
        return s;
    }
}

