package org.lsst.ccs.localdb.statusdb;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;

/**
 * This batch persister is designed to ingest data as fast as possible.
 * It provides build configuration parameters to control the number of threads
 * allocated for the ingestion and the size of the ingestion queue.
 * 
 * Alerts are raised when the ingestion queue is filling up.
 *
 * @author LSST CCS Team
 */
public abstract class FastBatchPersister<T> extends BatchPersister<T> {
    
    @ConfigurationParameter(category = "build", description = "Number of ingestion threads")
    private int ingestionThreadsPoolSize = 1;

    @ConfigurationParameter(category = "build", description = "Size of the ingestion queue")
    private int ingestionQueueSize = 1;
    

    @Override
    public void build() {
        ingThreadsPoolSize = ingestionThreadsPoolSize;
        ingQueueSize = ingestionQueueSize;
        super.build();
    }    
    
}
