package org.lsst.ccs.localdb.statusdb;

import java.time.Duration;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.startup.HasCommandLineOptions;

/**
 * Subsystem wrapper around a StatusDataPersister object
 */
public class StatusPersisterSubsystem extends Subsystem implements HasCommandLineOptions, HasLifecycle {
    
    private static SessionFactory fac;
    
    private final Properties p = new Properties();
    
    @LookupField(strategy=Strategy.TREE)
    AgentPeriodicTaskService periodicTaskService;
    
    @LookupField(strategy=Strategy.TREE)
    StatusDataPersister statusDataPersister;

    @LookupField(strategy=Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    
    // define the command line options
    private final Options commandLineOptions = new Options();
    
    public StatusPersisterSubsystem()  {
        super("localdb", AgentInfo.AgentType.SERVICE);
        
        Properties inProps = BootstrapResourceUtils.getBootstrapSystemProperties();
        if ( inProps != null ) {
            p.putAll(inProps); 
        }
        commandLineOptions.addOption("u", "update", false, 
                "Start the Trending Ingest Module in update mode.");     
    }

    @Override
    public void build() {
        periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("statistics-publish", 
                () -> {
                    if ( influxDbClientService != null ) {
                        CacheStatistics stats = new CacheStatistics(fac, influxDbClientService);
                    }
                }
        ).withIsFixedRate(true).withPeriod(Duration.ofMinutes(1)));
    }
    
    @Override
    public void init() {
        fac = StatusdbUtils.getSessionFactory(p);
    }
    
    @Override
    public void processCommandLineOptions(String[] args) throws ParseException {
        CommandLineParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, true);
            
            if (line.hasOption("update")) {
                p.setProperty("hibernate.hbm2ddl.auto", "update");
            }

        } catch (Exception e) {
            e.printStackTrace();
            printHelp();
        }
    }

    @Override
    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "localdb", "", commandLineOptions, "", true);
    }
    
    public SessionFactory getSessionFactory() {
        return fac;
    }
    
    
}
