/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import org.junit.Assert;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.localdb.configdb.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationPersisterTest
extends LocaldbTestTemplate {
    private static HibernateDAO dbInterface;
    private static ConfigurationFacade facade;
    private static Agent persister;
    private static Subsystem s;
    private static Agent a;
    private static ConcurrentMessagingUtils cmu;
    private static ConfigurationService sce;
    private static final Predicate<BusMessage<? extends Serializable, ?>> filter;

    public static void setupFacade() throws Exception {
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testconfigdb");
        p.setProperty("hibernate.use_sql_comments", "false");
        p.setProperty("hibernate.show_sql", "false");
        p.setProperty("hibernate.format_sql", "false");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.startAgent();
        cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        s = BootUtils.getSubsystemFromFile((String)"configAgent");
        sce = (ConfigurationService)s.getAgentService(ConfigurationService.class);
        persister = BootUtils.getSubsystemFromFile((String)"localdb");
        dbInterface = new HibernateDAO(sessionFactory);
        facade = new ConfigurationFacade(dbInterface);
    }

    public static void tearDown() throws Exception {
        persister.shutdownAgent();
        s.shutdownAgent();
        a.shutdownAgent();
    }

    public void testGetDescriptions() throws Exception {
        dbInterface.begin();
        AgentDesc ad = new AgentDesc(new AgentInfo("someName", AgentInfo.AgentType.WORKER));
        dbInterface.persist((Object)ad);
        ConfigurationInfo ci = new ConfigurationInfo.Builder().addParameter(ParameterPath.valueOf((String)"main/info"), String.class, "catA", "", true, false, false).updateParameter(ParameterPath.valueOf((String)"main/info"), "info", "info", false).addParameter(ParameterPath.valueOf((String)"main/max"), Integer.TYPE, "catA", "", false, false, false).addParameter(ParameterPath.valueOf((String)"son/max"), Integer.TYPE, "catA", "", false, false, false).build();
        Description desc1 = facade.registerDescription(ad, ci.getAllParameterInfo());
        Assert.assertNotNull((Object)desc1);
        Assert.assertNotEquals((String)"size of parameter description should be >0", (long)0L, (long)desc1.getBaseDescription().getConfigurationParameters().size());
        Assert.assertTrue((String)"id of subsystem description should be > 0", (desc1.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"number of attached configuration parameters : ", (long)2L, (long)desc1.getBaseDescription().getConfigurationParameters().size());
        Assert.assertEquals((String)"number of attached configuration parameters : ", (long)1L, (long)desc1.getFinalValues().size());
        ci = new ConfigurationInfo.Builder().addParameter(ParameterPath.valueOf((String)"main/info"), String.class, "", "", true, false, false).updateParameter(ParameterPath.valueOf((String)"main/info"), "info", "info", false).addParameter(ParameterPath.valueOf((String)"main/max"), Integer.TYPE, "catA", "", false, false, false).addParameter(ParameterPath.valueOf((String)"son/max"), Integer.TYPE, "catB", "", false, false, false).build();
        Description desc2 = facade.registerDescription(ad, ci.getAllParameterInfo());
        Assert.assertTrue((String)"id of subsystem description should be > 0", (desc2.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"the description entity should be different", (long)desc1.getId(), (long)desc2.getId());
        dbInterface.begin();
        Collection distinctCP = dbInterface.getAllConfigurationParameters("someName").values();
        dbInterface.end();
        ArrayList allParms = new ArrayList();
        for (List l : distinctCP) {
            allParms.addAll(l);
        }
        Assert.assertEquals((String)("number of distinct configuration parameters : " + allParms), (long)5L, (long)allParms.size());
        ci = new ConfigurationInfo.Builder().addParameter(ParameterPath.valueOf((String)"main/info"), String.class, "catA", "", true, false, false).updateParameter(ParameterPath.valueOf((String)"main/info"), "info2", "info2", false).addParameter(ParameterPath.valueOf((String)"main/max"), Integer.TYPE, "catA", "", false, false, false).addParameter(ParameterPath.valueOf((String)"son/max"), Integer.TYPE, "catA", "", false, false, false).build();
        Description desc3 = facade.registerDescription(ad, ci.getAllParameterInfo());
        Assert.assertEquals((String)"Base description should be the same", (long)desc1.getBaseDescription().getId(), (long)desc3.getBaseDescription().getId());
        Assert.assertNotEquals((String)"complete descriptions should be different", (long)desc1.getId(), (long)desc3.getId());
        Assert.assertEquals((long)1L, (long)desc3.getFinalValues().size());
        desc3 = facade.registerDescription(ad, ci.getAllParameterInfo());
        Assert.assertEquals((String)"number of descriptions associated to this base description", (long)2L, (long)desc3.getBaseDescription().getCompatibleDescriptions().size());
    }

    public void testConfigurationPersister() throws Exception {
    }

    static {
        filter = BusMessageFilterFactory.embeddedObjectClass(ConfigurationInfo.class).and(BusMessageFilterFactory.messageOrigin((String)"config-agent"));
    }
}

