package org.lsst.ccs.localdb.connection;

import java.util.Properties;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;

/**
 * A Class containing the database parameters.
 * 
 * @author The LSST CCS Team
 */
public class ConnectionParameters implements HasLifecycle {
    
    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String url;
    
    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String username;

    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String password;
    
    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String dialect;
    
    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String driver_class;
    
    private Properties connectionProperties = new Properties();
    
    @Override
    public void init() {
        if ( url == null ) {
            throw new RuntimeException("Database url configuration parameter must be specified.");
        }
        connectionProperties.setProperty("hibernate.connection.url", url);
        
        if ( username != null ) {            
            connectionProperties.setProperty("hibernate.connection.username", username);
        }
        
        if ( password != null ) {            
            connectionProperties.setProperty("hibernate.connection.password", password);
        }

        if ( driver_class != null ) {            
            connectionProperties.setProperty("hibernate.connection.driver_class", driver_class);
        }

        if ( driver_class != null ) {            
            connectionProperties.setProperty("hibernate.dialect", dialect);
        }
    }
    
    public Properties getConnectionProperties() {
        return connectionProperties;
    }
    
}
