package org.lsst.ccs.localdb.configdb;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;

/**
 * A Class containing Database Connection configuration
 * 
 * @author The LSST CCS Team
 */
public class DbConnectionConfig implements HasLifecycle {
    
    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String url;
    
    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String driver;

    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String dialect;

    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String username;

    @ConfigurationParameter(isFinal = true, category = "DbConnection")
    private volatile String password;

    
    @Override
    public void init() {
        System.out.println("Database connection with "+url+" "+driver+" "+dialect+" "+username+" "+password);
    }
    
    
}
