/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.localdb.statusdb.StatDataAccumulator;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.server.Channel;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.DataServer;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class CreateStatDataFromRaw {
    private static final Logger log = Logger.getLogger("org.lsst.ccs.localdb.statusdb");
    private static int N_THREADS = 3;
    private static long tstart = 0L;
    private static long tstop = System.currentTimeMillis();
    private static SessionFactory fac;
    private static TimeRangeBroker timeBroker;
    private static CountDownLatch latch;

    public static void main(String[] args) throws Exception {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("n", "threads_number", true, "Number of parallel threads");
        commandLineOptions.getOption("threads_number").setArgName("THREADS_NUMBER");
        commandLineOptions.addOption("t1", "t_start", true, "time origin");
        commandLineOptions.getOption("t_start").setArgName("T_START");
        commandLineOptions.addOption("t2", "t_stop", true, "end time");
        commandLineOptions.getOption("t_stop").setArgName("T_STOP");
        commandLineOptions.addOption("r", "range", true, "time range");
        commandLineOptions.getOption("range").setArgName("RANGE");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(commandLineOptions, args, false);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "CreateStatDataFromRaw", "", commandLineOptions, "", true);
            return;
        }
        if (line.hasOption("threads_number")) {
            N_THREADS = Integer.parseInt(line.getOptionValue("threads_number"));
        }
        latch = new CountDownLatch(N_THREADS);
        if (line.hasOption("t_start")) {
            tstart = Long.parseLong(line.getOptionValue("t_start"));
        }
        if (line.hasOption("t_stop")) {
            tstop = Long.parseLong(line.getOptionValue("t_stop"));
        }
        long range = 86400000L;
        if (line.hasOption("range")) {
            range = Long.parseLong(line.getOptionValue("range"));
        }
        if (range % 1800000L != 0L) {
            throw new RuntimeException("range must be a multiple of 1800000 (30 min)");
        }
        timeBroker = new TimeRangeBroker(tstart, tstop, range);
        fac = StatusdbUtils.getSessionFactory();
        DataServer d = new DataServer();
        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        try {
            List l = sess.createQuery("from DataDesc").list();
            for (DataDesc dd : l) {
                StatusDataPersister.getStatDescs(dd, sess, log);
            }
            tx.commit();
        }
        catch (Exception ex) {
            throw new RuntimeException("Persisting default statistical data failed. Aborting", ex);
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
        for (int i = 0; i < N_THREADS; ++i) {
            new Thread(new StatDataCompleter("completer-" + i, d)).start();
        }
        latch.await();
        log.info("All done.");
    }

    private static class TimeRangeBroker {
        private final long width;
        private final long end;
        private long tstart;

        TimeRangeBroker(long start, long end, long width) {
            this.tstart = start;
            this.end = end;
            this.width = width;
        }

        synchronized long[] getNextRange() {
            long[] range = new long[2];
            if (this.tstart >= this.end) {
                return null;
            }
            range[0] = this.tstart;
            long tstop = (range[0] + this.width) / this.width * this.width;
            range[1] = tstop >= this.end ? this.end : tstop;
            this.tstart = range[1];
            return range;
        }
    }

    private static class StatDataCompleter
    implements Runnable {
        private final DataServer ds;
        private final DataChannel.DataChannelList data;
        private final StatusDataPersister dataPersister = new StatusDataPersister();
        private final String name;

        StatDataCompleter(String name, DataServer ds) {
            this.name = name;
            this.ds = ds;
            this.data = ds.getChannels(-1L);
        }

        @Override
        public void run() {
            long[] range;
            long start = 0L;
            long stop = 0L;
            while (start < tstop && (range = timeBroker.getNextRange()) != null) {
                start = range[0];
                stop = range[1];
                log.log(Level.INFO, "{0} : processing range [{1}, {2}]", new Object[]{this.name, start, stop});
                for (Channel ch : this.data.list) {
                    try {
                        Session sess = fac.openSession();
                        try {
                            List rawData = this.ds.getRawData(((DataChannel)ch).getId(), start, stop, sess);
                            if (rawData.isEmpty()) continue;
                            log.log(Level.INFO, "{0} : processing data {1}, count : {2}", new Object[]{this.name, ch.getPathAsString(), rawData.size()});
                            Transaction tx = sess.beginTransaction();
                            StatDataAccumulator stP = this.dataPersister.getStatAccumulator();
                            for (RawData rd : rawData) {
                                stP.persist(rd, sess);
                            }
                            stP.flush(sess);
                            tx.commit();
                        }
                        finally {
                            if (sess == null) continue;
                            sess.close();
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "thread " + this.name, e);
                    }
                }
                log.log(Level.INFO, "{0} : done", this.name);
            }
            latch.countDown();
        }
    }
}

