/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.utilities.logging.Logger;

public class KeyQueueExecutor {
    private final String name;
    private final int maxThreads;
    private int threads = 0;
    private final HashSet<String> blockedKeys = new HashSet();
    private final LinkedList<Task> queue = new LinkedList();
    private long taskID = 0L;
    private final HashMap<String, Integer> keyCounts = new HashMap();
    private final ThreadPoolExecutor exec;
    private Logger logger;

    public KeyQueueExecutor(final String name, int maxThreads) {
        this.name = name;
        this.maxThreads = maxThreads;
        ThreadFactory threadFactory = new ThreadFactory(){
            private final ThreadFactory delegate = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setDaemon(true);
                thread.setName(name);
                thread.setUncaughtExceptionHandler((t, x) -> {
                    if (KeyQueueExecutor.this.logger != null) {
                        KeyQueueExecutor.this.logger.error((Object)"Exception thrown by KeyQueueExecutor worker thread. This should not happen.", x);
                    }
                });
                return thread;
            }
        };
        this.exec = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 70L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger;
    }

    public synchronized void shutdown() {
        this.taskID = -1L;
        if (this.queue.isEmpty()) {
            this.exec.shutdown();
        }
    }

    public synchronized void shutdownNow() {
        this.taskID = -1L;
        this.exec.shutdownNow();
        this.queue.clear();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.exec.awaitTermination(timeout, unit);
    }

    public String getName() {
        return this.name;
    }

    public synchronized void execute(Runnable command, String ... keys) {
        if (this.taskID < 0L || this.exec.isShutdown()) {
            throw new RejectedExecutionException("KeyQueueExecutor" + this.name + " is shut down");
        }
        Task task = new Task(command, keys);
        if (this.threads == this.maxThreads || task.isBlocked(this.keyCounts.keySet())) {
            this.queue.addLast(task);
        } else {
            ++this.threads;
            this.blockedKeys.addAll(task.getKeys());
            this.exec.execute(new MasterTask(task));
        }
        for (String key : keys) {
            this.keyCounts.compute(key, (k, v) -> v == null ? 1 : v + 1);
        }
    }

    private synchronized Task finishTask(Task prevTask) {
        this.removeTaskKeys(prevTask);
        List<String> prevKeys = prevTask.getKeys();
        Task out = null;
        if (this.threads == this.maxThreads) {
            out = this.fetchFirstNonBlockedTask();
        } else {
            switch (prevKeys.size()) {
                case 0: {
                    --this.threads;
                    break;
                }
                case 1: {
                    out = this.fetchFirstNonBlockedTask();
                    break;
                }
                default: {
                    int n = this.maxThreads - this.threads;
                    HashSet<String> block = new HashSet<String>(this.blockedKeys);
                    ArrayList<Task> nextTasks = new ArrayList<Task>(n);
                    Iterator it = this.queue.iterator();
                    while (n > 0 && it.hasNext()) {
                        Task task = (Task)it.next();
                        if (!task.isBlocked(block)) {
                            nextTasks.add(task);
                            it.remove();
                            this.blockedKeys.addAll(task.getKeys());
                            --n;
                        }
                        block.addAll(task.getKeys());
                    }
                    if (nextTasks.isEmpty()) {
                        --this.threads;
                        break;
                    }
                    for (int i = 1; i < nextTasks.size(); ++i) {
                        ++this.threads;
                        this.exec.execute(new MasterTask((Task)nextTasks.get(i)));
                    }
                    out = (Task)nextTasks.get(0);
                }
            }
        }
        if (this.taskID < 0L && this.queue.isEmpty()) {
            this.exec.shutdown();
        }
        return out;
    }

    private void removeTaskKeys(Task task) {
        List<String> keys = task.getKeys();
        switch (keys.size()) {
            case 0: {
                break;
            }
            case 1: {
                String key = keys.get(0);
                this.blockedKeys.remove(key);
                this.keyCounts.compute(key, (k, v) -> {
                    int count = v - 1;
                    return count == 0 ? null : Integer.valueOf(count);
                });
                break;
            }
            default: {
                this.blockedKeys.removeAll(keys);
                for (String kk : keys) {
                    this.keyCounts.compute(kk, (k, v) -> {
                        int count = v - 1;
                        return count == 0 ? null : Integer.valueOf(count);
                    });
                }
            }
        }
    }

    private Task fetchFirstNonBlockedTask() {
        HashSet<String> block = new HashSet<String>(this.blockedKeys);
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            Task task = (Task)it.next();
            if (task.isBlocked(block)) {
                block.addAll(task.getKeys());
                continue;
            }
            it.remove();
            this.blockedKeys.addAll(task.getKeys());
            return task;
        }
        --this.threads;
        return null;
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final String[] keys;
        private final long id;

        Task(Runnable runnable, String ... key) {
            this.keys = key;
            this.runnable = runnable;
            this.id = KeyQueueExecutor.this.taskID++;
        }

        List<String> getKeys() {
            return Arrays.asList(this.keys);
        }

        boolean isBlocked(Set<String> block) {
            switch (this.keys.length) {
                case 0: {
                    return false;
                }
                case 1: {
                    return block.contains(this.keys[0]);
                }
            }
            for (String key : this.keys) {
                if (!block.contains(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        public String toString() {
            return "Task " + this.id + " keys: " + Arrays.deepToString(this.keys);
        }
    }

    private class MasterTask
    implements Runnable {
        private Task current;

        MasterTask(Task firstTask) {
            this.current = firstTask;
        }

        @Override
        public void run() {
            block16: {
                try {
                    while (this.current != null) {
                        Thread.currentThread().setName(KeyQueueExecutor.this.name + "_" + String.join((CharSequence)"_", this.current.getKeys()));
                        try {
                            this.current.run();
                        }
                        catch (Throwable x) {
                            if (KeyQueueExecutor.this.logger != null) {
                                KeyQueueExecutor.this.logger.error((Object)("Exception thrown by a task submitted to KeyQueueExecutor " + KeyQueueExecutor.this.name), x);
                            }
                        }
                        finally {
                            try {
                                Thread.currentThread().setName(KeyQueueExecutor.this.name);
                            }
                            catch (Throwable throwable) {}
                        }
                        this.current = KeyQueueExecutor.this.finishTask(this.current);
                    }
                }
                catch (Throwable t) {
                    if (KeyQueueExecutor.this.logger == null) break block16;
                    KeyQueueExecutor.this.logger.error((Object)("Exception in MasterTask of KeyQueueExecutor " + KeyQueueExecutor.this.name), t);
                }
            }
        }
    }
}

