/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.junit.Assert;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.localdb.statusdb.TrendingPublisherAgent;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataGroup;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.AgentStateService;

public class TrendingPublisherTest
extends LocaldbTestTemplate {
    private Agent persister;
    private static final String trendingPublisherName = "trendingSub";
    private static String[][] tempTrendingNames;

    public static void setupClass() {
        tempTrendingNames = new String[][]{{trendingPublisherName, "temp", "K"}, {trendingPublisherName, "temp2/tempData1", "K"}, {trendingPublisherName, "temp2/tempData2", "F"}, {trendingPublisherName, "temp2/tempData3", "C"}, {trendingPublisherName, "t1", "K"}, {trendingPublisherName, "t2", "C"}};
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testdb");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.connection.password", "");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public void init() throws Exception {
        int[] customBinnings;
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        DataDesc dd = new DataDesc();
        dd.setDataType("trending");
        dd.setDataPath(new DataPath(trendingPublisherName, "t1"));
        DataGroup dg = new DataGroup(trendingPublisherName, "t1");
        HashMap<DataPath, DataDesc> map = new HashMap<DataPath, DataDesc>();
        map.put(dd.getDataPath(), dd);
        dg.setMembers(map);
        sess.persist((Object)dd);
        sess.persist((Object)dg);
        for (int b : customBinnings = new int[]{3000, 30000, 300000, 1800000}) {
            StatDesc sd = new StatDesc();
            sd.setDataDesc(dd);
            sd.setTimeBinWidth((long)b);
            sess.persist((Object)sd);
        }
        tx.commit();
        sess.close();
        this.persister = BootUtils.getSubsystemFromFile((String)"localdb");
        this.persister.startAgent();
    }

    public void tearDown() throws Exception {
        this.persister.shutdownAgent();
    }

    public void testTrendingOverBuses() throws Exception {
        int nPub = 1000;
        int nThreads = 1;
        int intervalMillis = 40;
        int trendingPublicationTime = nPub * intervalMillis + 10000;
        TrendingPublisherAgent trendingDataPublisher = new TrendingPublisherAgent(trendingPublisherName);
        trendingDataPublisher.startAgent();
        ((AgentStateService)trendingDataPublisher.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 30L, TimeUnit.MILLISECONDS);
        trendingDataPublisher.fireTemperatureDataPublication(nPub, nThreads, intervalMillis);
        try {
            ((AgentStateService)trendingDataPublisher.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)TrendingPublisherAgent.State.IDLE), (long)trendingPublicationTime, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("subsystem did not stop within specified timeout " + trendingPublicationTime), (boolean)false);
        }
        Thread.sleep(10000L);
        Thread.sleep(15000L);
        Session sess = sessionFactory.openSession();
        Query qrd = sess.createQuery("select count(*) from RawData rd where rd.dataDesc.dataPath.agentName=:agentName and rd.dataDesc.dataPath.dataName=:dataName");
        Query qmdd = sess.createQuery("select mdd.value from MetaDataData mdd where mdd.dataGroup.agentName=:agentName and mdd.dataGroup.groupName=:groupName and mdd.name=:metadataname and mdd.endTime <= 0");
        for (int i = 0; i < tempTrendingNames.length; ++i) {
            qrd.setString("agentName", tempTrendingNames[i][0]);
            qrd.setString("dataName", tempTrendingNames[i][1]);
            int res = (int)((Long)qrd.uniqueResult()).longValue();
            Assert.assertEquals((String)(tempTrendingNames[i][0] + "/" + tempTrendingNames[i][1]), (long)nPub, (long)res);
            qmdd.setString("agentName", tempTrendingNames[i][0]);
            qmdd.setString("groupName", tempTrendingNames[i][1]);
            qmdd.setString("metadataname", "unit");
            String unit = (String)qmdd.uniqueResult();
            Assert.assertEquals((String)("metadata for : " + tempTrendingNames[i][0] + "/" + tempTrendingNames[i][1]), (Object)tempTrendingNames[i][2], (Object)unit);
        }
        Query q = sess.createQuery("from StatDesc sd where sd.dataDesc.dataPath.agentName=:agentName and sd.dataDesc.dataPath.dataName=:dataName");
        q.setString("agentName", trendingPublisherName);
        q.setString("dataName", "t1");
        List statDescs = q.list();
        for (StatDesc statdesc : statDescs) {
            q = sess.createQuery("from StatData sd where sd.statDesc.id=:statDescId");
            q.setLong("statDescId", statdesc.getId());
            List statdatas = q.list();
            int tot = 0;
            long endTime = 0L;
            for (StatData statdata : statdatas) {
                tot += statdata.getN();
                if (statdata.getStatTimeInterval().getEndTime() <= endTime) continue;
                endTime = statdata.getStatTimeInterval().getEndTime();
            }
            long nPubWithStats = (Long)sess.createQuery("select count(*) from RawData rd where rd.dataDesc=:dataDesc and rd.time <:endTime").setEntity("dataDesc", (Object)statdesc.getDataDesc()).setLong("endTime", endTime).uniqueResult();
            Assert.assertEquals((String)("unbinned data with width : " + statdesc.getTimeBinWidth()), (long)nPubWithStats, (long)tot);
        }
        trendingDataPublisher.shutdownAgent();
        Thread.sleep(5000L);
    }
}

