/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.Query;
import org.hibernate.Session;
import org.junit.Assert;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.localdb.statusdb.AlertPublisherSubsystem;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.ClearedAlertData;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.localdb.statusdb.model.StateChangeNotificationData;
import org.lsst.ccs.localdb.statusdb.server.AlertEvent;
import org.lsst.ccs.localdb.statusdb.server.AlertInfo;
import org.lsst.ccs.localdb.statusdb.server.DataServer;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;

public class AlertPublisherTest
extends LocaldbTestTemplate {
    private Agent persister;
    private static DataServer ds;
    private static final String alertPublisherName = "alertRaiser";
    private static final Map<String, AlertProfile> alertProfiles;

    public static void setupClass() {
        alertProfiles.put("AL001", new AlertProfile("AL001", "AL #001", "some Temp is high", 20, 10, 5, true, 90));
        alertProfiles.put("AL002", new AlertProfile("AL002", "AL #002", "some Pressure is off", 20, 12, 5, false, 90));
        alertProfiles.put("AL003", new AlertProfile("AL003", "AL #003", "no idea", 20, 10, 5, false, 90));
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testdb");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.connection.password", "");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public void init() throws Exception {
        this.persister = BootUtils.getSubsystemFromFile((String)"localdb");
        this.persister.startAgent();
        ds = new DataServer();
    }

    public void tearDown() throws Exception {
        this.persister.shutdownAgent();
    }

    public void testTrendingOverBuses() throws Exception {
        int alertPublicationTime = alertProfiles.values().stream().mapToInt(ap -> ap.interval * ap.total).max().getAsInt() + 10000;
        AlertPublisherSubsystem alertRaiser = new AlertPublisherSubsystem(alertPublisherName);
        alertRaiser.startAgent();
        ((AgentStateService)alertRaiser.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 30L, TimeUnit.SECONDS);
        alertRaiser.fireAlertsRaising(alertProfiles.values());
        try {
            ((AgentStateService)alertRaiser.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)AlertPublisherSubsystem.State.IDLE), (long)alertPublicationTime, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"subsystem did not stop within specified timeout ", (boolean)false);
        }
        Thread.sleep(10000L);
        Session sess = sessionFactory.openSession();
        List ais = AlertPublisherTest.ds.getAlertInfo((String)alertPublisherName).list;
        Object[] alertIds = (String[])ais.stream().map(AlertInfo::getAlertId).toArray(String[]::new);
        Assert.assertEquals((String)"number of different alert ids", (long)3L, (long)ais.size());
        Assert.assertEquals((String)Arrays.toString(alertIds), (long)alertProfiles.size(), (long)ais.size());
        for (Object ad : ais) {
            Assert.assertEquals((Object)alertPublisherName, (Object)ad.getSubsystemName());
            AlertProfile ap3 = alertProfiles.get(ad.getAlertId());
            Assert.assertNotNull((Object)ap3);
            Assert.assertEquals((String)"AlertDesc description", (Object)ap3.alertDesc, (Object)ad.getAlertDescription());
            Assert.assertEquals((String)"AlertDesc Id", (Object)ap3.alertId, (Object)ad.getAlertId());
        }
        HashMap<String, Integer> NActiveAlerts = new HashMap<String, Integer>();
        for (Object ai : ais) {
            List list = AlertPublisherTest.ds.getActiveAlerts(Arrays.asList(new Long[]{Long.valueOf((long)ai.getId())})).list;
            Assert.assertEquals((long)6L, (long)list.size());
            NActiveAlerts.put(ai.getAlertId(), list.size());
            for (AlertEvent ae : list) {
                Assert.assertEquals((String)"Alert Description", (Object)AlertPublisherTest.alertProfiles.get((Object)ai.getAlertId()).alertCause, (Object)ae.getCause());
            }
        }
        int nCleared = 0;
        for (AlertProfile alertProfile : alertProfiles.values()) {
            if (!alertProfile.clear.booleanValue()) continue;
            ++nCleared;
            ((AlertService)alertRaiser.getAgentService(AlertService.class)).clearAlerts(new String[]{alertProfile.alertId});
        }
        sess.close();
        Thread.sleep(15000L);
        sess = sessionFactory.openSession();
        Query q = sess.createQuery("from RaisedAlertData arad where arad.agentDesc.agentName=:name and arad.alertDesc.alertId=:id and arad.active=true").setString("name", alertPublisherName);
        for (Object ai : ais) {
            Object arad22;
            q.setString("id", ai.getAlertId());
            List res = q.list();
            AlertProfile ap2 = alertProfiles.get(ai.getAlertId());
            for (Object arad22 : res) {
                ClearedAlertData cad = arad22.getClearingAlert();
                if (ap2.clear.booleanValue()) {
                    Assert.assertNotNull((Object)cad);
                    Assert.assertEquals((Object)ap2.alertId, (Object)cad.getAlertDesc().getAlertId());
                    continue;
                }
                Assert.assertNull((Object)cad);
            }
            List activeAlerts = AlertPublisherTest.ds.getActiveAlerts(Arrays.asList(new Long[]{Long.valueOf((long)ai.getId())})).list;
            arad22 = activeAlerts.iterator();
            while (arad22.hasNext()) {
                AlertEvent ae = (AlertEvent)arad22.next();
                Assert.assertEquals((String)(ae.getAlertId() + " clear status : "), (Object)ap2.clear, (Object)ae.isCleared());
            }
        }
        q = sess.createQuery("from ClearedAlertData");
        List list = q.list();
        Assert.assertEquals((long)nCleared, (long)list.size());
        for (ClearedAlertData cad : list) {
            AlertProfile ap2 = alertProfiles.get(cad.getAlertDesc().getAlertId());
            Assert.assertTrue((String)(ap2.alertId + " should not have been cleared"), (boolean)ap2.clear);
            Assert.assertEquals((String)("number of cleared alerts for : " + ap2.alertId), (long)((Integer)NActiveAlerts.get(ap2.alertId)).intValue(), (long)cad.getClearedAlerts().size());
        }
        Query stateQuery = sess.createQuery("select arad.agentState from RaisedAlertData arad where arad.active=true");
        List resStateQuery = stateQuery.list();
        for (Object agst : resStateQuery) {
            Map externalStates = ((StateBundleDesc)agst.getComponentStates().get("")).getComponentStates();
            Assert.assertEquals((String)"size of inner states : ", (long)6L, (long)externalStates.size());
            String enumClassName = AlertPublisherSubsystem.State.class.getName();
            InnerStateDesc isd = (InnerStateDesc)externalStates.get(enumClassName);
            Assert.assertNotNull((String)("could not find value for key : " + enumClassName), (Object)isd);
        }
        alertRaiser.shutdownAgent();
        try {
            ((AgentStateService)alertRaiser.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"subsystem did not stop within specified timeout", (boolean)false);
        }
        Thread.sleep(5000L);
        List activeAlerts = AlertPublisherTest.ds.getActiveAlerts(null).list;
        Assert.assertEquals((String)"there should be no active alerts once the subsystem is shut down", (long)0L, (long)activeAlerts.size());
        for (AlertInfo ai : ais) {
            List allHistory = AlertPublisherTest.ds.getAlertHistories(Arrays.asList(new Long[]{Long.valueOf((long)ai.getId())}), (long)0L, (long)System.currentTimeMillis()).list;
            Assert.assertEquals((String)ai.getAlertId(), (long)((Integer)NActiveAlerts.get(ai.getAlertId())).intValue(), (long)allHistory.size());
        }
        sess.close();
        sess = sessionFactory.openSession();
        q = sess.createQuery("from StateChangeNotificationData scnd where scnd.agentDesc.agentName=:name").setString("name", alertPublisherName);
        List scnds = q.list();
        Assert.assertTrue((scnds.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < scnds.size() - 1; ++i) {
            Assert.assertEquals((Object)((StateChangeNotificationData)scnds.get(i + 1)).getOldState(), (Object)((StateChangeNotificationData)scnds.get(i)).getNewState());
        }
        sess.close();
    }

    static {
        alertProfiles = new HashMap<String, AlertProfile>();
    }

    static class AlertProfile {
        final String alertId;
        final String alertDesc;
        final String alertCause;
        final int total;
        final int nWarns;
        final int nAlarms;
        final Boolean clear;
        final int interval;

        AlertProfile(String alertId, String alertDesc, String alertCause, int total, int nWarns, int nAlarms, boolean clear, int interval) {
            this.alertId = alertId;
            this.alertDesc = alertDesc;
            this.alertCause = alertCause;
            this.total = total;
            this.nWarns = nWarns;
            this.nAlarms = nAlarms;
            this.clear = clear;
            this.interval = interval;
        }
    }
}

