/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.AlertPublisherTest;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;

public class AlertPublisherSubsystem
extends Subsystem
implements HasLifecycle {
    private CyclicBarrier barrier;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agetStateService;

    public AlertPublisherSubsystem(String name) {
        super(name, AgentInfo.AgentType.WORKER);
    }

    public void start() {
        this.agetStateService.updateAgentState(new Enum[]{State.IDLE});
    }

    @Command
    void fireAlertsRaising(Collection<AlertPublisherTest.AlertProfile> alertProfiles) throws Exception {
        if (alertProfiles.isEmpty()) {
            return;
        }
        this.agetStateService.updateAgentState(new Enum[]{State.BUSY});
        int nAlerts = alertProfiles.size();
        this.barrier = new CyclicBarrier(nAlerts, () -> this.agetStateService.updateAgentState(new Enum[]{State.IDLE}));
        for (AlertPublisherTest.AlertProfile ap : alertProfiles) {
            new Thread(new AlertPublisher(ap)).start();
        }
    }

    private class AlertPublisher
    implements Runnable {
        private final AlertPublisherTest.AlertProfile ap;
        private final Alert alert;

        AlertPublisher(AlertPublisherTest.AlertProfile ap) {
            this.ap = ap;
            this.alert = new Alert(this.ap.alertId, this.ap.alertDesc);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.ap.total; ++i) {
                AlertState state = AlertState.WARNING;
                if (i > this.ap.nWarns && i < this.ap.nWarns + this.ap.nAlarms) {
                    state = AlertState.ALARM;
                }
                ((AlertService)AlertPublisherSubsystem.this.getAgentService(AlertService.class)).raiseAlert(this.alert, state, this.ap.alertCause);
                try {
                    Thread.sleep(this.ap.interval);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                AlertPublisherSubsystem.this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static enum State {
        IDLE,
        BUSY;

    }
}

