/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import org.lsst.ccs.Agent;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentService;

public final class AgentSignalHandlerService
implements AgentService,
ServiceLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    private ComponentLookup lookup;

    @Override
    public String getAgentServiceName() {
        return "signalHandlerService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void preInit() {
        this.lookup = this.agent.getComponentLookup();
        this.agentCommandDictionaryService.addCommandSetToObject(new AgentSignalHandlingCommandsForInnerNode(this.agent), this.agent);
        TreeWalkerUtils.proceduralWalk(this.lookup, null, SignalHandler.class, sh -> {
            if (sh != this.agent) {
                String componentFullPath = this.lookup.getComponentNodeForObject(sh).getPath();
                this.agentCommandDictionaryService.addCommandSetToObject(new AgentSignalHandlingCommandsForInnerNode(sh), componentFullPath);
            }
        }, null);
    }

    public class AgentSignalHandlingCommandsForInnerNode {
        private final ComponentNode rootNode;

        AgentSignalHandlingCommandsForInnerNode(Object rootObject) {
            this.rootNode = AgentSignalHandlerService.this.lookup.getComponentNodeForObject(rootObject);
        }

        @Command(description="Abort current action", type=Command.CommandType.SIGNAL, category=Command.CommandCategory.CORE)
        public void abort() {
            AgentSignalHandlerService.this.agent.getLogger().fine((Object)("Agent " + AgentSignalHandlerService.this.agent.getName() + ": abort requested"));
            this.internalSendSignal(new Signal(SignalLevel.HALT));
        }

        @Command(description="Stop current action with an expected max delay", type=Command.CommandType.SIGNAL, category=Command.CommandCategory.CORE)
        public void stop(@Argument(name="timeHint", defaultValue="-1") long timeHint) throws HardwareException {
            AgentSignalHandlerService.this.agent.getLogger().fine((Object)("Agent " + AgentSignalHandlerService.this.agent.getName() + ": stop requested with " + timeHint));
            this.internalSendSignal(new Signal(SignalLevel.STOP, timeHint));
        }

        private void internalSendSignal(Signal signal) {
            TreeWalkerUtils.treeWalk(AgentSignalHandlerService.this.agent.getComponentLookup(), this.rootNode, SignalHandler.class, sh -> sh.signal(signal), null);
        }
    }
}

