/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v1.util.IteratorUtils;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class SetUtils {
    public static Set oneElementUnmodifiableSet(final Object elem) {
        return new AbstractSet(){

            public Iterator iterator() {
                return IteratorUtils.oneElementUnmodifiableIterator(elem);
            }

            public int size() {
                return 1;
            }

            public boolean isEmpty() {
                return false;
            }

            public boolean contains(Object o) {
                return o == elem;
            }
        };
    }

    public static Set setFromArray(Object[] array) {
        HashSet<Object> out = new HashSet<Object>();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            out.add(array[i]);
        }
        return out;
    }

    public static boolean equivalentDisregardingSort(Set a, Set b) {
        return a.containsAll(b) && b.containsAll(a);
    }

    public static int hashContentsDisregardingSort(Set s) {
        int out = 0;
        for (Object o : s) {
            if (o == null) continue;
            out ^= o.hashCode();
        }
        return out;
    }
}

