import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.localdb.statusdb.StatusPersisterSubsystem;
import org.lsst.ccs.localdb.statusdb.QueryMonitor;
import org.lsst.ccs.localdb.statusdb.StatusPersister;
import org.lsst.ccs.localdb.statusdb.StatDataPersister;
import org.lsst.ccs.localdb.statusdb.MetaDataPersister;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo.AgentType;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;

CCSBuilder builder = []

builder.
    localdb(StatusPersisterSubsystem) {
    
    
    "queryMonitor"(QueryMonitor)
    
    "status-persister"(StatusPersister)
    
    "data-persister"(StatusDataPersister)
    
    //StatDataPersister for a specific agent type
    for (AgentCategory category : AgentCategory.values()) {
        String categoryName = category.name();
        "statdata-persister-${categoryName}" (StatDataPersister, predicate:new AgentPropertyPredicate("[agentCategory:${categoryName}]"))        
    }

    //Default StatDataPersister (catch all)
    "statdata-persister" (StatDataPersister)        
    
    //MetaDataPersister for a specific agent type
    for (AgentCategory category : AgentCategory.values()) {
        String categoryName = category.name();
        "metadata-persister-${categoryName}" (MetaDataPersister, predicate:new AgentPropertyPredicate("[agentCategory:${categoryName}]"))        
    }
    
    //Default MetaDataPersister (catch all)
    "metadata-persister" (MetaDataPersister)

}
